/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clans.libs.adventure.adventure.text.minimessage.tag.standard;

import java.util.HashMap;
import java.util.Map;
import me.loving11ish.clans.libs.adventure.adventure.text.format.NamedTextColor;
import me.loving11ish.clans.libs.adventure.adventure.text.format.Style;
import me.loving11ish.clans.libs.adventure.adventure.text.format.StyleBuilderApplicable;
import me.loving11ish.clans.libs.adventure.adventure.text.format.TextColor;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.Context;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.internal.serializer.SerializableResolver;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.internal.serializer.StyleClaim;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.tag.Tag;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ColorTagResolver
implements SerializableResolver.Single,
TagResolver {
    private static final String COLOR_3 = "c";
    private static final String COLOR_2 = "colour";
    private static final String COLOR = "color";
    static final TagResolver INSTANCE = new ColorTagResolver();
    private static final StyleClaim<TextColor> STYLE = StyleClaim.claim("color", Style::color, (textColor, tokenEmitter) -> {
        if (textColor instanceof NamedTextColor) {
            tokenEmitter.tag(NamedTextColor.NAMES.key((NamedTextColor)textColor));
            return;
        }
        tokenEmitter.tag(textColor.asHexString());
    });
    private static final Map<String, TextColor> COLOR_ALIASES = new HashMap<String, TextColor>();

    private static boolean isColorOrAbbreviation(String string) {
        return string.equals(COLOR) || string.equals(COLOR_2) || string.equals(COLOR_3);
    }

    ColorTagResolver() {
    }

    @Override
    @Nullable
    public final Tag resolve(@NotNull String object, @NotNull ArgumentQueue argumentQueue, @NotNull Context context) {
        if (!this.has((String)object)) {
            return null;
        }
        if (ColorTagResolver.isColorOrAbbreviation((String)object)) {
            object = argumentQueue.popOr("Expected to find a color parameter: <name>|#RRGGBB").lowerValue();
        }
        object = ColorTagResolver.resolveColor((String)object, context);
        return Tag.styling(new StyleBuilderApplicable[]{object});
    }

    @Nullable
    static TextColor resolveColorOrNull(String object) {
        object = COLOR_ALIASES.containsKey(object) ? COLOR_ALIASES.get(object) : (((String)object).charAt(0) == '#' ? TextColor.fromHexString((String)object) : (TextColor)NamedTextColor.NAMES.value((String)object));
        return object;
    }

    @NotNull
    static TextColor resolveColor(@NotNull String string, @NotNull Context context) {
        TextColor textColor = ColorTagResolver.resolveColorOrNull(string);
        if (textColor == null) {
            throw context.newException(String.format("Unable to parse a color from '%s'. Please use named colours or hex (#RRGGBB) colors.", string));
        }
        return textColor;
    }

    @Override
    public final boolean has(@NotNull String string) {
        return ColorTagResolver.isColorOrAbbreviation(string) || NamedTextColor.NAMES.value(string) != null || COLOR_ALIASES.containsKey(string) || TextColor.fromHexString(string) != null;
    }

    @Override
    @Nullable
    public final StyleClaim<?> claimStyle() {
        return STYLE;
    }

    static {
        COLOR_ALIASES.put("dark_grey", NamedTextColor.DARK_GRAY);
        COLOR_ALIASES.put("grey", NamedTextColor.GRAY);
    }
}

