/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clans.libs.adventure.adventure.text.minimessage.tag.resolver;

import java.text.ChoiceFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Locale;
import me.loving11ish.clans.libs.adventure.adventure.text.Component;
import me.loving11ish.clans.libs.adventure.adventure.text.ComponentLike;
import me.loving11ish.clans.libs.adventure.adventure.text.JoinConfiguration;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.tag.Tag;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.tag.TagPattern;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;

public final class Formatter {
    private Formatter() {
    }

    @NotNull
    public static TagResolver number(@TagPattern @NotNull String string, @NotNull Number number) {
        return TagResolver.resolver(string, (object, context) -> {
            if (object.hasNext()) {
                String string = object.pop().value();
                if (object.hasNext()) {
                    object = object.pop().value();
                    object = new DecimalFormat((String)object, new DecimalFormatSymbols(Locale.forLanguageTag(string)));
                } else {
                    object = string.contains(".") ? new DecimalFormat(string, DecimalFormatSymbols.getInstance()) : DecimalFormat.getInstance(Locale.forLanguageTag(string));
                }
            } else {
                object = DecimalFormat.getInstance();
            }
            return Tag.inserting(context.deserialize(((Format)object).format(number)));
        });
    }

    @NotNull
    public static TagResolver date(@TagPattern @NotNull String string, @NotNull TemporalAccessor temporalAccessor) {
        return TagResolver.resolver(string, (object, context) -> {
            object = object.popOr("Format expected.").value();
            return Tag.inserting(context.deserialize(DateTimeFormatter.ofPattern((String)object).format(temporalAccessor)));
        });
    }

    @NotNull
    public static TagResolver choice(@TagPattern @NotNull String string, Number number) {
        return TagResolver.resolver(string, (object, context) -> {
            object = object.popOr("Format expected.").value();
            object = new ChoiceFormat((String)object);
            return Tag.inserting(context.deserialize(((Format)object).format(number)));
        });
    }

    public static TagResolver booleanChoice(@TagPattern @NotNull String string, boolean bl) {
        return TagResolver.resolver(string, (object, context) -> {
            String string = object.popOr("True format expected.").value();
            object = object.popOr("False format expected.").value();
            return Tag.inserting(context.deserialize((String)(bl ? string : object)));
        });
    }

    public static TagResolver joining(@TagPattern @NotNull String string, @NotNull Iterable<? extends ComponentLike> iterable) {
        return TagResolver.resolver(string, (argumentQueue, context) -> {
            Object object;
            if (!argumentQueue.hasNext()) {
                return Tag.inserting(Component.join(JoinConfiguration.noSeparators(), iterable));
            }
            Object object2 = argumentQueue.pop().value();
            object2 = JoinConfiguration.builder().separator(context.deserialize((String)object2));
            if (argumentQueue.hasNext()) {
                object = argumentQueue.pop().value();
                object2.lastSeparator(context.deserialize((String)object));
            }
            if (argumentQueue.hasNext()) {
                object = argumentQueue.pop().value();
                object2.lastSeparatorIfSerial(context.deserialize((String)object));
            }
            object = (JoinConfiguration)object2.build();
            return Tag.inserting(Component.join((JoinConfiguration)object, iterable));
        });
    }

    public static TagResolver joining(@TagPattern @NotNull String string, ComponentLike ... componentLikeArray) {
        return Formatter.joining(string, Arrays.asList(componentLikeArray));
    }
}

