/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clans.libs.adventure.adventure.text.minimessage.tag.resolver;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import me.loving11ish.clans.libs.adventure.adventure.text.Component;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.internal.serializer.ClaimConsumer;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.internal.serializer.SerializableResolver;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.tag.Tag;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.tag.resolver.MappableResolver;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CachingTagResolver
implements SerializableResolver,
MappableResolver,
TagResolver.WithoutArguments {
    private static final Tag NULL_REPLACEMENT = () -> {
        throw new UnsupportedOperationException("no-op null tag");
    };
    private final Map<String, Tag> cache = new HashMap<String, Tag>();
    private final TagResolver.WithoutArguments resolver;

    CachingTagResolver(TagResolver.WithoutArguments withoutArguments) {
        this.resolver = withoutArguments;
    }

    private Tag query(@NotNull String string) {
        return this.cache.computeIfAbsent(string, object -> {
            if ((object = this.resolver.resolve((String)object)) == null) {
                return NULL_REPLACEMENT;
            }
            return object;
        });
    }

    @Override
    @Nullable
    public final Tag resolve(@NotNull String object) {
        if ((object = this.query((String)object)) == NULL_REPLACEMENT) {
            return null;
        }
        return object;
    }

    @Override
    public final boolean has(@NotNull String string) {
        return this.query(string) != NULL_REPLACEMENT;
    }

    @Override
    public final boolean contributeToMap(@NotNull Map<String, Tag> map) {
        if (this.resolver instanceof MappableResolver) {
            return ((MappableResolver)((Object)this.resolver)).contributeToMap(map);
        }
        return false;
    }

    @Override
    public final void handle(@NotNull Component component, @NotNull ClaimConsumer claimConsumer) {
        if (this.resolver instanceof SerializableResolver) {
            ((SerializableResolver)((Object)this.resolver)).handle(component, claimConsumer);
        }
    }

    public final boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CachingTagResolver)) {
            return false;
        }
        object = (CachingTagResolver)object;
        return Objects.equals(this.resolver, ((CachingTagResolver)object).resolver);
    }

    public final int hashCode() {
        return Objects.hash(this.resolver);
    }
}

