/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clans.libs.adventure.adventure.text.minimessage;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import me.loving11ish.clans.libs.adventure.adventure.pointer.Pointered;
import me.loving11ish.clans.libs.adventure.adventure.text.Component;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.ArgumentQueueImpl;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.Context;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.MiniMessage;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.ParsingException;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.internal.parser.ParsingExceptionImpl;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.internal.parser.Token;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.internal.parser.node.TagPart;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.tag.Tag;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ContextImpl
implements Context {
    private static final Token[] EMPTY_TOKEN_ARRAY = new Token[0];
    private final boolean strict;
    private final boolean emitVirtuals;
    private final Consumer<String> debugOutput;
    private String message;
    private final MiniMessage miniMessage;
    @Nullable
    private final Pointered target;
    private final TagResolver tagResolver;
    private final UnaryOperator<String> preProcessor;
    private final UnaryOperator<Component> postProcessor;

    ContextImpl(boolean bl, boolean bl2, Consumer<String> consumer, String string, MiniMessage miniMessage, @Nullable Pointered pointered, @Nullable TagResolver tagResolver, @Nullable UnaryOperator<String> unaryOperator, @Nullable UnaryOperator<Component> unaryOperator2) {
        this.strict = bl;
        this.emitVirtuals = bl2;
        this.debugOutput = consumer;
        this.message = string;
        this.miniMessage = miniMessage;
        this.target = pointered;
        this.tagResolver = tagResolver == null ? TagResolver.empty() : tagResolver;
        this.preProcessor = unaryOperator == null ? UnaryOperator.identity() : unaryOperator;
        this.postProcessor = unaryOperator2 == null ? UnaryOperator.identity() : unaryOperator2;
    }

    public boolean strict() {
        return this.strict;
    }

    @Override
    public boolean emitVirtuals() {
        return this.emitVirtuals;
    }

    public Consumer<String> debugOutput() {
        return this.debugOutput;
    }

    @NotNull
    public String message() {
        return this.message;
    }

    void message(@NotNull String string) {
        this.message = string;
    }

    @NotNull
    public TagResolver extraTags() {
        return this.tagResolver;
    }

    public UnaryOperator<Component> postProcessor() {
        return this.postProcessor;
    }

    public UnaryOperator<String> preProcessor() {
        return this.preProcessor;
    }

    @Override
    @Nullable
    public Pointered target() {
        return this.target;
    }

    @Override
    @NotNull
    public Pointered targetOrThrow() {
        if (this.target == null) {
            throw this.newException("A target is required for this deserialization attempt");
        }
        return this.target;
    }

    @Override
    @NotNull
    public <T extends Pointered> T targetAsType(@NotNull Class<T> clazz) {
        if (Objects.requireNonNull(clazz, "targetClass").isInstance(this.target)) {
            return (T)((Pointered)clazz.cast(this.target));
        }
        throw this.newException("A target with type " + clazz.getSimpleName() + " is required for this deserialization attempt");
    }

    @Override
    @NotNull
    public Component deserialize(@NotNull String string) {
        return this.deserializeWithOptionalTarget(Objects.requireNonNull(string, "message"), this.tagResolver);
    }

    @Override
    @NotNull
    public Component deserialize(@NotNull String string, @NotNull TagResolver tagResolver) {
        Objects.requireNonNull(string, "message");
        tagResolver = TagResolver.builder().resolver(this.tagResolver).resolver(tagResolver).build();
        return this.deserializeWithOptionalTarget(string, tagResolver);
    }

    @Override
    @NotNull
    public Component deserialize(@NotNull String string, TagResolver ... object) {
        Objects.requireNonNull(string, "message");
        object = TagResolver.builder().resolver(this.tagResolver).resolvers((TagResolver)object).build();
        return this.deserializeWithOptionalTarget(string, (TagResolver)object);
    }

    @Override
    @NotNull
    public ParsingException newException(@NotNull String string) {
        return new ParsingExceptionImpl(string, this.message, null, false, EMPTY_TOKEN_ARRAY);
    }

    @Override
    @NotNull
    public ParsingException newException(@NotNull String string, @NotNull ArgumentQueue argumentQueue) {
        return new ParsingExceptionImpl(string, this.message, null, false, ContextImpl.tagsToTokens(((ArgumentQueueImpl)argumentQueue).args));
    }

    @Override
    @NotNull
    public ParsingException newException(@NotNull String string, @Nullable Throwable throwable, @NotNull ArgumentQueue argumentQueue) {
        return new ParsingExceptionImpl(string, this.message, throwable, false, ContextImpl.tagsToTokens(((ArgumentQueueImpl)argumentQueue).args));
    }

    @NotNull
    private Component deserializeWithOptionalTarget(@NotNull String string, @NotNull TagResolver tagResolver) {
        if (this.target != null) {
            return this.miniMessage.deserialize(string, this.target, tagResolver);
        }
        return this.miniMessage.deserialize(string, tagResolver);
    }

    private static Token[] tagsToTokens(List<? extends Tag.Argument> list) {
        Token[] tokenArray = new Token[list.size()];
        int n2 = tokenArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            tokenArray[i2] = ((TagPart)list.get(i2)).token();
        }
        return tokenArray;
    }
}

