/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clans.libs.adventure.adventure.text;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import me.loving11ish.clans.libs.adventure.adventure.internal.Internals;
import me.loving11ish.clans.libs.adventure.adventure.text.ComponentLike;
import me.loving11ish.clans.libs.adventure.adventure.text.PatternReplacementResult;
import me.loving11ish.clans.libs.adventure.adventure.text.TextComponent;
import me.loving11ish.clans.libs.adventure.adventure.text.TextReplacementConfig;
import me.loving11ish.clans.libs.adventure.adventure.text.TextReplacementRenderer;
import me.loving11ish.clans.libs.adventure.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TextReplacementConfigImpl
implements TextReplacementConfig {
    private final Pattern matchPattern;
    private final BiFunction<MatchResult, TextComponent.Builder, @Nullable ComponentLike> replacement;
    private final TextReplacementConfig.Condition continuer;
    private final boolean replaceInsideHoverEvents;

    TextReplacementConfigImpl(Builder builder) {
        this.matchPattern = builder.matchPattern;
        this.replacement = builder.replacement;
        this.continuer = builder.continuer;
        this.replaceInsideHoverEvents = builder.replaceInsideHoverEvents;
    }

    @Override
    @NotNull
    public final Pattern matchPattern() {
        return this.matchPattern;
    }

    final TextReplacementRenderer.State createState() {
        return new TextReplacementRenderer.State(this.matchPattern, this.replacement, this.continuer, this.replaceInsideHoverEvents);
    }

    @Override
    public final @NotNull TextReplacementConfig.Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    @NotNull
    public final Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("matchPattern", this.matchPattern), ExaminableProperty.of("replacement", this.replacement), ExaminableProperty.of("continuer", this.continuer));
    }

    public final String toString() {
        return Internals.toString(this);
    }

    static final class Builder
    implements TextReplacementConfig.Builder {
        @Nullable
        Pattern matchPattern;
        @Nullable
        @Nullable BiFunction<MatchResult, TextComponent.Builder, @Nullable ComponentLike> replacement;
        TextReplacementConfig.Condition continuer = (matchResult, n2, n3) -> PatternReplacementResult.REPLACE;
        boolean replaceInsideHoverEvents = true;

        Builder() {
        }

        Builder(TextReplacementConfigImpl textReplacementConfigImpl) {
            this.matchPattern = textReplacementConfigImpl.matchPattern;
            this.replacement = textReplacementConfigImpl.replacement;
            this.continuer = textReplacementConfigImpl.continuer;
        }

        @Override
        @NotNull
        public final Builder match(@NotNull Pattern pattern) {
            this.matchPattern = Objects.requireNonNull(pattern, "pattern");
            return this;
        }

        @Override
        @NotNull
        public final Builder condition(@NotNull TextReplacementConfig.Condition condition) {
            this.continuer = Objects.requireNonNull(condition, "continuation");
            return this;
        }

        @Override
        @NotNull
        public final Builder replacement(@NotNull BiFunction<MatchResult, TextComponent.Builder, @Nullable ComponentLike> biFunction) {
            this.replacement = Objects.requireNonNull(biFunction, "replacement");
            return this;
        }

        @Override
        public final @NotNull TextReplacementConfig.Builder replaceInsideHoverEvents(boolean bl) {
            this.replaceInsideHoverEvents = bl;
            return this;
        }

        @Override
        @NotNull
        public final TextReplacementConfig build() {
            if (this.matchPattern == null) {
                throw new IllegalStateException("A pattern must be provided to match against");
            }
            if (this.replacement == null) {
                throw new IllegalStateException("A replacement action must be provided");
            }
            return new TextReplacementConfigImpl(this);
        }
    }
}

