/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clans.libs.adventure.adventure.pointer;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import me.loving11ish.clans.libs.adventure.adventure.pointer.Pointer;
import me.loving11ish.clans.libs.adventure.adventure.pointer.Pointers;
import me.loving11ish.clans.libs.adventure.adventure.pointer.PointersSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PointersSupplierImpl<T>
implements PointersSupplier<T> {
    @Nullable
    private final PointersSupplier<? super T> parent;
    private final Map<Pointer<?>, Function<T, ?>> resolvers;

    PointersSupplierImpl(@NotNull BuilderImpl<T> builderImpl) {
        this.parent = ((BuilderImpl)builderImpl).parent;
        this.resolvers = new HashMap(((BuilderImpl)builderImpl).resolvers);
    }

    @Override
    @NotNull
    public final Pointers view(@NotNull T t2) {
        return new ForwardingPointers<T>(t2, this);
    }

    @Override
    public final <P> boolean supports(@NotNull Pointer<P> pointer) {
        if (this.resolvers.containsKey(Objects.requireNonNull(pointer, "pointer"))) {
            return true;
        }
        if (this.parent == null) {
            return false;
        }
        return this.parent.supports(pointer);
    }

    @Override
    @Nullable
    public final <P> Function<? super T, P> resolver(@NotNull Pointer<P> pointer) {
        Function<T, ?> function = this.resolvers.get(Objects.requireNonNull(pointer, "pointer"));
        if (function != null) {
            return function;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.resolver(pointer);
    }

    static final class BuilderImpl<T>
    implements PointersSupplier.Builder<T> {
        @Nullable
        private PointersSupplier<? super T> parent = null;
        private final Map<Pointer<?>, Function<T, ?>> resolvers = new HashMap();

        BuilderImpl() {
        }

        @Override
        @NotNull
        public final PointersSupplier.Builder<T> parent(@Nullable PointersSupplier<? super T> pointersSupplier) {
            this.parent = pointersSupplier;
            return this;
        }

        @Override
        @NotNull
        public final <P> PointersSupplier.Builder<T> resolving(@NotNull Pointer<P> pointer, @NotNull Function<T, P> function) {
            this.resolvers.put(pointer, function);
            return this;
        }

        @Override
        @NotNull
        public final PointersSupplier<T> build() {
            return new PointersSupplierImpl(this);
        }
    }

    static final class ForwardingPointers<U>
    implements Pointers {
        private final U instance;
        private final PointersSupplierImpl<U> supplier;

        ForwardingPointers(@NotNull U u2, @NotNull PointersSupplierImpl<U> pointersSupplierImpl) {
            this.instance = u2;
            this.supplier = pointersSupplierImpl;
        }

        @Override
        @NotNull
        public final <T> Optional<T> get(@NotNull Pointer<T> pointer) {
            PointersSupplier pointersSupplier;
            Function<U, U> function = (Function<U, U>)((PointersSupplierImpl)this.supplier).resolvers.get(Objects.requireNonNull(pointer, "pointer"));
            if (function == null && (pointersSupplier = ((PointersSupplierImpl)this.supplier).parent) != null) {
                function = pointersSupplier.resolver(pointer);
            }
            if (function == null) {
                return Optional.empty();
            }
            return Optional.ofNullable(function.apply(this.instance));
        }

        @Override
        public final <T> boolean supports(@NotNull Pointer<T> pointer) {
            return this.supplier.supports(pointer);
        }

        @Override
        public final @NotNull Pointers.Builder toBuilder() {
            Pointers.Builder builder = ((PointersSupplierImpl)this.supplier).parent == null ? Pointers.builder() : (Pointers.Builder)((PointersSupplierImpl)this.supplier).parent.view(this.instance).toBuilder();
            for (Map.Entry entry : ((PointersSupplierImpl)this.supplier).resolvers.entrySet()) {
                builder.withDynamic((Pointer)entry.getKey(), () -> ((Function)entry.getValue()).apply(this.instance));
            }
            return builder;
        }
    }
}

