/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clans.libs.adventure.adventure.nbt;

import java.io.DataInput;
import java.io.IOException;
import me.loving11ish.clans.libs.adventure.adventure.nbt.BinaryTagScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TrackingDataInput
implements DataInput,
BinaryTagScope {
    private static final int MAX_DEPTH = 512;
    private final DataInput input;
    private final long maxLength;
    private long counter;
    private int depth;

    TrackingDataInput(DataInput dataInput, long l2) {
        this.input = dataInput;
        this.maxLength = l2;
    }

    public static BinaryTagScope enter(DataInput dataInput) {
        if (dataInput instanceof TrackingDataInput) {
            return ((TrackingDataInput)dataInput).enter();
        }
        return BinaryTagScope.NoOp.INSTANCE;
    }

    public static BinaryTagScope enter(DataInput dataInput, long l2) {
        if (dataInput instanceof TrackingDataInput) {
            return ((TrackingDataInput)dataInput).enter(l2);
        }
        return BinaryTagScope.NoOp.INSTANCE;
    }

    public final DataInput input() {
        return this.input;
    }

    public final TrackingDataInput enter(long l2) {
        if (this.depth++ > 512) {
            throw new IOException("NBT read exceeded maximum depth of 512");
        }
        this.ensureMaxLength(l2);
        return this;
    }

    public final TrackingDataInput enter() {
        return this.enter(0L);
    }

    public final void exit() {
        --this.depth;
        this.ensureMaxLength(0L);
    }

    private void ensureMaxLength(long l2) {
        if (this.maxLength > 0L && this.counter + l2 > this.maxLength) {
            throw new IOException("The read NBT was longer than the maximum allowed size of " + this.maxLength + " bytes!");
        }
    }

    @Override
    public final void readFully(byte @NotNull [] byArray) {
        this.counter += (long)byArray.length;
        this.input.readFully(byArray);
    }

    @Override
    public final void readFully(byte @NotNull [] byArray, int n2, int n3) {
        this.counter += (long)n3;
        this.input.readFully(byArray, n2, n3);
    }

    @Override
    public final int skipBytes(int n2) {
        return this.input.skipBytes(n2);
    }

    @Override
    public final boolean readBoolean() {
        ++this.counter;
        return this.input.readBoolean();
    }

    @Override
    public final byte readByte() {
        ++this.counter;
        return this.input.readByte();
    }

    @Override
    public final int readUnsignedByte() {
        ++this.counter;
        return this.input.readUnsignedByte();
    }

    @Override
    public final short readShort() {
        this.counter += 2L;
        return this.input.readShort();
    }

    @Override
    public final int readUnsignedShort() {
        this.counter += 2L;
        return this.input.readUnsignedShort();
    }

    @Override
    public final char readChar() {
        this.counter += 2L;
        return this.input.readChar();
    }

    @Override
    public final int readInt() {
        this.counter += 4L;
        return this.input.readInt();
    }

    @Override
    public final long readLong() {
        this.counter += 8L;
        return this.input.readLong();
    }

    @Override
    public final float readFloat() {
        this.counter += 4L;
        return this.input.readFloat();
    }

    @Override
    public final double readDouble() {
        this.counter += 8L;
        return this.input.readDouble();
    }

    @Override
    @Nullable
    public final String readLine() {
        @Nullable String string = this.input.readLine();
        if (string != null) {
            this.counter += (long)(string.length() + 1);
        }
        return string;
    }

    @Override
    @NotNull
    public final String readUTF() {
        String string = this.input.readUTF();
        this.counter += ((long)string.length() << 1) + 2L;
        return string;
    }

    @Override
    public final void close() {
        this.exit();
    }
}

