/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clans.libs.adventure.adventure.nbt;

import java.util.ArrayList;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import me.loving11ish.clans.libs.adventure.adventure.nbt.BinaryTag;
import me.loving11ish.clans.libs.adventure.adventure.nbt.ByteArrayBinaryTag;
import me.loving11ish.clans.libs.adventure.adventure.nbt.ByteBinaryTag;
import me.loving11ish.clans.libs.adventure.adventure.nbt.CharBuffer;
import me.loving11ish.clans.libs.adventure.adventure.nbt.CompoundBinaryTag;
import me.loving11ish.clans.libs.adventure.adventure.nbt.DoubleBinaryTag;
import me.loving11ish.clans.libs.adventure.adventure.nbt.FloatBinaryTag;
import me.loving11ish.clans.libs.adventure.adventure.nbt.IntArrayBinaryTag;
import me.loving11ish.clans.libs.adventure.adventure.nbt.IntBinaryTag;
import me.loving11ish.clans.libs.adventure.adventure.nbt.ListBinaryTag;
import me.loving11ish.clans.libs.adventure.adventure.nbt.LongArrayBinaryTag;
import me.loving11ish.clans.libs.adventure.adventure.nbt.LongBinaryTag;
import me.loving11ish.clans.libs.adventure.adventure.nbt.NumberBinaryTag;
import me.loving11ish.clans.libs.adventure.adventure.nbt.ShortBinaryTag;
import me.loving11ish.clans.libs.adventure.adventure.nbt.StringBinaryTag;
import me.loving11ish.clans.libs.adventure.adventure.nbt.Tokens;
import org.jetbrains.annotations.Nullable;

final class TagStringReader {
    private static final int MAX_DEPTH = 512;
    private static final int HEX_RADIX = 16;
    private static final int BINARY_RADIX = 2;
    private static final int DECIMAL_RADIX = 10;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private final CharBuffer buffer;
    private boolean acceptLegacy;
    private boolean acceptHeterogenousLists;
    private int depth;

    TagStringReader(CharBuffer charBuffer) {
        this.buffer = charBuffer;
    }

    public final CompoundBinaryTag compound() {
        this.buffer.expect('{');
        if (this.buffer.takeIf('}')) {
            return CompoundBinaryTag.empty();
        }
        CompoundBinaryTag.Builder builder = CompoundBinaryTag.builder();
        while (this.buffer.hasMore()) {
            builder.put(this.key(), this.tag());
            if (!this.separatorOrCompleteWith('}')) continue;
            return builder.build();
        }
        throw this.buffer.makeError("Unterminated compound tag!");
    }

    public final ListBinaryTag list() {
        ListBinaryTag.Builder<BinaryTag> builder = ListBinaryTag.builder();
        this.buffer.expect('[');
        boolean bl = this.acceptLegacy && this.buffer.peek() == '0' && this.buffer.peek(1) == ':';
        if (!bl && this.buffer.takeIf(']')) {
            return ListBinaryTag.empty();
        }
        while (this.buffer.hasMore()) {
            if (bl) {
                this.buffer.takeUntil(':');
            }
            BinaryTag binaryTag = this.tag();
            builder.add(binaryTag);
            if (!this.separatorOrCompleteWith(']')) continue;
            return builder.build();
        }
        throw this.buffer.makeError("Reached end of file without end of list tag!");
    }

    public final BinaryTag array(char c2) {
        this.buffer.expect('[').expect(c2).expect(';');
        c2 = Character.toLowerCase(c2);
        if (c2 == 'b') {
            return ByteArrayBinaryTag.byteArrayBinaryTag(this.byteArray());
        }
        if (c2 == 'i') {
            return IntArrayBinaryTag.intArrayBinaryTag(this.intArray());
        }
        if (c2 == 'l') {
            return LongArrayBinaryTag.longArrayBinaryTag(this.longArray());
        }
        throw this.buffer.makeError("Type " + c2 + " is not a valid element type in an array!");
    }

    private byte[] byteArray() {
        if (this.buffer.takeIf(']')) {
            return EMPTY_BYTE_ARRAY;
        }
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        while (this.buffer.hasMore()) {
            Object object = this.buffer.skipWhitespace().takeUntil('b');
            try {
                arrayList.add(Byte.valueOf(object.toString()));
            }
            catch (NumberFormatException numberFormatException) {
                throw this.buffer.makeError("All elements of a byte array must be bytes!");
            }
            if (!this.separatorOrCompleteWith(']')) continue;
            object = new byte[arrayList.size()];
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                object[i2] = (Byte)arrayList.get(i2);
            }
            return object;
        }
        throw this.buffer.makeError("Reached end of document without array close");
    }

    private int[] intArray() {
        if (this.buffer.takeIf(']')) {
            return EMPTY_INT_ARRAY;
        }
        IntStream.Builder builder = IntStream.builder();
        while (this.buffer.hasMore()) {
            BinaryTag binaryTag = this.tag();
            if (!(binaryTag instanceof IntBinaryTag)) {
                throw this.buffer.makeError("All elements of an int array must be ints!");
            }
            builder.add(((IntBinaryTag)binaryTag).intValue());
            if (!this.separatorOrCompleteWith(']')) continue;
            return builder.build().toArray();
        }
        throw this.buffer.makeError("Reached end of document without array close");
    }

    private long[] longArray() {
        if (this.buffer.takeIf(']')) {
            return EMPTY_LONG_ARRAY;
        }
        LongStream.Builder builder = LongStream.builder();
        while (this.buffer.hasMore()) {
            CharSequence charSequence = this.buffer.skipWhitespace().takeUntil('l');
            try {
                builder.add(Long.parseLong(charSequence.toString()));
            }
            catch (NumberFormatException numberFormatException) {
                throw this.buffer.makeError("All elements of a long array must be longs!");
            }
            if (!this.separatorOrCompleteWith(']')) continue;
            return builder.build().toArray();
        }
        throw this.buffer.makeError("Reached end of document without array close");
    }

    public final String key() {
        this.buffer.skipWhitespace();
        char c2 = this.buffer.peek();
        try {
            if (c2 == '\'' || c2 == '\"') {
                String string = TagStringReader.unescape(this.buffer.takeUntil(this.buffer.take()).toString());
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder();
            while (this.buffer.hasMore()) {
                char c3 = this.buffer.peek();
                if (!Tokens.id(c3)) {
                    if (!this.acceptLegacy) break;
                    if (c3 == '\\') {
                        this.buffer.take();
                        continue;
                    }
                    if (c3 == ':') break;
                    stringBuilder.append(this.buffer.take());
                    continue;
                }
                stringBuilder.append(this.buffer.take());
            }
            String string = stringBuilder.toString();
            return string;
        }
        finally {
            this.buffer.expect(':');
        }
    }

    public final BinaryTag tag() {
        if (this.depth++ > 512) {
            throw this.buffer.makeError("Exceeded maximum allowed depth of 512 when reading tag");
        }
        try {
            char c2 = this.buffer.skipWhitespace().peek();
            switch (c2) {
                case '{': {
                    CompoundBinaryTag compoundBinaryTag = this.compound();
                    return compoundBinaryTag;
                }
                case '[': {
                    if (this.buffer.hasMore(2) && this.buffer.peek(2) == ';') {
                        TagStringReader tagStringReader = this;
                        BinaryTag binaryTag = tagStringReader.array(tagStringReader.buffer.peek(1));
                        return binaryTag;
                    }
                    ListBinaryTag listBinaryTag = this.list();
                    return listBinaryTag;
                }
                case '\"': 
                case '\'': {
                    this.buffer.advance();
                    StringBinaryTag stringBinaryTag = StringBinaryTag.stringBinaryTag(TagStringReader.unescape(this.buffer.takeUntil(c2).toString()));
                    return stringBinaryTag;
                }
            }
            BinaryTag binaryTag = this.scalar();
            return binaryTag;
        }
        finally {
            --this.depth;
        }
    }

    private BinaryTag scalar() {
        String string;
        block19: {
            char c2;
            boolean bl;
            Object object = new StringBuilder();
            while (this.buffer.hasMore()) {
                char c3 = this.buffer.peek();
                if (c3 == '\\') {
                    this.buffer.advance();
                    c3 = this.buffer.take();
                } else {
                    if (!Tokens.id(c3)) break;
                    this.buffer.advance();
                }
                ((StringBuilder)object).append(c3);
            }
            if (((StringBuilder)object).length() == 0) {
                throw this.buffer.makeError("Expected a value but got nothing");
            }
            string = ((StringBuilder)object).toString();
            int n2 = this.extractRadix((StringBuilder)object, string);
            StringBuilder stringBuilder = object;
            char c4 = stringBuilder.charAt(stringBuilder.length() - 1);
            boolean bl2 = false;
            boolean bl3 = bl = n2 != 16;
            if (((StringBuilder)object).length() > 2) {
                StringBuilder stringBuilder2 = object;
                c2 = stringBuilder2.charAt(stringBuilder2.length() - 2);
                if (c2 == 's' || c2 == 'u') {
                    bl2 = true;
                    bl = c2 == 's';
                    CharSequence charSequence = object;
                    ((StringBuilder)charSequence).deleteCharAt(((StringBuilder)charSequence).length() - 2);
                }
            }
            c2 = '\u0000';
            char c5 = 'i';
            if (Tokens.numericType(c4) && (bl2 || n2 != 16)) {
                c2 = '\u0001';
                c5 = Character.toLowerCase(c4);
                StringBuilder stringBuilder3 = object;
                stringBuilder3.deleteCharAt(stringBuilder3.length() - 1);
            }
            if (!(bl || c5 != 'f' && c5 != 'd')) {
                throw this.buffer.makeError("Cannot create unsigned floating point numbers");
            }
            object = ((StringBuilder)object).toString().replace("_", "");
            if (c2 != '\u0000') {
                try {
                    object = this.parseNumberTag((String)object, c5, n2, bl);
                    if (object != null) {
                        return object;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                try {
                    return IntBinaryTag.intBinaryTag(this.parseInt((String)object, n2, bl));
                }
                catch (NumberFormatException numberFormatException) {
                    if (((String)object).indexOf(46) == -1) break block19;
                    try {
                        return DoubleBinaryTag.doubleBinaryTag(Double.parseDouble((String)object));
                    }
                    catch (NumberFormatException numberFormatException2) {}
                }
            }
        }
        if (string.equalsIgnoreCase("true")) {
            return ByteBinaryTag.ONE;
        }
        if (string.equalsIgnoreCase("false")) {
            return ByteBinaryTag.ZERO;
        }
        return StringBinaryTag.stringBinaryTag(string);
    }

    private int extractRadix(StringBuilder stringBuilder, String string) {
        int n2;
        int n3 = 0;
        char c2 = stringBuilder.charAt(0);
        if (c2 == '+' || c2 == '-') {
            n3 = 1;
        }
        if ((n2 = string.startsWith("0b", n3) || string.startsWith("0B", n3) ? 2 : (string.startsWith("0x", n3) || string.startsWith("0X", n3) ? 16 : 10)) != 10) {
            stringBuilder.delete(n3, n3 + 2);
        }
        return n2;
    }

    @Nullable
    private NumberBinaryTag parseNumberTag(String string, char c2, int n2, boolean bl) {
        switch (c2) {
            case 'b': {
                return ByteBinaryTag.byteBinaryTag(this.parseByte(string, n2, bl));
            }
            case 's': {
                return ShortBinaryTag.shortBinaryTag(this.parseShort(string, n2, bl));
            }
            case 'i': {
                return IntBinaryTag.intBinaryTag(this.parseInt(string, n2, bl));
            }
            case 'l': {
                return LongBinaryTag.longBinaryTag(this.parseLong(string, n2, bl));
            }
            case 'f': {
                float f2 = Float.parseFloat(string);
                if (!Float.isFinite(f2)) break;
                return FloatBinaryTag.floatBinaryTag(f2);
            }
            case 'd': {
                double d2 = Double.parseDouble(string);
                if (!Double.isFinite(d2)) break;
                return DoubleBinaryTag.doubleBinaryTag(d2);
            }
        }
        return null;
    }

    private byte parseByte(String string, int n2, boolean bl) {
        if (bl) {
            return Byte.parseByte(string, n2);
        }
        int n3 = Integer.parseInt(string, n2);
        if (n3 >> 8 == 0) {
            return (byte)n3;
        }
        throw new NumberFormatException();
    }

    private short parseShort(String string, int n2, boolean bl) {
        if (bl) {
            return Short.parseShort(string, n2);
        }
        int n3 = Integer.parseInt(string, n2);
        if (n3 >> 16 == 0) {
            return (short)n3;
        }
        throw new NumberFormatException();
    }

    private int parseInt(String string, int n2, boolean bl) {
        if (bl) {
            return Integer.parseInt(string, n2);
        }
        return Integer.parseUnsignedInt(string, n2);
    }

    private long parseLong(String string, int n2, boolean bl) {
        if (bl) {
            return Long.parseLong(string, n2);
        }
        return Long.parseUnsignedLong(string, n2);
    }

    private boolean separatorOrCompleteWith(char c2) {
        if (this.buffer.takeIf(c2)) {
            return true;
        }
        this.buffer.expect(',');
        return this.buffer.takeIf(c2);
    }

    private static String unescape(String string) {
        int n2 = string.indexOf(92);
        if (n2 == -1) {
            return string;
        }
        int n3 = 0;
        StringBuilder stringBuilder = new StringBuilder(string.length());
        do {
            stringBuilder.append(string, n3, n2);
        } while ((n2 = string.indexOf(92, (n3 = n2 + 1) + 1)) != -1);
        stringBuilder.append(string.substring(n3));
        return stringBuilder.toString();
    }

    public final void legacy(boolean bl) {
        this.acceptLegacy = bl;
    }
}

