/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clans.libs.adventure.adventure.nbt;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import me.loving11ish.clans.libs.adventure.adventure.nbt.BinaryTag;
import me.loving11ish.clans.libs.adventure.adventure.nbt.CharBuffer;
import me.loving11ish.clans.libs.adventure.adventure.nbt.CompoundBinaryTag;
import me.loving11ish.clans.libs.adventure.adventure.nbt.StringTagParseException;
import me.loving11ish.clans.libs.adventure.adventure.nbt.TagStringReader;
import me.loving11ish.clans.libs.adventure.adventure.nbt.TagStringWriter;
import org.jetbrains.annotations.NotNull;

public final class TagStringIO {
    private static final TagStringIO INSTANCE = new TagStringIO(new Builder());
    private final boolean acceptLegacy;
    private final boolean emitLegacy;
    private final String indent;

    @NotNull
    public static TagStringIO get() {
        return INSTANCE;
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    private TagStringIO(@NotNull Builder builder) {
        this.acceptLegacy = builder.acceptLegacy;
        this.emitLegacy = builder.emitLegacy;
        this.indent = builder.indent;
    }

    public final CompoundBinaryTag asCompound(String object) {
        try {
            object = new CharBuffer((CharSequence)object);
            Object object2 = new TagStringReader((CharBuffer)object);
            ((TagStringReader)object2).legacy(this.acceptLegacy);
            object2 = ((TagStringReader)object2).compound();
            if (((CharBuffer)object).skipWhitespace().hasMore()) {
                throw new IOException("Document had trailing content after first CompoundTag");
            }
            return object2;
        }
        catch (StringTagParseException stringTagParseException) {
            throw new IOException(stringTagParseException);
        }
    }

    public final String asString(CompoundBinaryTag compoundBinaryTag) {
        return this.asString((BinaryTag)compoundBinaryTag);
    }

    public final String asString(BinaryTag binaryTag) {
        StringBuilder stringBuilder = new StringBuilder();
        try (TagStringWriter tagStringWriter = new TagStringWriter(stringBuilder, this.indent);){
            tagStringWriter.legacy(this.emitLegacy);
            tagStringWriter.writeTag(binaryTag);
        }
        return stringBuilder.toString();
    }

    public final void toWriter(CompoundBinaryTag compoundBinaryTag, Writer autoCloseable) {
        autoCloseable = new TagStringWriter((Appendable)((Object)autoCloseable), this.indent);
        try {
            ((TagStringWriter)autoCloseable).legacy(this.emitLegacy);
            ((TagStringWriter)autoCloseable).writeTag(compoundBinaryTag);
            return;
        }
        finally {
            ((TagStringWriter)autoCloseable).close();
        }
    }

    public static class Builder {
        private boolean acceptLegacy = true;
        private boolean emitLegacy = false;
        private String indent = "";

        Builder() {
        }

        @NotNull
        public Builder indent(int n2) {
            if (n2 == 0) {
                this.indent = "";
            } else if (this.indent.length() > 0 && this.indent.charAt(0) != ' ' || n2 != this.indent.length()) {
                char[] cArray = new char[n2];
                Arrays.fill(cArray, ' ');
                this.indent = String.copyValueOf(cArray);
            }
            return this;
        }

        @NotNull
        public Builder indentTab(int n2) {
            if (n2 == 0) {
                this.indent = "";
            } else if (this.indent.length() > 0 && this.indent.charAt(0) != '\t' || n2 != this.indent.length()) {
                char[] cArray = new char[n2];
                Arrays.fill(cArray, '\t');
                this.indent = String.copyValueOf(cArray);
            }
            return this;
        }

        @NotNull
        public Builder acceptLegacy(boolean bl) {
            this.acceptLegacy = bl;
            return this;
        }

        @NotNull
        public Builder emitLegacy(boolean bl) {
            this.emitLegacy = bl;
            return this;
        }

        @NotNull
        public TagStringIO build() {
            return new TagStringIO(this);
        }
    }
}

