/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clans.libs.adventure.adventure.nbt;

import java.util.ArrayList;
import java.util.List;
import me.loving11ish.clans.libs.adventure.adventure.nbt.BinaryTag;
import me.loving11ish.clans.libs.adventure.adventure.nbt.BinaryTagType;
import me.loving11ish.clans.libs.adventure.adventure.nbt.BinaryTagTypes;
import me.loving11ish.clans.libs.adventure.adventure.nbt.ListBinaryTag;
import me.loving11ish.clans.libs.adventure.adventure.nbt.ListBinaryTagImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ListTagBuilder<T extends BinaryTag>
implements ListBinaryTag.Builder<T> {
    @Nullable
    private List<BinaryTag> tags;
    private final boolean permitsHeterogeneity;
    private BinaryTagType<? extends BinaryTag> elementType;

    ListTagBuilder(boolean bl) {
        this(bl, BinaryTagTypes.END);
    }

    ListTagBuilder(boolean bl, BinaryTagType<? extends BinaryTag> binaryTagType) {
        this.permitsHeterogeneity = bl;
        this.elementType = binaryTagType;
    }

    @Override
    public final @NotNull ListBinaryTag.Builder<T> add(BinaryTag binaryTag) {
        this.elementType = ListBinaryTagImpl.validateTagType(binaryTag, this.elementType, this.permitsHeterogeneity);
        if (this.tags == null) {
            this.tags = new ArrayList<BinaryTag>();
        }
        this.tags.add(binaryTag);
        return this;
    }

    @Override
    public final @NotNull ListBinaryTag.Builder<T> add(Iterable<? extends T> object) {
        object = object.iterator();
        while (object.hasNext()) {
            BinaryTag binaryTag = (BinaryTag)object.next();
            this.add(binaryTag);
        }
        return this;
    }

    @Override
    @NotNull
    public final ListBinaryTag build() {
        if (this.tags == null) {
            return ListBinaryTag.empty();
        }
        return new ListBinaryTagImpl(this.elementType, this.permitsHeterogeneity, new ArrayList<BinaryTag>(this.tags));
    }
}

