/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clans.libs.adventure.adventure.nbt;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collector;
import java.util.stream.Stream;
import me.loving11ish.clans.libs.adventure.adventure.nbt.BinaryTag;
import me.loving11ish.clans.libs.adventure.adventure.nbt.BinaryTagType;
import me.loving11ish.clans.libs.adventure.adventure.nbt.BinaryTagTypes;
import me.loving11ish.clans.libs.adventure.adventure.nbt.ByteArrayBinaryTag;
import me.loving11ish.clans.libs.adventure.adventure.nbt.CompoundBinaryTag;
import me.loving11ish.clans.libs.adventure.adventure.nbt.IntArrayBinaryTag;
import me.loving11ish.clans.libs.adventure.adventure.nbt.ListBinaryTagImpl;
import me.loving11ish.clans.libs.adventure.adventure.nbt.ListTagBuilder;
import me.loving11ish.clans.libs.adventure.adventure.nbt.ListTagSetter;
import me.loving11ish.clans.libs.adventure.adventure.nbt.LongArrayBinaryTag;
import me.loving11ish.clans.libs.adventure.adventure.nbt.NumberBinaryTag;
import me.loving11ish.clans.libs.adventure.adventure.nbt.StringBinaryTag;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public interface ListBinaryTag
extends Iterable<BinaryTag>,
BinaryTag,
ListTagSetter<ListBinaryTag, BinaryTag> {
    @NotNull
    public static ListBinaryTag empty() {
        return ListBinaryTagImpl.EMPTY;
    }

    @NotNull
    public static ListBinaryTag from(@NotNull Iterable<? extends BinaryTag> iterable) {
        return ((Builder)ListBinaryTag.builder().add(iterable)).build();
    }

    @NotNull
    public static Builder<BinaryTag> builder() {
        return new ListTagBuilder<BinaryTag>(false);
    }

    @NotNull
    public static Builder<BinaryTag> heterogeneousListBinaryTag() {
        return new ListTagBuilder<BinaryTag>(true);
    }

    @NotNull
    public static <T extends BinaryTag> Builder<T> builder(@NotNull BinaryTagType<T> binaryTagType) {
        if (binaryTagType == BinaryTagTypes.END) {
            throw new IllegalArgumentException("Cannot create a list of " + BinaryTagTypes.END);
        }
        return new ListTagBuilder(false, binaryTagType);
    }

    @NotNull
    public static ListBinaryTag listBinaryTag(@NotNull BinaryTagType<? extends BinaryTag> binaryTagType, @NotNull List<BinaryTag> list) {
        if (list.isEmpty()) {
            return ListBinaryTag.empty();
        }
        if (binaryTagType == BinaryTagTypes.END) {
            throw new IllegalArgumentException("Cannot create a list of " + BinaryTagTypes.END);
        }
        ListBinaryTagImpl.validateTagType(list, binaryTagType == BinaryTagTypes.LIST_WILDCARD);
        BinaryTagType<? extends BinaryTag> binaryTagType2 = binaryTagType;
        return new ListBinaryTagImpl(binaryTagType2, binaryTagType2 == BinaryTagTypes.LIST_WILDCARD, new ArrayList<BinaryTag>(list));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    @NotNull
    public static ListBinaryTag of(@NotNull BinaryTagType<? extends BinaryTag> binaryTagType, @NotNull List<BinaryTag> list) {
        return ListBinaryTag.listBinaryTag(binaryTagType, list);
    }

    @NotNull
    public static Collector<BinaryTag, ?, ListBinaryTag> toListTag() {
        return ListBinaryTag.toListTag(null);
    }

    @NotNull
    public static Collector<BinaryTag, ?, ListBinaryTag> toListTag(@Nullable ListBinaryTag listBinaryTag) {
        return Collector.of(listBinaryTag == null ? ListBinaryTag::builder : () -> (Builder)ListBinaryTag.builder().add(listBinaryTag), ListTagSetter::add, (builder, builder2) -> (Builder)builder.add(builder2.build()), Builder::build, new Collector.Characteristics[0]);
    }

    @NotNull
    default public BinaryTagType<ListBinaryTag> type() {
        return BinaryTagTypes.LIST;
    }

    @Deprecated
    @NotNull
    default public BinaryTagType<? extends BinaryTag> listType() {
        return this.elementType();
    }

    @NotNull
    public BinaryTagType<? extends BinaryTag> elementType();

    public int size();

    public boolean isEmpty();

    @NotNull
    public BinaryTag get(@Range(from=0L, to=0x7FFFFFFFL) int var1);

    @NotNull
    public ListBinaryTag set(int var1, @NotNull BinaryTag var2, @Nullable Consumer<? super BinaryTag> var3);

    @NotNull
    public ListBinaryTag remove(int var1, @Nullable Consumer<? super BinaryTag> var2);

    default public byte getByte(@Range(from=0L, to=0x7FFFFFFFL) int n2) {
        return this.getByte(n2, (byte)0);
    }

    default public byte getByte(@Range(from=0L, to=0x7FFFFFFFL) int n2, byte by) {
        BinaryTag binaryTag = this.get(n2);
        if (binaryTag.type().numeric()) {
            return ((NumberBinaryTag)binaryTag).byteValue();
        }
        return by;
    }

    default public short getShort(@Range(from=0L, to=0x7FFFFFFFL) int n2) {
        return this.getShort(n2, (short)0);
    }

    default public short getShort(@Range(from=0L, to=0x7FFFFFFFL) int n2, short s2) {
        BinaryTag binaryTag = this.get(n2);
        if (binaryTag.type().numeric()) {
            return ((NumberBinaryTag)binaryTag).shortValue();
        }
        return s2;
    }

    default public int getInt(@Range(from=0L, to=0x7FFFFFFFL) int n2) {
        return this.getInt(n2, 0);
    }

    default public int getInt(@Range(from=0L, to=0x7FFFFFFFL) int n2, int n3) {
        BinaryTag binaryTag = this.get(n2);
        if (binaryTag.type().numeric()) {
            return ((NumberBinaryTag)binaryTag).intValue();
        }
        return n3;
    }

    default public long getLong(@Range(from=0L, to=0x7FFFFFFFL) int n2) {
        return this.getLong(n2, 0L);
    }

    default public long getLong(@Range(from=0L, to=0x7FFFFFFFL) int n2, long l2) {
        BinaryTag binaryTag = this.get(n2);
        if (binaryTag.type().numeric()) {
            return ((NumberBinaryTag)binaryTag).longValue();
        }
        return l2;
    }

    default public float getFloat(@Range(from=0L, to=0x7FFFFFFFL) int n2) {
        return this.getFloat(n2, 0.0f);
    }

    default public float getFloat(@Range(from=0L, to=0x7FFFFFFFL) int n2, float f2) {
        BinaryTag binaryTag = this.get(n2);
        if (binaryTag.type().numeric()) {
            return ((NumberBinaryTag)binaryTag).floatValue();
        }
        return f2;
    }

    default public double getDouble(@Range(from=0L, to=0x7FFFFFFFL) int n2) {
        return this.getDouble(n2, 0.0);
    }

    default public double getDouble(@Range(from=0L, to=0x7FFFFFFFL) int n2, double d2) {
        BinaryTag binaryTag = this.get(n2);
        if (binaryTag.type().numeric()) {
            return ((NumberBinaryTag)binaryTag).doubleValue();
        }
        return d2;
    }

    default public byte @NotNull [] getByteArray(@Range(from=0L, to=0x7FFFFFFFL) int n2) {
        BinaryTag binaryTag = this.get(n2);
        if (binaryTag.type() == BinaryTagTypes.BYTE_ARRAY) {
            return ((ByteArrayBinaryTag)binaryTag).value();
        }
        return new byte[0];
    }

    default public byte @NotNull [] getByteArray(@Range(from=0L, to=0x7FFFFFFFL) int n2, byte @NotNull [] byArray) {
        BinaryTag binaryTag = this.get(n2);
        if (binaryTag.type() == BinaryTagTypes.BYTE_ARRAY) {
            return ((ByteArrayBinaryTag)binaryTag).value();
        }
        return byArray;
    }

    @NotNull
    default public String getString(@Range(from=0L, to=0x7FFFFFFFL) int n2) {
        return this.getString(n2, "");
    }

    @NotNull
    default public String getString(@Range(from=0L, to=0x7FFFFFFFL) int n2, @NotNull String string) {
        BinaryTag binaryTag = this.get(n2);
        if (binaryTag.type() == BinaryTagTypes.STRING) {
            return ((StringBinaryTag)binaryTag).value();
        }
        return string;
    }

    @NotNull
    default public ListBinaryTag getList(@Range(from=0L, to=0x7FFFFFFFL) int n2) {
        return this.getList(n2, null, ListBinaryTag.empty());
    }

    @NotNull
    default public ListBinaryTag getList(@Range(from=0L, to=0x7FFFFFFFL) int n2, @Nullable BinaryTagType<?> binaryTagType) {
        return this.getList(n2, binaryTagType, ListBinaryTag.empty());
    }

    @NotNull
    default public ListBinaryTag getList(@Range(from=0L, to=0x7FFFFFFFL) int n2, @NotNull ListBinaryTag listBinaryTag) {
        return this.getList(n2, null, listBinaryTag);
    }

    @NotNull
    default public ListBinaryTag getList(@Range(from=0L, to=0x7FFFFFFFL) int n2, @Nullable BinaryTagType<?> binaryTagType, @NotNull ListBinaryTag listBinaryTag) {
        BinaryTag binaryTag = this.get(n2);
        if (binaryTag.type() == BinaryTagTypes.LIST) {
            binaryTag = (ListBinaryTag)binaryTag;
            if (binaryTagType == null || binaryTag.elementType() == binaryTagType) {
                return binaryTag;
            }
        }
        return listBinaryTag;
    }

    @NotNull
    default public CompoundBinaryTag getCompound(@Range(from=0L, to=0x7FFFFFFFL) int n2) {
        return this.getCompound(n2, CompoundBinaryTag.empty());
    }

    @NotNull
    default public CompoundBinaryTag getCompound(@Range(from=0L, to=0x7FFFFFFFL) int n2, @NotNull CompoundBinaryTag compoundBinaryTag) {
        BinaryTag binaryTag = this.get(n2);
        if (binaryTag.type() == BinaryTagTypes.COMPOUND) {
            return (CompoundBinaryTag)binaryTag;
        }
        return compoundBinaryTag;
    }

    default public int @NotNull [] getIntArray(@Range(from=0L, to=0x7FFFFFFFL) int n2) {
        BinaryTag binaryTag = this.get(n2);
        if (binaryTag.type() == BinaryTagTypes.INT_ARRAY) {
            return ((IntArrayBinaryTag)binaryTag).value();
        }
        return new int[0];
    }

    default public int @NotNull [] getIntArray(@Range(from=0L, to=0x7FFFFFFFL) int n2, int @NotNull [] nArray) {
        BinaryTag binaryTag = this.get(n2);
        if (binaryTag.type() == BinaryTagTypes.INT_ARRAY) {
            return ((IntArrayBinaryTag)binaryTag).value();
        }
        return nArray;
    }

    default public long @NotNull [] getLongArray(@Range(from=0L, to=0x7FFFFFFFL) int n2) {
        BinaryTag binaryTag = this.get(n2);
        if (binaryTag.type() == BinaryTagTypes.LONG_ARRAY) {
            return ((LongArrayBinaryTag)binaryTag).value();
        }
        return new long[0];
    }

    default public long @NotNull [] getLongArray(@Range(from=0L, to=0x7FFFFFFFL) int n2, long @NotNull [] lArray) {
        BinaryTag binaryTag = this.get(n2);
        if (binaryTag.type() == BinaryTagTypes.LONG_ARRAY) {
            return ((LongArrayBinaryTag)binaryTag).value();
        }
        return lArray;
    }

    @NotNull
    public Stream<BinaryTag> stream();

    @NotNull
    public ListBinaryTag unwrapHeterogeneity();

    @NotNull
    public ListBinaryTag wrapHeterogeneity();

    public static interface Builder<T extends BinaryTag>
    extends ListTagSetter<Builder<T>, T> {
        @NotNull
        public ListBinaryTag build();
    }
}

