/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clans.libs.adventure.adventure.nbt;

import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import me.loving11ish.clans.libs.adventure.adventure.nbt.BinaryTagIO;
import me.loving11ish.clans.libs.adventure.adventure.nbt.BinaryTagTypes;
import me.loving11ish.clans.libs.adventure.adventure.nbt.CompoundBinaryTag;
import me.loving11ish.clans.libs.adventure.adventure.nbt.IOStreamUtil;
import org.jetbrains.annotations.NotNull;

final class BinaryTagWriterImpl
implements BinaryTagIO.Writer {
    static final BinaryTagIO.Writer INSTANCE = new BinaryTagWriterImpl();

    BinaryTagWriterImpl() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void write(@NotNull CompoundBinaryTag compoundBinaryTag, @NotNull Path object, @NotNull BinaryTagIO.Compression compression) {
        object = Files.newOutputStream((Path)object, new OpenOption[0]);
        try {
            this.write(compoundBinaryTag, (OutputStream)object, compression);
            if (object == null) return;
        }
        catch (Throwable throwable) {
            if (object == null) throw throwable;
            try {
                ((OutputStream)object).close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ((OutputStream)object).close();
    }

    @Override
    public final void write(@NotNull CompoundBinaryTag compoundBinaryTag, @NotNull OutputStream outputStream, @NotNull BinaryTagIO.Compression compression) {
        outputStream = new DataOutputStream(new BufferedOutputStream(compression.compress(IOStreamUtil.closeShield(outputStream))));
        try {
            this.write(compoundBinaryTag, (DataOutput)((Object)outputStream));
            return;
        }
        finally {
            ((FilterOutputStream)outputStream).close();
        }
    }

    @Override
    public final void write(@NotNull CompoundBinaryTag compoundBinaryTag, @NotNull DataOutput dataOutput) {
        this.write(compoundBinaryTag, dataOutput, true);
    }

    private void write(@NotNull CompoundBinaryTag compoundBinaryTag, @NotNull DataOutput dataOutput, boolean bl) {
        dataOutput.writeByte(BinaryTagTypes.COMPOUND.id());
        if (bl) {
            dataOutput.writeUTF("");
        }
        BinaryTagTypes.COMPOUND.write(compoundBinaryTag, dataOutput);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void writeNameless(@NotNull CompoundBinaryTag compoundBinaryTag, @NotNull Path object, @NotNull BinaryTagIO.Compression compression) {
        object = Files.newOutputStream((Path)object, new OpenOption[0]);
        try {
            this.writeNameless(compoundBinaryTag, (OutputStream)object, compression);
            if (object == null) return;
        }
        catch (Throwable throwable) {
            if (object == null) throw throwable;
            try {
                ((OutputStream)object).close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ((OutputStream)object).close();
    }

    @Override
    public final void writeNameless(@NotNull CompoundBinaryTag compoundBinaryTag, @NotNull OutputStream outputStream, @NotNull BinaryTagIO.Compression compression) {
        outputStream = new DataOutputStream(new BufferedOutputStream(compression.compress(IOStreamUtil.closeShield(outputStream))));
        try {
            this.writeNameless(compoundBinaryTag, (DataOutput)((Object)outputStream));
            return;
        }
        finally {
            ((FilterOutputStream)outputStream).close();
        }
    }

    @Override
    public final void writeNameless(@NotNull CompoundBinaryTag compoundBinaryTag, @NotNull DataOutput dataOutput) {
        this.write(compoundBinaryTag, dataOutput, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void writeNamed( @NotNull Map.Entry<String, CompoundBinaryTag> entry, @NotNull Path object, @NotNull BinaryTagIO.Compression compression) {
        object = Files.newOutputStream((Path)object, new OpenOption[0]);
        try {
            this.writeNamed(entry, (OutputStream)object, compression);
            if (object == null) return;
        }
        catch (Throwable throwable) {
            if (object == null) throw throwable;
            try {
                ((OutputStream)object).close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ((OutputStream)object).close();
    }

    @Override
    public final void writeNamed( @NotNull Map.Entry<String, CompoundBinaryTag> entry, @NotNull OutputStream outputStream, @NotNull BinaryTagIO.Compression compression) {
        outputStream = new DataOutputStream(new BufferedOutputStream(compression.compress(IOStreamUtil.closeShield(outputStream))));
        try {
            this.writeNamed(entry, (DataOutput)((Object)outputStream));
            return;
        }
        finally {
            ((FilterOutputStream)outputStream).close();
        }
    }

    @Override
    public final void writeNamed( @NotNull Map.Entry<String, CompoundBinaryTag> entry, @NotNull DataOutput dataOutput) {
        dataOutput.writeByte(BinaryTagTypes.COMPOUND.id());
        dataOutput.writeUTF(entry.getKey());
        BinaryTagTypes.COMPOUND.write(entry.getValue(), dataOutput);
    }
}

