/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clans.libs.adventure.adventure.key;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.stream.Stream;
import me.loving11ish.clans.libs.adventure.adventure.key.InvalidKeyException;
import me.loving11ish.clans.libs.adventure.adventure.key.Key;
import me.loving11ish.clans.libs.adventure.examination.ExaminableProperty;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;

final class KeyImpl
implements Key {
    static final Comparator<? super Key> COMPARATOR = Comparator.comparing(Key::value).thenComparing(Key::namespace);
    @RegExp
    static final String NAMESPACE_PATTERN = "[a-z0-9_\\-.]+";
    @RegExp
    static final String VALUE_PATTERN = "[a-z0-9_\\-./]+";
    private final String namespace;
    private final String value;

    KeyImpl(@NotNull String string, @NotNull String string2) {
        String string3 = string;
        KeyImpl.checkError("namespace", string3, string3, string2, Key.checkNamespace(string), NAMESPACE_PATTERN);
        String string4 = string2;
        KeyImpl.checkError("value", string2, string, string4, Key.checkValue(string4), VALUE_PATTERN);
        this.namespace = Objects.requireNonNull(string, "namespace");
        this.value = Objects.requireNonNull(string2, "value");
    }

    private static void checkError(String string, String string2, String string3, String string4, OptionalInt optionalInt, String string5) {
        if (optionalInt.isPresent()) {
            int n2 = optionalInt.getAsInt();
            char c2 = string2.charAt(n2);
            throw new InvalidKeyException(string3, string4, String.format("Non " + string5 + " character in %s of Key[%s] at index %d ('%s', bytes: %s)", string, KeyImpl.asString(string3, string4), n2, Character.valueOf(c2), Arrays.toString(String.valueOf(c2).getBytes(StandardCharsets.UTF_8))));
        }
    }

    static boolean allowedInNamespace(char c2) {
        return c2 == '_' || c2 == '-' || c2 >= 'a' && c2 <= 'z' || c2 >= '0' && c2 <= '9' || c2 == '.';
    }

    static boolean allowedInValue(char c2) {
        return c2 == '_' || c2 == '-' || c2 >= 'a' && c2 <= 'z' || c2 >= '0' && c2 <= '9' || c2 == '.' || c2 == '/';
    }

    @Override
    @NotNull
    public final String namespace() {
        return this.namespace;
    }

    @Override
    @NotNull
    public final String value() {
        return this.value;
    }

    @Override
    @NotNull
    public final String asString() {
        return KeyImpl.asString(this.namespace, this.value);
    }

    @NotNull
    private static String asString(@NotNull String string, @NotNull String string2) {
        return string + ':' + string2;
    }

    @NotNull
    public final String toString() {
        return this.asString();
    }

    @Override
    @NotNull
    public final Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("namespace", this.namespace), ExaminableProperty.of("value", this.value));
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Key)) {
            return false;
        }
        return Objects.equals(this.namespace, (object = (Key)object).namespace()) && Objects.equals(this.value, object.value());
    }

    public final int hashCode() {
        int n2 = this.namespace.hashCode();
        n2 = n2 * 31 + this.value.hashCode();
        return n2;
    }

    @Override
    public final int compareTo(@NotNull Key key) {
        return Key.super.compareTo(key);
    }
}

