/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clans.libs.adventure.adventure.inventory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import me.loving11ish.clans.libs.adventure.adventure.internal.Internals;
import me.loving11ish.clans.libs.adventure.adventure.inventory.Book;
import me.loving11ish.clans.libs.adventure.adventure.text.Component;
import me.loving11ish.clans.libs.adventure.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;

final class BookImpl
implements Book {
    private final Component title;
    private final Component author;
    private final List<Component> pages;

    BookImpl(@NotNull Component component, @NotNull Component component2, @NotNull List<Component> list) {
        this.title = Objects.requireNonNull(component, "title");
        this.author = Objects.requireNonNull(component2, "author");
        this.pages = Collections.unmodifiableList(Objects.requireNonNull(list, "pages"));
    }

    @Override
    @NotNull
    public final Component title() {
        return this.title;
    }

    @Override
    @NotNull
    public final Book title(@NotNull Component component) {
        return new BookImpl(Objects.requireNonNull(component, "title"), this.author, this.pages);
    }

    @Override
    @NotNull
    public final Component author() {
        return this.author;
    }

    @Override
    @NotNull
    public final Book author(@NotNull Component component) {
        return new BookImpl(this.title, Objects.requireNonNull(component, "author"), this.pages);
    }

    @Override
    @NotNull
    public final List<Component> pages() {
        return this.pages;
    }

    @Override
    @NotNull
    public final Book pages(@NotNull List<Component> list) {
        return new BookImpl(this.title, this.author, new ArrayList<Component>((Collection)Objects.requireNonNull(list, "pages")));
    }

    @Override
    @NotNull
    public final Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("title", this.title), ExaminableProperty.of("author", this.author), ExaminableProperty.of("pages", this.pages));
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BookImpl)) {
            return false;
        }
        object = (BookImpl)object;
        return this.title.equals(((BookImpl)object).title) && this.author.equals(((BookImpl)object).author) && this.pages.equals(((BookImpl)object).pages);
    }

    public final int hashCode() {
        int n2 = this.title.hashCode();
        n2 = n2 * 31 + this.author.hashCode();
        n2 = n2 * 31 + this.pages.hashCode();
        return n2;
    }

    public final String toString() {
        return Internals.toString(this);
    }

    static final class BuilderImpl
    implements Book.Builder {
        private Component title = Component.empty();
        private Component author = Component.empty();
        private final List<Component> pages = new ArrayList<Component>();

        BuilderImpl() {
        }

        @Override
        @NotNull
        public final Book.Builder title(@NotNull Component component) {
            this.title = Objects.requireNonNull(component, "title");
            return this;
        }

        @Override
        @NotNull
        public final Book.Builder author(@NotNull Component component) {
            this.author = Objects.requireNonNull(component, "author");
            return this;
        }

        @Override
        @NotNull
        public final Book.Builder addPage(@NotNull Component component) {
            this.pages.add(Objects.requireNonNull(component, "page"));
            return this;
        }

        @Override
        @NotNull
        public final Book.Builder pages(@NotNull Collection<Component> collection) {
            this.pages.addAll(Objects.requireNonNull(collection, "pages"));
            return this;
        }

        @Override
        @NotNull
        public final Book.Builder pages(Component ... componentArray) {
            Collections.addAll(this.pages, componentArray);
            return this;
        }

        @Override
        @NotNull
        public final Book build() {
            return new BookImpl(this.title, this.author, new ArrayList<Component>(this.pages));
        }
    }
}

