/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clans.libs.adventure.adventure.bossbar;

import java.util.Set;
import me.loving11ish.clans.libs.adventure.adventure.audience.Audience;
import me.loving11ish.clans.libs.adventure.adventure.bossbar.BossBarImpl;
import me.loving11ish.clans.libs.adventure.adventure.bossbar.BossBarViewer;
import me.loving11ish.clans.libs.adventure.adventure.text.Component;
import me.loving11ish.clans.libs.adventure.adventure.text.ComponentLike;
import me.loving11ish.clans.libs.adventure.adventure.util.Index;
import me.loving11ish.clans.libs.adventure.examination.Examinable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;

@ApiStatus.NonExtendable
public interface BossBar
extends Examinable {
    public static final float MIN_PROGRESS = 0.0f;
    public static final float MAX_PROGRESS = 1.0f;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    public static final float MIN_PERCENT = 0.0f;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    public static final float MAX_PERCENT = 1.0f;

    @NotNull
    public static BossBar bossBar(@NotNull ComponentLike componentLike, float f2, @NotNull Color color, @NotNull Overlay overlay) {
        BossBarImpl.checkProgress(f2);
        return BossBar.bossBar(componentLike.asComponent(), f2, color, overlay);
    }

    @NotNull
    public static BossBar bossBar(@NotNull Component component, float f2, @NotNull Color color, @NotNull Overlay overlay) {
        BossBarImpl.checkProgress(f2);
        return new BossBarImpl(component, f2, color, overlay);
    }

    @NotNull
    public static BossBar bossBar(@NotNull ComponentLike componentLike, float f2, @NotNull Color color, @NotNull Overlay overlay, @NotNull Set<Flag> set) {
        BossBarImpl.checkProgress(f2);
        return BossBar.bossBar(componentLike.asComponent(), f2, color, overlay, set);
    }

    @NotNull
    public static BossBar bossBar(@NotNull Component component, float f2, @NotNull Color color, @NotNull Overlay overlay, @NotNull Set<Flag> set) {
        BossBarImpl.checkProgress(f2);
        return new BossBarImpl(component, f2, color, overlay, set);
    }

    @NotNull
    public Component name();

    @Contract(value="_ -> this")
    @NotNull
    default public BossBar name(@NotNull ComponentLike componentLike) {
        return this.name(componentLike.asComponent());
    }

    @Contract(value="_ -> this")
    @NotNull
    public BossBar name(@NotNull Component var1);

    public float progress();

    @Contract(value="_ -> this")
    @NotNull
    public BossBar progress(float var1);

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    default public float percent() {
        return this.progress();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    @Contract(value="_ -> this")
    @NotNull
    default public BossBar percent(float f2) {
        return this.progress(f2);
    }

    @NotNull
    public Color color();

    @Contract(value="_ -> this")
    @NotNull
    public BossBar color(@NotNull Color var1);

    @NotNull
    public Overlay overlay();

    @Contract(value="_ -> this")
    @NotNull
    public BossBar overlay(@NotNull Overlay var1);

    public @UnmodifiableView @NotNull Set<Flag> flags();

    @Contract(value="_ -> this")
    @NotNull
    public BossBar flags(@NotNull Set<Flag> var1);

    public boolean hasFlag(@NotNull Flag var1);

    @Contract(value="_ -> this")
    @NotNull
    public BossBar addFlag(@NotNull Flag var1);

    @Contract(value="_ -> this")
    @NotNull
    public BossBar removeFlag(@NotNull Flag var1);

    @Contract(value="_ -> this")
    @NotNull
    public BossBar addFlags(Flag ... var1);

    @Contract(value="_ -> this")
    @NotNull
    public BossBar removeFlags(Flag ... var1);

    @Contract(value="_ -> this")
    @NotNull
    public BossBar addFlags(@NotNull Iterable<Flag> var1);

    @Contract(value="_ -> this")
    @NotNull
    public BossBar removeFlags(@NotNull Iterable<Flag> var1);

    @Contract(value="_ -> this")
    @NotNull
    public BossBar addListener(@NotNull Listener var1);

    @Contract(value="_ -> this")
    @NotNull
    public BossBar removeListener(@NotNull Listener var1);

    public @UnmodifiableView @NotNull Iterable<? extends BossBarViewer> viewers();

    @NotNull
    default public BossBar addViewer(@NotNull Audience audience) {
        audience.showBossBar(this);
        return this;
    }

    @NotNull
    default public BossBar removeViewer(@NotNull Audience audience) {
        audience.hideBossBar(this);
        return this;
    }

    public static enum Color {
        PINK("pink"),
        BLUE("blue"),
        RED("red"),
        GREEN("green"),
        YELLOW("yellow"),
        PURPLE("purple"),
        WHITE("white");

        public static final Index<String, Color> NAMES;
        private final String name;

        private Color(String string2) {
            this.name = string2;
        }

        static {
            NAMES = Index.create(Color.class, color -> color.name);
        }
    }

    public static enum Overlay {
        PROGRESS("progress"),
        NOTCHED_6("notched_6"),
        NOTCHED_10("notched_10"),
        NOTCHED_12("notched_12"),
        NOTCHED_20("notched_20");

        public static final Index<String, Overlay> NAMES;
        private final String name;

        private Overlay(String string2) {
            this.name = string2;
        }

        static {
            NAMES = Index.create(Overlay.class, overlay -> overlay.name);
        }
    }

    public static enum Flag {
        DARKEN_SCREEN("darken_screen"),
        PLAY_BOSS_MUSIC("play_boss_music"),
        CREATE_WORLD_FOG("create_world_fog");

        public static final Index<String, Flag> NAMES;
        private final String name;

        private Flag(String string2) {
            this.name = string2;
        }

        static {
            NAMES = Index.create(Flag.class, flag -> flag.name);
        }
    }

    @ApiStatus.OverrideOnly
    public static interface Listener {
        default public void bossBarNameChanged(@NotNull BossBar bossBar, @NotNull Component component, @NotNull Component component2) {
        }

        default public void bossBarProgressChanged(@NotNull BossBar bossBar, float f2, float f3) {
            this.bossBarPercentChanged(bossBar, f2, f3);
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
        default public void bossBarPercentChanged(@NotNull BossBar bossBar, float f2, float f3) {
        }

        default public void bossBarColorChanged(@NotNull BossBar bossBar, @NotNull Color color, @NotNull Color color2) {
        }

        default public void bossBarOverlayChanged(@NotNull BossBar bossBar, @NotNull Overlay overlay, @NotNull Overlay overlay2) {
        }

        default public void bossBarFlagsChanged(@NotNull BossBar bossBar, @NotNull Set<Flag> set, @NotNull Set<Flag> set2) {
        }
    }
}

