/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clans.libs.adventure.adventure.audience;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collector;
import me.loving11ish.clans.libs.adventure.adventure.audience.Audiences;
import me.loving11ish.clans.libs.adventure.adventure.audience.EmptyAudience;
import me.loving11ish.clans.libs.adventure.adventure.audience.ForwardingAudience;
import me.loving11ish.clans.libs.adventure.adventure.audience.ForwardingAudienceOverrideNotRequired;
import me.loving11ish.clans.libs.adventure.adventure.audience.MessageType;
import me.loving11ish.clans.libs.adventure.adventure.bossbar.BossBar;
import me.loving11ish.clans.libs.adventure.adventure.chat.SignedMessage;
import me.loving11ish.clans.libs.adventure.adventure.dialog.DialogLike;
import me.loving11ish.clans.libs.adventure.adventure.identity.Identified;
import me.loving11ish.clans.libs.adventure.adventure.identity.Identity;
import me.loving11ish.clans.libs.adventure.adventure.inventory.Book;
import me.loving11ish.clans.libs.adventure.adventure.pointer.Pointered;
import me.loving11ish.clans.libs.adventure.adventure.resource.ResourcePackInfo;
import me.loving11ish.clans.libs.adventure.adventure.resource.ResourcePackInfoLike;
import me.loving11ish.clans.libs.adventure.adventure.resource.ResourcePackRequest;
import me.loving11ish.clans.libs.adventure.adventure.resource.ResourcePackRequestLike;
import me.loving11ish.clans.libs.adventure.adventure.sound.Sound;
import me.loving11ish.clans.libs.adventure.adventure.sound.SoundStop;
import me.loving11ish.clans.libs.adventure.adventure.text.Component;
import me.loving11ish.clans.libs.adventure.adventure.text.ComponentLike;
import me.loving11ish.clans.libs.adventure.adventure.title.Title;
import me.loving11ish.clans.libs.adventure.adventure.title.TitlePart;
import me.loving11ish.clans.libs.adventure.examination.Examinable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public interface Audience
extends Pointered {
    @NotNull
    public static Audience empty() {
        return EmptyAudience.INSTANCE;
    }

    @NotNull
    public static Audience audience(Audience ... audienceArray) {
        int n2 = audienceArray.length;
        if (n2 == 0) {
            return Audience.empty();
        }
        if (n2 == 1) {
            return audienceArray[0];
        }
        return Audience.audience(Arrays.asList(audienceArray));
    }

    @NotNull
    public static ForwardingAudience audience(@NotNull Iterable<? extends Audience> iterable) {
        return () -> iterable;
    }

    @NotNull
    public static Collector<? super Audience, ?, ForwardingAudience> toAudience() {
        return Audiences.COLLECTOR;
    }

    @NotNull
    default public Audience filterAudience(@NotNull Predicate<? super Audience> predicate) {
        if (predicate.test(this)) {
            return this;
        }
        return Audience.empty();
    }

    default public void forEachAudience(@NotNull Consumer<? super Audience> consumer) {
        consumer.accept(this);
    }

    @ForwardingAudienceOverrideNotRequired
    default public void sendMessage(@NotNull ComponentLike componentLike) {
        this.sendMessage(componentLike.asComponent());
    }

    default public void sendMessage(@NotNull Component component) {
        this.sendMessage(component, MessageType.SYSTEM);
    }

    @Deprecated
    @ForwardingAudienceOverrideNotRequired
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    default public void sendMessage(@NotNull ComponentLike componentLike, @NotNull MessageType messageType) {
        this.sendMessage(componentLike.asComponent(), messageType);
    }

    @Deprecated
    @ForwardingAudienceOverrideNotRequired
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    default public void sendMessage(@NotNull Component component, @NotNull MessageType messageType) {
        this.sendMessage(Identity.nil(), component, messageType);
    }

    @Deprecated
    @ForwardingAudienceOverrideNotRequired
    default public void sendMessage(@NotNull Identified identified, @NotNull ComponentLike componentLike) {
        this.sendMessage(identified, componentLike.asComponent());
    }

    @Deprecated
    @ForwardingAudienceOverrideNotRequired
    default public void sendMessage(@NotNull Identity identity, @NotNull ComponentLike componentLike) {
        this.sendMessage(identity, componentLike.asComponent());
    }

    @Deprecated
    @ForwardingAudienceOverrideNotRequired
    default public void sendMessage(@NotNull Identified identified, @NotNull Component component) {
        this.sendMessage(identified, component, MessageType.CHAT);
    }

    @Deprecated
    @ForwardingAudienceOverrideNotRequired
    default public void sendMessage(@NotNull Identity identity, @NotNull Component component) {
        this.sendMessage(identity, component, MessageType.CHAT);
    }

    @Deprecated
    @ForwardingAudienceOverrideNotRequired
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    default public void sendMessage(@NotNull Identified identified, @NotNull ComponentLike componentLike, @NotNull MessageType messageType) {
        this.sendMessage(identified, componentLike.asComponent(), messageType);
    }

    @Deprecated
    @ForwardingAudienceOverrideNotRequired
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    default public void sendMessage(@NotNull Identity identity, @NotNull ComponentLike componentLike, @NotNull MessageType messageType) {
        this.sendMessage(identity, componentLike.asComponent(), messageType);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    default public void sendMessage(@NotNull Identified identified, @NotNull Component component, @NotNull MessageType messageType) {
        this.sendMessage(identified.identity(), component, messageType);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    default public void sendMessage(@NotNull Identity identity, @NotNull Component component, @NotNull MessageType messageType) {
    }

    default public void sendMessage(@NotNull Component component,  @NotNull ChatType.Bound bound) {
        this.sendMessage(component, MessageType.CHAT);
    }

    @ForwardingAudienceOverrideNotRequired
    default public void sendMessage(@NotNull ComponentLike componentLike,  @NotNull ChatType.Bound bound) {
        this.sendMessage(componentLike.asComponent(), bound);
    }

    default public void sendMessage(@NotNull SignedMessage signedMessage,  @NotNull ChatType.Bound examinable) {
        Examinable examinable2 = examinable = signedMessage.unsignedContent() != null ? signedMessage.unsignedContent() : Component.text(signedMessage.message());
        if (signedMessage.isSystem()) {
            this.sendMessage((Component)examinable);
            return;
        }
        this.sendMessage(signedMessage.identity(), (Component)examinable, MessageType.CHAT);
    }

    @ForwardingAudienceOverrideNotRequired
    default public void deleteMessage(@NotNull SignedMessage signedMessage) {
        if (signedMessage.canDelete()) {
            this.deleteMessage(Objects.requireNonNull(signedMessage.signature()));
        }
    }

    default public void deleteMessage(@NotNull SignedMessage.Signature signature) {
    }

    @ForwardingAudienceOverrideNotRequired
    default public void sendActionBar(@NotNull ComponentLike componentLike) {
        this.sendActionBar(componentLike.asComponent());
    }

    default public void sendActionBar(@NotNull Component component) {
    }

    @ForwardingAudienceOverrideNotRequired
    default public void sendPlayerListHeader(@NotNull ComponentLike componentLike) {
        this.sendPlayerListHeader(componentLike.asComponent());
    }

    default public void sendPlayerListHeader(@NotNull Component component) {
        this.sendPlayerListHeaderAndFooter(component, Component.empty());
    }

    @ForwardingAudienceOverrideNotRequired
    default public void sendPlayerListFooter(@NotNull ComponentLike componentLike) {
        this.sendPlayerListFooter(componentLike.asComponent());
    }

    default public void sendPlayerListFooter(@NotNull Component component) {
        this.sendPlayerListHeaderAndFooter(Component.empty(), component);
    }

    @ForwardingAudienceOverrideNotRequired
    default public void sendPlayerListHeaderAndFooter(@NotNull ComponentLike componentLike, @NotNull ComponentLike componentLike2) {
        this.sendPlayerListHeaderAndFooter(componentLike.asComponent(), componentLike2.asComponent());
    }

    default public void sendPlayerListHeaderAndFooter(@NotNull Component component, @NotNull Component component2) {
    }

    @ForwardingAudienceOverrideNotRequired
    default public void showTitle(@NotNull Title title) {
        Title.Times times = title.times();
        if (times != null) {
            this.sendTitlePart(TitlePart.TIMES, times);
        }
        this.sendTitlePart(TitlePart.SUBTITLE, title.subtitle());
        this.sendTitlePart(TitlePart.TITLE, title.title());
    }

    default public <T> void sendTitlePart(@NotNull TitlePart<T> titlePart, @NotNull T t2) {
    }

    default public void clearTitle() {
    }

    default public void resetTitle() {
    }

    default public void showBossBar(@NotNull BossBar bossBar) {
    }

    default public void hideBossBar(@NotNull BossBar bossBar) {
    }

    default public void playSound(@NotNull Sound sound) {
    }

    default public void playSound(@NotNull Sound sound, double d2, double d3, double d4) {
    }

    default public void playSound(@NotNull Sound sound, @NotNull Sound.Emitter emitter) {
    }

    @ForwardingAudienceOverrideNotRequired
    default public void stopSound(@NotNull Sound sound) {
        this.stopSound(Objects.requireNonNull(sound, "sound").asStop());
    }

    default public void stopSound(@NotNull SoundStop soundStop) {
    }

    @ForwardingAudienceOverrideNotRequired
    default public void openBook(@NotNull Book.Builder builder) {
        this.openBook(builder.build());
    }

    default public void openBook(@NotNull Book book) {
    }

    @ForwardingAudienceOverrideNotRequired
    default public void sendResourcePacks(@NotNull ResourcePackInfoLike resourcePackInfoLike, ResourcePackInfoLike ... resourcePackInfoLikeArray) {
        this.sendResourcePacks(ResourcePackRequest.addingRequest(resourcePackInfoLike, resourcePackInfoLikeArray));
    }

    @ForwardingAudienceOverrideNotRequired
    default public void sendResourcePacks(@NotNull ResourcePackRequestLike resourcePackRequestLike) {
        this.sendResourcePacks(resourcePackRequestLike.asResourcePackRequest());
    }

    default public void sendResourcePacks(@NotNull ResourcePackRequest resourcePackRequest) {
    }

    @ForwardingAudienceOverrideNotRequired
    default public void removeResourcePacks(@NotNull ResourcePackRequestLike resourcePackRequestLike) {
        this.removeResourcePacks(resourcePackRequestLike.asResourcePackRequest());
    }

    @ForwardingAudienceOverrideNotRequired
    default public void removeResourcePacks(@NotNull ResourcePackRequest object) {
        if ((object = object.packs()).size() == 1) {
            this.removeResourcePacks(((ResourcePackInfo)object.get(0)).id(), new UUID[0]);
        } else if (object.isEmpty()) {
            return;
        }
        UUID[] uUIDArray = new UUID[object.size() - 1];
        for (int i2 = 0; i2 < uUIDArray.length; ++i2) {
            uUIDArray[i2] = ((ResourcePackInfo)object.get(i2 + 1)).id();
        }
        this.removeResourcePacks(((ResourcePackInfo)object.get(0)).id(), uUIDArray);
    }

    @ForwardingAudienceOverrideNotRequired
    default public void removeResourcePacks(@NotNull ResourcePackInfoLike resourcePackInfoLike, ResourcePackInfoLike ... resourcePackInfoLikeArray) {
        UUID[] uUIDArray = new UUID[resourcePackInfoLikeArray.length];
        for (int i2 = 0; i2 < resourcePackInfoLikeArray.length; ++i2) {
            uUIDArray[i2] = resourcePackInfoLikeArray[i2].asResourcePackInfo().id();
        }
        this.removeResourcePacks(resourcePackInfoLike.asResourcePackInfo().id(), uUIDArray);
    }

    default public void removeResourcePacks(@NotNull Iterable<UUID> uUIDArray) {
        Iterator<UUID> iterator = uUIDArray.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        UUID uUID = iterator.next();
        if (!iterator.hasNext()) {
            uUIDArray = new UUID[]{};
        } else if (uUIDArray instanceof Collection) {
            uUIDArray = new UUID[((Collection)uUIDArray).size() - 1];
            for (int i2 = 0; i2 < uUIDArray.length; ++i2) {
                uUIDArray[i2] = iterator.next();
            }
        } else {
            ArrayList<UUID> arrayList = new ArrayList<UUID>();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            uUIDArray = arrayList.toArray(new UUID[0]);
        }
        this.removeResourcePacks(uUID, uUIDArray);
    }

    default public void removeResourcePacks(@NotNull UUID uUID, UUID ... uUIDArray) {
    }

    default public void clearResourcePacks() {
    }

    default public void showDialog(@NotNull DialogLike dialogLike) {
    }
}

