/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clans.libs.adventure.option.value;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.loving11ish.clans.libs.adventure.option.Option;
import me.loving11ish.clans.libs.adventure.option.value.ValueSource;

final class ValueSources {
    static final ValueSource ENVIRONMENT = new EnvironmentVariable("");
    static final ValueSource SYSTEM_PROPERTIES = new SystemProperty("");

    private ValueSources() {
    }

    static final class EnvironmentVariable
    implements ValueSource {
        private static final Pattern ENVIRONMENT_SUBST_PATTERN = Pattern.compile("[:\\-/]");
        private static final String ENVIRONMENT_VAR_SEPARATOR = "_";
        private final String prefix;

        EnvironmentVariable(String string) {
            this.prefix = string.isEmpty() ? "" : string.toUpperCase(Locale.ROOT) + ENVIRONMENT_VAR_SEPARATOR;
        }

        @Override
        public final <T> T value(Option<T> option) {
            CharSequence charSequence = new StringBuffer(option.id().length() + this.prefix.length());
            charSequence.append(this.prefix);
            Matcher matcher = ENVIRONMENT_SUBST_PATTERN.matcher(option.id());
            while (matcher.find()) {
                matcher.appendReplacement((StringBuffer)charSequence, ENVIRONMENT_VAR_SEPARATOR);
            }
            matcher.appendTail((StringBuffer)charSequence);
            charSequence = System.getenv(charSequence.toString().toUpperCase(Locale.ROOT));
            if (charSequence == null) {
                return null;
            }
            return option.valueType().parse((String)charSequence);
        }
    }

    static final class SystemProperty
    implements ValueSource {
        private static final Pattern SYSTEM_PROP_SUBST_PATTERN = Pattern.compile("[:/]");
        private static final String SYSTEM_PROPERTY_SEPARATOR = ".";
        private final String prefix;

        SystemProperty(String string) {
            this.prefix = string.isEmpty() ? "" : string + SYSTEM_PROPERTY_SEPARATOR;
        }

        @Override
        public final <T> T value(Option<T> option) {
            CharSequence charSequence = new StringBuffer(option.id().length() + this.prefix.length());
            charSequence.append(this.prefix);
            Matcher matcher = SYSTEM_PROP_SUBST_PATTERN.matcher(option.id());
            while (matcher.find()) {
                matcher.appendReplacement((StringBuffer)charSequence, SYSTEM_PROPERTY_SEPARATOR);
            }
            matcher.appendTail((StringBuffer)charSequence);
            charSequence = System.getProperty(charSequence.toString());
            if (charSequence == null) {
                return null;
            }
            return option.valueType().parse((String)charSequence);
        }
    }
}

