/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clans.libs.adventure.adventure.text.serializer.gson;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Iterator;
import me.loving11ish.clans.libs.adventure.adventure.key.Key;
import me.loving11ish.clans.libs.adventure.adventure.text.Component;
import me.loving11ish.clans.libs.adventure.adventure.text.event.ClickEvent;
import me.loving11ish.clans.libs.adventure.adventure.text.event.HoverEvent;
import me.loving11ish.clans.libs.adventure.adventure.text.format.Style;
import me.loving11ish.clans.libs.adventure.adventure.text.format.TextDecoration;
import me.loving11ish.clans.libs.adventure.adventure.text.serializer.gson.ComponentSerializerImpl;
import me.loving11ish.clans.libs.adventure.adventure.text.serializer.gson.GsonHacks;
import me.loving11ish.clans.libs.adventure.adventure.text.serializer.gson.SerializerFactory;
import me.loving11ish.clans.libs.adventure.adventure.text.serializer.gson.TextColorWrapper;
import me.loving11ish.clans.libs.adventure.adventure.text.serializer.json.JSONOptions;
import me.loving11ish.clans.libs.adventure.adventure.text.serializer.json.LegacyHoverEventSerializer;
import me.loving11ish.clans.libs.adventure.adventure.util.ARGBLike;
import me.loving11ish.clans.libs.adventure.adventure.util.Codec;
import me.loving11ish.clans.libs.adventure.option.OptionState;
import org.jetbrains.annotations.Nullable;

final class StyleSerializer
extends TypeAdapter<Style> {
    private static final TextDecoration[] DECORATIONS = new TextDecoration[]{TextDecoration.BOLD, TextDecoration.ITALIC, TextDecoration.UNDERLINED, TextDecoration.STRIKETHROUGH, TextDecoration.OBFUSCATED};
    private final LegacyHoverEventSerializer legacyHover;
    private final boolean emitValueFieldHover;
    private final boolean emitCamelCaseHover;
    private final boolean emitSnakeCaseHover;
    private final boolean emitCamelCaseClick;
    private final boolean emitSnakeCaseClick;
    private final boolean strictEventValues;
    private final boolean emitShadowColor;
    private final Gson gson;

    static TypeAdapter<Style> create(@Nullable LegacyHoverEventSerializer legacyHoverEventSerializer, OptionState optionState, Gson gson) {
        JSONOptions.HoverEventValueMode hoverEventValueMode = optionState.value(JSONOptions.EMIT_HOVER_EVENT_TYPE);
        JSONOptions.ClickEventValueMode clickEventValueMode = optionState.value(JSONOptions.EMIT_CLICK_EVENT_TYPE);
        return new StyleSerializer(legacyHoverEventSerializer, hoverEventValueMode == JSONOptions.HoverEventValueMode.VALUE_FIELD || hoverEventValueMode == JSONOptions.HoverEventValueMode.ALL, hoverEventValueMode == JSONOptions.HoverEventValueMode.CAMEL_CASE || hoverEventValueMode == JSONOptions.HoverEventValueMode.ALL, hoverEventValueMode == JSONOptions.HoverEventValueMode.SNAKE_CASE || hoverEventValueMode == JSONOptions.HoverEventValueMode.ALL, clickEventValueMode == JSONOptions.ClickEventValueMode.CAMEL_CASE || clickEventValueMode == JSONOptions.ClickEventValueMode.BOTH, clickEventValueMode == JSONOptions.ClickEventValueMode.SNAKE_CASE || clickEventValueMode == JSONOptions.ClickEventValueMode.BOTH, optionState.value(JSONOptions.VALIDATE_STRICT_EVENTS), optionState.value(JSONOptions.SHADOW_COLOR_MODE) != JSONOptions.ShadowColorEmitMode.NONE, gson).nullSafe();
    }

    private StyleSerializer(@Nullable LegacyHoverEventSerializer legacyHoverEventSerializer, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, Gson gson) {
        this.legacyHover = legacyHoverEventSerializer;
        this.emitValueFieldHover = bl;
        this.emitCamelCaseHover = bl2;
        this.emitSnakeCaseHover = bl3;
        this.emitCamelCaseClick = bl4;
        this.emitSnakeCaseClick = bl5;
        this.strictEventValues = bl6;
        this.emitShadowColor = bl7;
        this.gson = gson;
    }

    public final Style read(JsonReader jsonReader) {
        jsonReader.beginObject();
        Style.Builder builder = Style.style();
        while (jsonReader.hasNext()) {
            Object object;
            Object object2;
            Object object3 = jsonReader.nextName();
            if (((String)object3).equals("font")) {
                builder.font((Key)this.gson.fromJson(jsonReader, SerializerFactory.KEY_TYPE));
                continue;
            }
            if (((String)object3).equals("color")) {
                object3 = (TextColorWrapper)this.gson.fromJson(jsonReader, SerializerFactory.COLOR_WRAPPER_TYPE);
                if (((TextColorWrapper)object3).color != null) {
                    builder.color(((TextColorWrapper)object3).color);
                    continue;
                }
                if (((TextColorWrapper)object3).decoration == null) continue;
                builder.decoration(((TextColorWrapper)object3).decoration, TextDecoration.State.TRUE);
                continue;
            }
            if (((String)object3).equals("shadow_color")) {
                builder.shadowColor((ARGBLike)this.gson.fromJson(jsonReader, SerializerFactory.SHADOW_COLOR_TYPE));
                continue;
            }
            if (TextDecoration.NAMES.keys().contains(object3)) {
                builder.decoration(TextDecoration.NAMES.value((String)object3), GsonHacks.readBoolean(jsonReader));
                continue;
            }
            if (((String)object3).equals("insertion")) {
                builder.insertion(jsonReader.nextString());
                continue;
            }
            if (((String)object3).equals("click_event") || ((String)object3).equals("clickEvent")) {
                jsonReader.beginObject();
                object3 = null;
                object2 = null;
                while (jsonReader.hasNext()) {
                    object = jsonReader.nextName();
                    if (((String)object).equals("action")) {
                        object3 = (ClickEvent.Action)((Object)this.gson.fromJson(jsonReader, SerializerFactory.CLICK_ACTION_TYPE));
                        continue;
                    }
                    if (((String)object).equals("value") || ((String)object).equals("url") || ((String)object).equals("path") || ((String)object).equals("command") || ((String)object).equals("page")) {
                        if (jsonReader.peek() == JsonToken.NULL) {
                            if (this.strictEventValues) {
                                throw ComponentSerializerImpl.notSureHowToDeserialize(object);
                            }
                            jsonReader.nextNull();
                            continue;
                        }
                        object2 = jsonReader.nextString();
                        continue;
                    }
                    jsonReader.skipValue();
                }
                if (object3 != null && ((ClickEvent.Action)((Object)object3)).readable() && object2 != null) {
                    builder.clickEvent(ClickEvent.clickEvent((ClickEvent.Action)((Object)object3), object2));
                }
                jsonReader.endObject();
                continue;
            }
            if (((String)object3).equals("hover_event") || ((String)object3).equals("hoverEvent")) {
                object3 = (JsonObject)this.gson.fromJson(jsonReader, JsonObject.class);
                if (object3 == null || (object2 = object3.getAsJsonPrimitive("action")) == null || !((HoverEvent.Action)(object = (HoverEvent.Action)this.gson.fromJson((JsonElement)object2, SerializerFactory.HOVER_ACTION_TYPE))).readable()) continue;
                object2 = ((HoverEvent.Action)object).type();
                if (object3.has("contents")) {
                    if (GsonHacks.isNullOrEmpty((JsonElement)(object3 = object3.get("contents")))) {
                        if (this.strictEventValues) {
                            throw ComponentSerializerImpl.notSureHowToDeserialize(object3);
                        }
                        object3 = null;
                    } else {
                        object3 = SerializerFactory.COMPONENT_TYPE.isAssignableFrom((Class<?>)object2) ? this.gson.fromJson((JsonElement)object3, SerializerFactory.COMPONENT_TYPE) : (SerializerFactory.SHOW_ITEM_TYPE.isAssignableFrom((Class<?>)object2) ? this.gson.fromJson((JsonElement)object3, SerializerFactory.SHOW_ITEM_TYPE) : (SerializerFactory.SHOW_ENTITY_TYPE.isAssignableFrom((Class<?>)object2) ? this.gson.fromJson((JsonElement)object3, SerializerFactory.SHOW_ENTITY_TYPE) : null));
                    }
                } else if (object3.has("value")) {
                    if (GsonHacks.isNullOrEmpty((JsonElement)(object3 = object3.get("value")))) {
                        if (this.strictEventValues) {
                            throw ComponentSerializerImpl.notSureHowToDeserialize(object3);
                        }
                        object3 = null;
                    } else if (SerializerFactory.COMPONENT_TYPE.isAssignableFrom((Class<?>)object2)) {
                        object3 = (Component)this.gson.fromJson((JsonElement)object3, SerializerFactory.COMPONENT_TYPE);
                        object3 = this.legacyHoverEventContents((HoverEvent.Action<?>)object, (Component)object3);
                    } else {
                        object3 = SerializerFactory.STRING_TYPE.isAssignableFrom((Class<?>)object2) ? this.gson.fromJson((JsonElement)object3, SerializerFactory.STRING_TYPE) : null;
                    }
                } else if (SerializerFactory.SHOW_ITEM_TYPE.isAssignableFrom((Class<?>)object2)) {
                    object3 = this.gson.fromJson((JsonElement)object3, SerializerFactory.SHOW_ITEM_TYPE);
                } else if (SerializerFactory.SHOW_ENTITY_TYPE.isAssignableFrom((Class<?>)object2)) {
                    object3 = this.gson.fromJson((JsonElement)object3, SerializerFactory.SHOW_ENTITY_TYPE);
                } else {
                    if (this.strictEventValues) {
                        throw ComponentSerializerImpl.notSureHowToDeserialize(object3);
                    }
                    object3 = null;
                }
                if (object3 == null) continue;
                builder.hoverEvent(HoverEvent.hoverEvent(object, object3));
                continue;
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return builder.build();
    }

    private Object legacyHoverEventContents(HoverEvent.Action<?> action, Component component) {
        if (action == HoverEvent.Action.SHOW_TEXT) {
            return component;
        }
        if (this.legacyHover != null) {
            try {
                if (action == HoverEvent.Action.SHOW_ENTITY) {
                    return this.legacyHover.deserializeShowEntity(component, this.decoder());
                }
                if (action == HoverEvent.Action.SHOW_ITEM) {
                    return this.legacyHover.deserializeShowItem(component);
                }
            }
            catch (IOException iOException) {
                throw new JsonParseException((Throwable)iOException);
            }
        }
        throw new UnsupportedOperationException();
    }

    private Codec.Decoder<Component, String, JsonParseException> decoder() {
        return string -> (Component)this.gson.fromJson(string, SerializerFactory.COMPONENT_TYPE);
    }

    private Codec.Encoder<Component, String, JsonParseException> encoder() {
        return component -> this.gson.toJson(component, SerializerFactory.COMPONENT_TYPE);
    }

    public final void write(JsonWriter jsonWriter, Style style) {
        HoverEvent<?> hoverEvent;
        String string;
        Iterator iterator;
        Object object3;
        jsonWriter.beginObject();
        for (TextDecoration textDecoration : DECORATIONS) {
            object3 = style.decoration(textDecoration);
            if (object3 == TextDecoration.State.NOT_SET) continue;
            String string2 = TextDecoration.NAMES.key(textDecoration);
            assert (string2 != null);
            jsonWriter.name(string2);
            jsonWriter.value(object3 == TextDecoration.State.TRUE);
        }
        @Nullable Object object2 = style.color();
        if (object2 != null) {
            jsonWriter.name("color");
            this.gson.toJson(object2, SerializerFactory.COLOR_TYPE, jsonWriter);
        }
        if ((iterator = style.shadowColor()) != null && this.emitShadowColor) {
            jsonWriter.name("shadow_color");
            this.gson.toJson((Object)iterator, SerializerFactory.SHADOW_COLOR_TYPE, jsonWriter);
        }
        if ((string = style.insertion()) != null) {
            jsonWriter.name("insertion");
            jsonWriter.value(string);
        }
        if ((object3 = style.clickEvent()) != null) {
            @Nullable ClickEvent.Action action = ((ClickEvent)object3).action();
            if (this.emitSnakeCaseClick) {
                jsonWriter.name("click_event");
                jsonWriter.beginObject();
                jsonWriter.name("action");
                this.gson.toJson((Object)action, SerializerFactory.CLICK_ACTION_TYPE, jsonWriter);
                if (action == ClickEvent.Action.OPEN_URL) {
                    jsonWriter.name("url");
                } else if (action == ClickEvent.Action.OPEN_FILE) {
                    jsonWriter.name("path");
                } else if (action == ClickEvent.Action.RUN_COMMAND || action == ClickEvent.Action.SUGGEST_COMMAND) {
                    jsonWriter.name("command");
                } else if (action == ClickEvent.Action.CHANGE_PAGE) {
                    jsonWriter.name("page");
                } else {
                    jsonWriter.name("value");
                }
                if (action == ClickEvent.Action.CHANGE_PAGE) {
                    jsonWriter.value((long)Integer.parseInt(((ClickEvent)object3).value()));
                } else if (action == ClickEvent.Action.OPEN_URL) {
                    if (((ClickEvent)object3).value().startsWith("http://") || ((ClickEvent)object3).value().startsWith("https://")) {
                        jsonWriter.value(((ClickEvent)object3).value());
                    } else {
                        jsonWriter.value("https://" + ((ClickEvent)object3).value());
                    }
                } else {
                    jsonWriter.value(((ClickEvent)object3).value());
                }
                jsonWriter.endObject();
            }
            if (this.emitCamelCaseClick) {
                jsonWriter.name("clickEvent");
                jsonWriter.beginObject();
                jsonWriter.name("action");
                this.gson.toJson((Object)action, SerializerFactory.CLICK_ACTION_TYPE, jsonWriter);
                jsonWriter.name("value");
                jsonWriter.value(((ClickEvent)object3).value());
                jsonWriter.endObject();
            }
        }
        if ((hoverEvent = style.hoverEvent()) != null && ((this.emitSnakeCaseHover || this.emitCamelCaseHover) && hoverEvent.action() != HoverEvent.Action.SHOW_ACHIEVEMENT || this.emitValueFieldHover)) {
            object2 = hoverEvent.action();
            if (this.emitSnakeCaseHover && object2 != HoverEvent.Action.SHOW_ACHIEVEMENT) {
                jsonWriter.name("hover_event");
                jsonWriter.beginObject();
                jsonWriter.name("action");
                this.gson.toJson(object2, SerializerFactory.HOVER_ACTION_TYPE, jsonWriter);
                if (object2 == HoverEvent.Action.SHOW_ITEM) {
                    for (Object object3 : this.gson.toJsonTree(hoverEvent.value(), SerializerFactory.SHOW_ITEM_TYPE).getAsJsonObject().entrySet()) {
                        jsonWriter.name((String)object3.getKey());
                        this.gson.toJson((JsonElement)object3.getValue(), jsonWriter);
                    }
                } else if (object2 == HoverEvent.Action.SHOW_ENTITY) {
                    for (Object object3 : this.gson.toJsonTree(hoverEvent.value(), SerializerFactory.SHOW_ENTITY_TYPE).getAsJsonObject().entrySet()) {
                        jsonWriter.name((String)object3.getKey());
                        this.gson.toJson((JsonElement)object3.getValue(), jsonWriter);
                    }
                } else if (object2 == HoverEvent.Action.SHOW_TEXT) {
                    jsonWriter.name("value");
                    this.gson.toJson(hoverEvent.value(), SerializerFactory.COMPONENT_TYPE, jsonWriter);
                } else {
                    throw new JsonParseException("Don't know how to serialize " + hoverEvent.value());
                }
                jsonWriter.endObject();
            }
            if (this.emitCamelCaseHover || this.emitValueFieldHover) {
                jsonWriter.name("hoverEvent");
                jsonWriter.beginObject();
                jsonWriter.name("action");
                this.gson.toJson(object2, SerializerFactory.HOVER_ACTION_TYPE, jsonWriter);
                if (this.emitCamelCaseHover && object2 != HoverEvent.Action.SHOW_ACHIEVEMENT) {
                    jsonWriter.name("contents");
                    if (object2 == HoverEvent.Action.SHOW_ITEM) {
                        this.gson.toJson(hoverEvent.value(), SerializerFactory.SHOW_ITEM_TYPE, jsonWriter);
                    } else if (object2 == HoverEvent.Action.SHOW_ENTITY) {
                        this.gson.toJson(hoverEvent.value(), SerializerFactory.SHOW_ENTITY_TYPE, jsonWriter);
                    } else if (object2 == HoverEvent.Action.SHOW_TEXT) {
                        this.gson.toJson(hoverEvent.value(), SerializerFactory.COMPONENT_TYPE, jsonWriter);
                    } else {
                        throw new JsonParseException("Don't know how to serialize " + hoverEvent.value());
                    }
                }
                if (this.emitValueFieldHover) {
                    jsonWriter.name("value");
                    this.serializeLegacyHoverEvent(hoverEvent, jsonWriter);
                }
                jsonWriter.endObject();
            }
        }
        if ((object2 = style.font()) != null) {
            jsonWriter.name("font");
            this.gson.toJson(object2, SerializerFactory.KEY_TYPE, jsonWriter);
        }
        jsonWriter.endObject();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void serializeLegacyHoverEvent(HoverEvent<?> hoverEvent, JsonWriter jsonWriter) {
        Component component;
        block8: {
            if (hoverEvent.action() == HoverEvent.Action.SHOW_TEXT) {
                this.gson.toJson(hoverEvent.value(), SerializerFactory.COMPONENT_TYPE, jsonWriter);
                return;
            }
            if (hoverEvent.action() == HoverEvent.Action.SHOW_ACHIEVEMENT) {
                this.gson.toJson(hoverEvent.value(), String.class, jsonWriter);
                return;
            }
            if (this.legacyHover == null) {
                jsonWriter.nullValue();
                return;
            }
            component = null;
            try {
                if (hoverEvent.action() == HoverEvent.Action.SHOW_ENTITY) {
                    component = this.legacyHover.serializeShowEntity((HoverEvent.ShowEntity)hoverEvent.value(), this.encoder());
                    break block8;
                }
                if (hoverEvent.action() == HoverEvent.Action.SHOW_ITEM) {
                    component = this.legacyHover.serializeShowItem((HoverEvent.ShowItem)hoverEvent.value());
                }
            }
            catch (IOException iOException) {
                throw new JsonSyntaxException((Throwable)iOException);
            }
        }
        if (component != null) {
            this.gson.toJson((Object)component, SerializerFactory.COMPONENT_TYPE, jsonWriter);
            return;
        }
        jsonWriter.nullValue();
    }

    static {
        EnumSet<TextDecoration> enumSet = EnumSet.allOf(TextDecoration.class);
        TextDecoration[] textDecorationArray = DECORATIONS;
        int n2 = DECORATIONS.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            TextDecoration textDecoration = textDecorationArray[i2];
            enumSet.remove(textDecoration);
        }
        if (!enumSet.isEmpty()) {
            throw new IllegalStateException("Gson serializer is missing some text decorations: " + enumSet);
        }
    }
}

