/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clans.libs.adventure.adventure.text.serializer.gson;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.util.UUID;
import me.loving11ish.clans.libs.adventure.adventure.key.InvalidKeyException;
import me.loving11ish.clans.libs.adventure.adventure.key.Key;
import me.loving11ish.clans.libs.adventure.adventure.text.Component;
import me.loving11ish.clans.libs.adventure.adventure.text.event.HoverEvent;
import me.loving11ish.clans.libs.adventure.adventure.text.serializer.gson.SerializerFactory;
import me.loving11ish.clans.libs.adventure.adventure.text.serializer.json.JSONOptions;
import me.loving11ish.clans.libs.adventure.option.OptionState;

final class ShowEntitySerializer
extends TypeAdapter<HoverEvent.ShowEntity> {
    private final Gson gson;
    private final boolean emitKeyAsTypeAndUuidAsId;

    static TypeAdapter<HoverEvent.ShowEntity> create(Gson gson, OptionState optionState) {
        return new ShowEntitySerializer(gson, optionState.value(JSONOptions.EMIT_HOVER_SHOW_ENTITY_KEY_AS_TYPE_AND_UUID_AS_ID)).nullSafe();
    }

    private ShowEntitySerializer(Gson gson, boolean bl) {
        this.gson = gson;
        this.emitKeyAsTypeAndUuidAsId = bl;
    }

    public final HoverEvent.ShowEntity read(JsonReader jsonReader) {
        jsonReader.beginObject();
        Key key = null;
        UUID uUID = null;
        Component component = null;
        block16: while (jsonReader.hasNext()) {
            switch (jsonReader.nextName()) {
                case "id": {
                    if (jsonReader.peek() == JsonToken.BEGIN_ARRAY) {
                        uUID = (UUID)this.gson.fromJson(jsonReader, UUID.class);
                        continue block16;
                    }
                    String string = jsonReader.nextString();
                    if (string.contains(":")) {
                        key = Key.key(string);
                    }
                    try {
                        uUID = UUID.fromString(string);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        try {
                            key = Key.key(string);
                        }
                        catch (InvalidKeyException invalidKeyException) {}
                    }
                    continue block16;
                }
                case "type": {
                    key = (Key)this.gson.fromJson(jsonReader, Key.class);
                    continue block16;
                }
                case "uuid": {
                    uUID = (UUID)this.gson.fromJson(jsonReader, UUID.class);
                    continue block16;
                }
                case "name": {
                    component = (Component)this.gson.fromJson(jsonReader, SerializerFactory.COMPONENT_TYPE);
                    continue block16;
                }
            }
            jsonReader.skipValue();
        }
        if (key == null || uUID == null) {
            throw new JsonParseException("A show entity hover event needs type and id fields to be deserialized");
        }
        jsonReader.endObject();
        return HoverEvent.ShowEntity.showEntity(key, uUID, component);
    }

    public final void write(JsonWriter jsonWriter, HoverEvent.ShowEntity examinable) {
        jsonWriter.beginObject();
        jsonWriter.name(this.emitKeyAsTypeAndUuidAsId ? "type" : "id");
        this.gson.toJson((Object)examinable.type(), SerializerFactory.KEY_TYPE, jsonWriter);
        jsonWriter.name(this.emitKeyAsTypeAndUuidAsId ? "id" : "uuid");
        this.gson.toJson((Object)examinable.id(), SerializerFactory.UUID_TYPE, jsonWriter);
        examinable = examinable.name();
        if (examinable != null) {
            jsonWriter.name("name");
            this.gson.toJson((Object)examinable, SerializerFactory.COMPONENT_TYPE, jsonWriter);
        }
        jsonWriter.endObject();
    }
}

