/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clans.libs.adventure.adventure.text.serializer.gson;

import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import me.loving11ish.clans.libs.adventure.adventure.text.format.ShadowColor;
import me.loving11ish.clans.libs.adventure.adventure.text.serializer.json.JSONOptions;
import me.loving11ish.clans.libs.adventure.option.OptionState;

final class ShadowColorSerializer
extends TypeAdapter<ShadowColor> {
    private final boolean emitArray;

    static TypeAdapter<ShadowColor> create(OptionState optionState) {
        return new ShadowColorSerializer(optionState.value(JSONOptions.SHADOW_COLOR_MODE) == JSONOptions.ShadowColorEmitMode.EMIT_ARRAY).nullSafe();
    }

    private ShadowColorSerializer(boolean bl) {
        this.emitArray = bl;
    }

    public final void write(JsonWriter jsonWriter, ShadowColor shadowColor) {
        if (this.emitArray) {
            jsonWriter.beginArray().value((double)ShadowColorSerializer.componentAsFloat(shadowColor.red())).value((double)ShadowColorSerializer.componentAsFloat(shadowColor.green())).value((double)ShadowColorSerializer.componentAsFloat(shadowColor.blue())).value((double)ShadowColorSerializer.componentAsFloat(shadowColor.alpha())).endArray();
            return;
        }
        jsonWriter.value((long)shadowColor.value());
    }

    public final ShadowColor read(JsonReader jsonReader) {
        if (jsonReader.peek() == JsonToken.BEGIN_ARRAY) {
            jsonReader.beginArray();
            double d2 = jsonReader.nextDouble();
            double d3 = jsonReader.nextDouble();
            double d4 = jsonReader.nextDouble();
            double d5 = jsonReader.nextDouble();
            if (jsonReader.peek() != JsonToken.END_ARRAY) {
                throw new JsonParseException("Failed to parse shadow colour at " + jsonReader.getPath() + ": expected end of 4-element array but got " + jsonReader.peek() + " instead.");
            }
            jsonReader.endArray();
            return ShadowColor.shadowColor(ShadowColorSerializer.componentFromFloat(d2), ShadowColorSerializer.componentFromFloat(d3), ShadowColorSerializer.componentFromFloat(d4), ShadowColorSerializer.componentFromFloat(d5));
        }
        return ShadowColor.shadowColor(jsonReader.nextInt());
    }

    static float componentAsFloat(int n2) {
        return (float)n2 / 255.0f;
    }

    static int componentFromFloat(double d2) {
        return (int)((float)d2 * 255.0f);
    }
}

