/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clans.libs.adventure.adventure.text.serializer.gson;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import me.loving11ish.clans.libs.adventure.adventure.key.Key;
import me.loving11ish.clans.libs.adventure.adventure.text.BlockNBTComponent;
import me.loving11ish.clans.libs.adventure.adventure.text.BuildableComponent;
import me.loving11ish.clans.libs.adventure.adventure.text.Component;
import me.loving11ish.clans.libs.adventure.adventure.text.ComponentLike;
import me.loving11ish.clans.libs.adventure.adventure.text.EntityNBTComponent;
import me.loving11ish.clans.libs.adventure.adventure.text.KeybindComponent;
import me.loving11ish.clans.libs.adventure.adventure.text.NBTComponent;
import me.loving11ish.clans.libs.adventure.adventure.text.NBTComponentBuilder;
import me.loving11ish.clans.libs.adventure.adventure.text.ScoreComponent;
import me.loving11ish.clans.libs.adventure.adventure.text.SelectorComponent;
import me.loving11ish.clans.libs.adventure.adventure.text.StorageNBTComponent;
import me.loving11ish.clans.libs.adventure.adventure.text.TextComponent;
import me.loving11ish.clans.libs.adventure.adventure.text.TranslatableComponent;
import me.loving11ish.clans.libs.adventure.adventure.text.TranslationArgument;
import me.loving11ish.clans.libs.adventure.adventure.text.format.Style;
import me.loving11ish.clans.libs.adventure.adventure.text.serializer.gson.GsonHacks;
import me.loving11ish.clans.libs.adventure.adventure.text.serializer.gson.SerializerFactory;
import me.loving11ish.clans.libs.adventure.adventure.text.serializer.json.JSONOptions;
import me.loving11ish.clans.libs.adventure.adventure.util.Buildable;
import me.loving11ish.clans.libs.adventure.option.OptionState;
import org.jetbrains.annotations.Nullable;

final class ComponentSerializerImpl
extends TypeAdapter<Component> {
    static final Type COMPONENT_LIST_TYPE = new TypeToken<List<Component>>(){}.getType();
    static final Type TRANSLATABLE_ARGUMENT_LIST_TYPE = new TypeToken<List<TranslationArgument>>(){}.getType();
    private final boolean emitCompactTextComponent;
    private final Gson gson;

    static TypeAdapter<Component> create(OptionState optionState, Gson gson) {
        return new ComponentSerializerImpl(optionState.value(JSONOptions.EMIT_COMPACT_TEXT_COMPONENT), gson).nullSafe();
    }

    private ComponentSerializerImpl(boolean bl, Gson gson) {
        this.emitCompactTextComponent = bl;
        this.gson = gson;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final BuildableComponent<?, ?> read(JsonReader jsonReader) {
        Object object;
        JsonToken jsonToken = jsonReader.peek();
        if (jsonToken == JsonToken.STRING || jsonToken == JsonToken.NUMBER || jsonToken == JsonToken.BOOLEAN) {
            return Component.text(GsonHacks.readString(jsonReader));
        }
        if (jsonToken == JsonToken.BEGIN_ARRAY) {
            void var2_4;
            Object var2_3 = null;
            jsonReader.beginArray();
            while (jsonReader.hasNext()) {
                Object object2 = this.read(jsonReader);
                if (var2_4 == null) {
                    Buildable.Builder builder = object2.toBuilder();
                    continue;
                }
                var2_4.append((Component)object2);
            }
            if (var2_4 == null) {
                throw ComponentSerializerImpl.notSureHowToDeserialize(jsonReader.getPath());
            }
            jsonReader.endArray();
            return var2_4.build();
        }
        if (jsonToken != JsonToken.BEGIN_OBJECT) {
            throw ComponentSerializerImpl.notSureHowToDeserialize(jsonReader.getPath());
        }
        JsonObject jsonObject = new JsonObject();
        List list = Collections.emptyList();
        String string = null;
        String string2 = null;
        String string3 = null;
        List list2 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        boolean bl = false;
        BlockNBTComponent.Pos pos = null;
        String string10 = null;
        Key key = null;
        Object object3 = null;
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            object = jsonReader.nextName();
            if (((String)object).equals("text")) {
                string = GsonHacks.readString(jsonReader);
                continue;
            }
            if (((String)object).equals("translate")) {
                string2 = jsonReader.nextString();
                continue;
            }
            if (((String)object).equals("fallback")) {
                string3 = jsonReader.nextString();
                continue;
            }
            if (((String)object).equals("with")) {
                list2 = (List)this.gson.fromJson(jsonReader, TRANSLATABLE_ARGUMENT_LIST_TYPE);
                continue;
            }
            if (((String)object).equals("score")) {
                jsonReader.beginObject();
                while (jsonReader.hasNext()) {
                    object = jsonReader.nextName();
                    if (((String)object).equals("name")) {
                        string4 = jsonReader.nextString();
                        continue;
                    }
                    if (((String)object).equals("objective")) {
                        string5 = jsonReader.nextString();
                        continue;
                    }
                    if (((String)object).equals("value")) {
                        string6 = jsonReader.nextString();
                        continue;
                    }
                    jsonReader.skipValue();
                }
                if (string4 == null || string5 == null) {
                    throw new JsonParseException("A score component requires a name and objective");
                }
                jsonReader.endObject();
                continue;
            }
            if (((String)object).equals("selector")) {
                string7 = jsonReader.nextString();
                continue;
            }
            if (((String)object).equals("keybind")) {
                string8 = jsonReader.nextString();
                continue;
            }
            if (((String)object).equals("nbt")) {
                string9 = jsonReader.nextString();
                continue;
            }
            if (((String)object).equals("interpret")) {
                bl = jsonReader.nextBoolean();
                continue;
            }
            if (((String)object).equals("block")) {
                pos = (BlockNBTComponent.Pos)this.gson.fromJson(jsonReader, SerializerFactory.BLOCK_NBT_POS_TYPE);
                continue;
            }
            if (((String)object).equals("entity")) {
                string10 = jsonReader.nextString();
                continue;
            }
            if (((String)object).equals("storage")) {
                key = (Key)this.gson.fromJson(jsonReader, SerializerFactory.KEY_TYPE);
                continue;
            }
            if (((String)object).equals("extra")) {
                list = (List)this.gson.fromJson(jsonReader, COMPONENT_LIST_TYPE);
                continue;
            }
            if (((String)object).equals("separator")) {
                object3 = this.read(jsonReader);
                continue;
            }
            jsonObject.add((String)object, (JsonElement)this.gson.fromJson(jsonReader, JsonElement.class));
        }
        if (string != null) {
            object = Component.text().content(string);
        } else if (string2 != null) {
            object = list2 != null ? Component.translatable().key(string2).fallback(string3).arguments(list2) : Component.translatable().key(string2).fallback(string3);
        } else if (string4 != null && string5 != null) {
            object = string6 == null ? Component.score().name(string4).objective(string5) : Component.score().name(string4).objective(string5).value(string6);
        } else if (string7 != null) {
            object = Component.selector().pattern(string7).separator((ComponentLike)object3);
        } else if (string8 != null) {
            object = Component.keybind().keybind(string8);
        } else {
            if (string9 == null) throw ComponentSerializerImpl.notSureHowToDeserialize(jsonReader.getPath());
            if (pos != null) {
                object = ComponentSerializerImpl.nbt(Component.blockNBT(), string9, bl, object3).pos(pos);
            } else if (string10 != null) {
                object = ComponentSerializerImpl.nbt(Component.entityNBT(), string9, bl, object3).selector(string10);
            } else {
                if (key == null) throw ComponentSerializerImpl.notSureHowToDeserialize(jsonReader.getPath());
                object = ComponentSerializerImpl.nbt(Component.storageNBT(), string9, bl, object3).storage(key);
            }
        }
        object.style((Style)this.gson.fromJson((JsonElement)jsonObject, SerializerFactory.STYLE_TYPE)).append(list);
        jsonReader.endObject();
        return object.build();
    }

    private static <C extends NBTComponent<C, B>, B extends NBTComponentBuilder<C, B>> B nbt(B b2, String string, boolean bl, @Nullable Component component) {
        return b2.nbtPath(string).interpret(bl).separator(component);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void write(JsonWriter jsonWriter, Component component) {
        Object object2;
        if (component instanceof TextComponent && component.children().isEmpty() && !component.hasStyling() && this.emitCompactTextComponent) {
            jsonWriter.value(((TextComponent)component).content());
            return;
        }
        jsonWriter.beginObject();
        if (component.hasStyling() && (object2 = this.gson.toJsonTree((Object)component.style(), SerializerFactory.STYLE_TYPE)).isJsonObject()) {
            for (Object object2 : object2.getAsJsonObject().entrySet()) {
                jsonWriter.name((String)object2.getKey());
                this.gson.toJson((JsonElement)object2.getValue(), jsonWriter);
            }
        }
        if (!component.children().isEmpty()) {
            jsonWriter.name("extra");
            this.gson.toJson(component.children(), COMPONENT_LIST_TYPE, jsonWriter);
        }
        if (component instanceof TextComponent) {
            jsonWriter.name("text");
            jsonWriter.value(((TextComponent)component).content());
        } else if (component instanceof TranslatableComponent) {
            object2 = (TranslatableComponent)component;
            jsonWriter.name("translate");
            jsonWriter.value(object2.key());
            String string = object2.fallback();
            if (string != null) {
                jsonWriter.name("fallback");
                jsonWriter.value(string);
            }
            if (!object2.arguments().isEmpty()) {
                jsonWriter.name("with");
                this.gson.toJson(object2.arguments(), TRANSLATABLE_ARGUMENT_LIST_TYPE, jsonWriter);
            }
        } else if (component instanceof ScoreComponent) {
            object2 = (ScoreComponent)component;
            jsonWriter.name("score");
            jsonWriter.beginObject();
            jsonWriter.name("name");
            jsonWriter.value(object2.name());
            jsonWriter.name("objective");
            jsonWriter.value(object2.objective());
            if (object2.value() != null) {
                jsonWriter.name("value");
                jsonWriter.value(object2.value());
            }
            jsonWriter.endObject();
        } else if (component instanceof SelectorComponent) {
            object2 = (SelectorComponent)component;
            jsonWriter.name("selector");
            jsonWriter.value(object2.pattern());
            this.serializeSeparator(jsonWriter, object2.separator());
        } else if (component instanceof KeybindComponent) {
            jsonWriter.name("keybind");
            jsonWriter.value(((KeybindComponent)component).keybind());
        } else {
            if (!(component instanceof NBTComponent)) throw ComponentSerializerImpl.notSureHowToSerialize(component);
            object2 = (NBTComponent)component;
            jsonWriter.name("nbt");
            jsonWriter.value(object2.nbtPath());
            jsonWriter.name("interpret");
            jsonWriter.value(object2.interpret());
            this.serializeSeparator(jsonWriter, object2.separator());
            if (component instanceof BlockNBTComponent) {
                jsonWriter.name("block");
                this.gson.toJson((Object)((BlockNBTComponent)component).pos(), SerializerFactory.BLOCK_NBT_POS_TYPE, jsonWriter);
            } else if (component instanceof EntityNBTComponent) {
                jsonWriter.name("entity");
                jsonWriter.value(((EntityNBTComponent)component).selector());
            } else {
                if (!(component instanceof StorageNBTComponent)) throw ComponentSerializerImpl.notSureHowToSerialize(component);
                jsonWriter.name("storage");
                this.gson.toJson((Object)((StorageNBTComponent)component).storage(), SerializerFactory.KEY_TYPE, jsonWriter);
            }
        }
        jsonWriter.endObject();
    }

    private void serializeSeparator(JsonWriter jsonWriter, @Nullable Component component) {
        if (component != null) {
            jsonWriter.name("separator");
            this.write(jsonWriter, component);
        }
    }

    static JsonParseException notSureHowToDeserialize(Object object) {
        return new JsonParseException("Don't know how to turn " + object + " into a Component");
    }

    private static IllegalArgumentException notSureHowToSerialize(Component component) {
        return new IllegalArgumentException("Don't know how to serialize " + component + " as a Component");
    }
}

