/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clans.libs.adventure.adventure.text.renderer;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import me.loving11ish.clans.libs.adventure.adventure.text.BlockNBTComponent;
import me.loving11ish.clans.libs.adventure.adventure.text.BuildableComponent;
import me.loving11ish.clans.libs.adventure.adventure.text.Component;
import me.loving11ish.clans.libs.adventure.adventure.text.ComponentBuilder;
import me.loving11ish.clans.libs.adventure.adventure.text.EntityNBTComponent;
import me.loving11ish.clans.libs.adventure.adventure.text.KeybindComponent;
import me.loving11ish.clans.libs.adventure.adventure.text.NBTComponent;
import me.loving11ish.clans.libs.adventure.adventure.text.NBTComponentBuilder;
import me.loving11ish.clans.libs.adventure.adventure.text.ScoreComponent;
import me.loving11ish.clans.libs.adventure.adventure.text.SelectorComponent;
import me.loving11ish.clans.libs.adventure.adventure.text.StorageNBTComponent;
import me.loving11ish.clans.libs.adventure.adventure.text.TextComponent;
import me.loving11ish.clans.libs.adventure.adventure.text.TranslatableComponent;
import me.loving11ish.clans.libs.adventure.adventure.text.TranslationArgument;
import me.loving11ish.clans.libs.adventure.adventure.text.VirtualComponent;
import me.loving11ish.clans.libs.adventure.adventure.text.event.HoverEvent;
import me.loving11ish.clans.libs.adventure.adventure.text.event.HoverEventSource;
import me.loving11ish.clans.libs.adventure.adventure.text.format.Style;
import me.loving11ish.clans.libs.adventure.adventure.text.renderer.AbstractComponentRenderer;
import me.loving11ish.clans.libs.adventure.adventure.translation.Translator;
import me.loving11ish.clans.libs.adventure.adventure.util.TriState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TranslatableComponentRenderer<C>
extends AbstractComponentRenderer<C> {
    private static final Set<Style.Merge> MERGES;

    @NotNull
    public static TranslatableComponentRenderer<Locale> usingTranslationSource(final @NotNull Translator translator) {
        Objects.requireNonNull(translator, "source");
        return new TranslatableComponentRenderer<Locale>(){

            @Override
            @Nullable
            protected MessageFormat translate(@NotNull String string, @NotNull Locale locale) {
                return translator.translate(string, locale);
            }

            @Override
            @NotNull
            protected Component renderTranslatableInner(@NotNull TranslatableComponent translatableComponent, @NotNull Locale locale) {
                Object object = translator.hasAnyTranslations();
                if (object == TriState.FALSE) {
                    return translatableComponent;
                }
                object = translator.canTranslate(translatableComponent.key(), locale) ? translator.translate(translatableComponent, locale) : null;
                if (object != null) {
                    return this.render((Component)object, locale);
                }
                return super.renderTranslatableInner(translatableComponent, locale);
            }
        };
    }

    @Nullable
    protected MessageFormat translate(@NotNull String string, @NotNull C c2) {
        return null;
    }

    @Nullable
    protected MessageFormat translate(@NotNull String string, @Nullable String string2, @NotNull C c2) {
        return this.translate(string, c2);
    }

    @Override
    @NotNull
    protected Component renderBlockNbt(@NotNull BlockNBTComponent blockNBTComponent, @NotNull C c2) {
        BlockNBTComponent.Builder builder = this.nbt(c2, Component.blockNBT(), blockNBTComponent).pos(blockNBTComponent.pos());
        return this.mergeStyleAndOptionallyDeepRender(blockNBTComponent, builder, c2);
    }

    @Override
    @NotNull
    protected Component renderEntityNbt(@NotNull EntityNBTComponent entityNBTComponent, @NotNull C c2) {
        EntityNBTComponent.Builder builder = this.nbt(c2, Component.entityNBT(), entityNBTComponent).selector(entityNBTComponent.selector());
        return this.mergeStyleAndOptionallyDeepRender(entityNBTComponent, builder, c2);
    }

    @Override
    @NotNull
    protected Component renderStorageNbt(@NotNull StorageNBTComponent storageNBTComponent, @NotNull C c2) {
        StorageNBTComponent.Builder builder = this.nbt(c2, Component.storageNBT(), storageNBTComponent).storage(storageNBTComponent.storage());
        return this.mergeStyleAndOptionallyDeepRender(storageNBTComponent, builder, c2);
    }

    protected <O extends NBTComponent<O, B>, B extends NBTComponentBuilder<O, B>> B nbt(@NotNull C c2, B b2, O object) {
        b2.nbtPath(object.nbtPath()).interpret(object.interpret());
        object = object.separator();
        if (object != null) {
            b2.separator(this.render((Component)object, c2));
        }
        return b2;
    }

    @Override
    @NotNull
    protected Component renderKeybind(@NotNull KeybindComponent keybindComponent, @NotNull C c2) {
        KeybindComponent.Builder builder = Component.keybind().keybind(keybindComponent.keybind());
        return this.mergeStyleAndOptionallyDeepRender(keybindComponent, builder, c2);
    }

    @Override
    @NotNull
    protected Component renderScore(@NotNull ScoreComponent scoreComponent, @NotNull C c2) {
        ScoreComponent.Builder builder = Component.score().name(scoreComponent.name()).objective(scoreComponent.objective()).value(scoreComponent.value());
        return this.mergeStyleAndOptionallyDeepRender(scoreComponent, builder, c2);
    }

    @Override
    @NotNull
    protected Component renderSelector(@NotNull SelectorComponent selectorComponent, @NotNull C c2) {
        SelectorComponent.Builder builder = Component.selector().pattern(selectorComponent.pattern());
        return this.mergeStyleAndOptionallyDeepRender(selectorComponent, builder, c2);
    }

    @Override
    @NotNull
    protected Component renderText(@NotNull TextComponent textComponent, @NotNull C c2) {
        TextComponent.Builder builder = Component.text().content(textComponent.content());
        return this.mergeStyleAndOptionallyDeepRender(textComponent, builder, c2);
    }

    @Override
    @NotNull
    protected Component renderTranslatable(@NotNull TranslatableComponent styleSetter, @NotNull C c2) {
        List<TranslationArgument> list = styleSetter.arguments();
        List<Component> list2 = styleSetter.children();
        if (!list.isEmpty() || !list2.isEmpty()) {
            styleSetter = (TranslatableComponent.Builder)styleSetter.toBuilder();
            if (!list.isEmpty()) {
                list = new ArrayList<TranslationArgument>(list);
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    TranslationArgument translationArgument = list.get(i2);
                    if (!(translationArgument.value() instanceof Component) || translationArgument.value() instanceof VirtualComponent) continue;
                    list.set(i2, TranslationArgument.component(this.render((Component)translationArgument.value(), c2)));
                }
                styleSetter.arguments(list);
            }
            styleSetter = (TranslatableComponent)styleSetter.build();
        }
        return this.renderTranslatableInner((TranslatableComponent)styleSetter, c2);
    }

    @NotNull
    protected Component renderTranslatableInner(@NotNull TranslatableComponent translatableComponent, @NotNull C c2) {
        @Nullable Cloneable cloneable = this.translate(translatableComponent.key(), translatableComponent.fallback(), c2);
        if (cloneable == null) {
            return this.optionallyRenderChildrenAndStyle(translatableComponent, c2);
        }
        List<TranslationArgument> list = translatableComponent.arguments();
        TextComponent.Builder builder = Component.text();
        this.mergeStyle(translatableComponent, builder, c2);
        if (list.isEmpty()) {
            builder.content(((MessageFormat)cloneable).format(null, new StringBuffer(), null).toString());
            return this.optionallyRenderChildrenAppendAndBuild(translatableComponent.children(), builder, c2);
        }
        Object[] objectArray = new Object[list.size()];
        StringBuffer stringBuffer = ((MessageFormat)cloneable).format(objectArray, new StringBuffer(), (FieldPosition)null);
        cloneable = ((MessageFormat)cloneable).formatToCharacterIterator(objectArray);
        while (cloneable.getIndex() < cloneable.getEndIndex()) {
            int n2 = cloneable.getRunLimit();
            Object object = (Integer)cloneable.getAttribute(MessageFormat.Field.ARGUMENT);
            if (object != null) {
                object = list.get((Integer)object);
                builder.append(object.asComponent());
            } else {
                builder.append((Component)Component.text(stringBuffer.substring(cloneable.getIndex(), n2)));
            }
            cloneable.setIndex(n2);
        }
        return this.optionallyRenderChildrenAppendAndBuild(translatableComponent.children(), builder, c2);
    }

    protected Component optionallyRenderChildrenAndStyle(Component styleSetter, C c2) {
        @Nullable HoverEvent<?> hoverEvent = styleSetter.hoverEvent();
        if (hoverEvent != null) {
            styleSetter = styleSetter.hoverEvent(hoverEvent.withRenderedValue(this, c2));
        }
        if ((hoverEvent = styleSetter.children()).isEmpty()) {
            return styleSetter;
        }
        ArrayList arrayList = new ArrayList(hoverEvent.size());
        hoverEvent.forEach(component -> arrayList.add(this.render((Component)component, c2)));
        return styleSetter.children(arrayList);
    }

    protected <O extends BuildableComponent<O, B>, B extends ComponentBuilder<O, B>> O mergeStyleAndOptionallyDeepRender(Component component, B b2, C c2) {
        this.mergeStyle(component, b2, c2);
        return this.optionallyRenderChildrenAppendAndBuild(component.children(), b2, c2);
    }

    protected <O extends BuildableComponent<O, B>, B extends ComponentBuilder<O, B>> O optionallyRenderChildrenAppendAndBuild(List<Component> list, B b2, C c2) {
        if (!list.isEmpty()) {
            list.forEach(component -> b2.append(this.render((Component)component, c2)));
        }
        return (O)b2.build();
    }

    protected <B extends ComponentBuilder<?, ?>> void mergeStyle(Component componentBuilderApplicable, B b2, C c2) {
        b2.mergeStyle((Component)componentBuilderApplicable, MERGES);
        b2.clickEvent(componentBuilderApplicable.clickEvent());
        componentBuilderApplicable = componentBuilderApplicable.hoverEvent();
        if (componentBuilderApplicable != null) {
            b2.hoverEvent((HoverEventSource)((HoverEvent)componentBuilderApplicable).withRenderedValue(this, c2));
        }
    }

    static {
        EnumSet<Style.Merge> enumSet = EnumSet.allOf(Style.Merge.class);
        enumSet.remove((Object)Style.Merge.EVENTS);
        MERGES = Collections.unmodifiableSet(enumSet);
    }
}

