/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clans.libs.adventure.adventure.text.minimessage.internal.parser.node;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.internal.parser.ParsingExceptionImpl;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.internal.parser.Token;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.internal.parser.TokenParser;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.internal.parser.node.ElementNode;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.internal.parser.node.TagPart;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.tag.Tag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TagNode
extends ElementNode {
    private final List<TagPart> parts;
    @Nullable
    private Tag tag = null;

    public TagNode(@NotNull ElementNode elementNode, @NotNull Token token, @NotNull String string, @NotNull TokenParser.TagProvider tagProvider) {
        super(elementNode, token, string);
        this.parts = TagNode.genParts(token, string, tagProvider);
        if (this.parts.isEmpty()) {
            throw new ParsingExceptionImpl("Tag has no parts? " + this, this.sourceMessage(), this.token());
        }
    }

    @NotNull
    private static List<TagPart> genParts(@NotNull Token object, @NotNull String string, @NotNull TokenParser.TagProvider tagProvider) {
        ArrayList<TagPart> arrayList = new ArrayList<TagPart>();
        if (((Token)object).childTokens() != null) {
            for (Token token : ((Token)object).childTokens()) {
                arrayList.add(new TagPart(string, token, tagProvider));
            }
        }
        return arrayList;
    }

    @NotNull
    public final List<TagPart> parts() {
        return this.parts;
    }

    @NotNull
    public final String name() {
        return this.parts.get(0).value();
    }

    @Override
    @NotNull
    public final Token token() {
        return Objects.requireNonNull(super.token(), "token is not set");
    }

    @NotNull
    public final Tag tag() {
        return Objects.requireNonNull(this.tag, "no tag set");
    }

    public final void tag(@NotNull Tag tag) {
        this.tag = tag;
    }

    @Override
    @NotNull
    public final StringBuilder buildToString(@NotNull StringBuilder stringBuilder, int n2) {
        char[] cArray = this.ident(n2);
        stringBuilder.append(cArray).append("TagNode(");
        int n3 = this.parts.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            TagPart object = this.parts.get(i2);
            stringBuilder.append('\'').append(object.value()).append('\'');
            if (i2 == n3 - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(") {\n");
        for (ElementNode elementNode : this.children()) {
            elementNode.buildToString(stringBuilder, n2 + 1);
        }
        stringBuilder.append(cArray).append("}\n");
        return stringBuilder;
    }
}

