/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clans.libs.adventure.adventure.text.minimessage.internal.parser.node;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.internal.parser.Token;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.internal.parser.TokenType;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.internal.parser.node.TextNode;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.tree.Node;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementNode
implements Node {
    @Nullable
    private final ElementNode parent;
    @Nullable
    private final Token token;
    private final String sourceMessage;
    private final List<ElementNode> children = new ArrayList<ElementNode>();

    ElementNode(@Nullable ElementNode elementNode, @Nullable Token token, @NotNull String string) {
        this.parent = elementNode;
        this.token = token;
        this.sourceMessage = string;
    }

    @Override
    @Nullable
    public ElementNode parent() {
        return this.parent;
    }

    @Nullable
    public Token token() {
        return this.token;
    }

    @NotNull
    public String sourceMessage() {
        return this.sourceMessage;
    }

    @NotNull
    public List<ElementNode> children() {
        return Collections.unmodifiableList(this.children);
    }

    @NotNull
    public List<ElementNode> unsafeChildren() {
        return this.children;
    }

    public void addChild(@NotNull ElementNode object) {
        int n2 = this.children.size() - 1;
        if (!(object instanceof TextNode) || this.children.isEmpty() || !(this.children.get(n2) instanceof TextNode)) {
            this.children.add((ElementNode)object);
            return;
        }
        TextNode textNode = (TextNode)this.children.remove(n2);
        if (textNode.token().endIndex() == ((ElementNode)object).token().startIndex()) {
            object = new Token(textNode.token().startIndex(), ((ElementNode)object).token().endIndex(), TokenType.TEXT);
            this.children.add(new TextNode(this, (Token)object, textNode.sourceMessage()));
            return;
        }
        this.children.add(textNode);
        this.children.add((ElementNode)object);
    }

    @NotNull
    public StringBuilder buildToString(@NotNull StringBuilder stringBuilder, int n2) {
        char[] cArray = this.ident(n2);
        stringBuilder.append(cArray).append("Node {\n");
        for (ElementNode elementNode : this.children) {
            elementNode.buildToString(stringBuilder, n2 + 1);
        }
        stringBuilder.append(cArray).append("}\n");
        return stringBuilder;
    }

    char @NotNull [] ident(int n2) {
        char[] cArray = new char[n2 << 1];
        Arrays.fill(cArray, ' ');
        return cArray;
    }

    @Override
    @NotNull
    public String toString() {
        return this.buildToString(new StringBuilder(), 0).toString();
    }
}

