/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clans.libs.adventure.adventure.text.minimessage.internal.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.internal.TagInternals;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.internal.parser.ParsingExceptionImpl;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.internal.parser.Token;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.internal.parser.TokenType;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.internal.parser.match.MatchedTokenConsumer;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.internal.parser.match.StringResolvingMatchedTokenConsumer;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.internal.parser.match.TokenListProducingMatchedTokenConsumer;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.internal.parser.node.ElementNode;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.internal.parser.node.RootNode;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.internal.parser.node.TagNode;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.internal.parser.node.TagPart;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.internal.parser.node.TextNode;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.tag.Inserting;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.tag.ParserDirective;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.tag.Tag;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class TokenParser {
    private static final int MAX_DEPTH = 16;
    public static final char TAG_START = '<';
    public static final char TAG_END = '>';
    public static final char CLOSE_TAG = '/';
    public static final char SEPARATOR = ':';
    public static final char ESCAPE = '\\';

    private TokenParser() {
    }

    public static RootNode parse(@NotNull TagProvider tagProvider, @NotNull Predicate<String> predicate, @NotNull String string, @NotNull String string2, boolean bl) {
        List<Token> list = TokenParser.tokenize(string, false);
        return TokenParser.buildTree(tagProvider, predicate, list, string, string2, bl);
    }

    public static String resolvePreProcessTags(String string, TagProvider tagProvider) {
        int n2 = 0;
        Object object = string;
        do {
            string = object;
            object = new StringResolvingMatchedTokenConsumer(string, tagProvider);
            TokenParser.parseString(string, false, object);
            object = ((StringResolvingMatchedTokenConsumer)object).result();
        } while (++n2 < 16 && !string.equals(object));
        return string;
    }

    public static List<Token> tokenize(String string, boolean bl) {
        TokenListProducingMatchedTokenConsumer tokenListProducingMatchedTokenConsumer = new TokenListProducingMatchedTokenConsumer(string);
        TokenParser.parseString(string, bl, tokenListProducingMatchedTokenConsumer);
        Object object = tokenListProducingMatchedTokenConsumer.result();
        TokenParser.parseSecondPass(string, (List<Token>)object);
        return object;
    }

    public static void parseString(String string, boolean bl, MatchedTokenConsumer<?> matchedTokenConsumer) {
        int n2;
        FirstPassState firstPassState = FirstPassState.NORMAL;
        boolean bl2 = false;
        int n3 = 0;
        int n4 = -1;
        int n5 = 0;
        int n6 = string.length();
        for (n2 = 0; n2 < n6; ++n2) {
            int n7;
            int n8 = string.codePointAt(n2);
            if (!bl && n8 == 167 && n2 + 1 < n6 && ((n7 = Character.toLowerCase(string.codePointAt(n2 + 1))) >= 48 && n7 <= 57 || n7 >= 97 && n7 <= 102 || n7 == 114 || n7 >= 107 && n7 <= 111)) {
                Token[] tokenArray = new Token[1];
                int n9 = n2;
                tokenArray[0] = new Token(n9, n9 + 2, TokenType.TEXT);
                throw new ParsingExceptionImpl("Legacy formatting codes have been detected in a MiniMessage string - this is unsupported behaviour. Please refer to the Adventure documentation (https://docs.advntr.dev) for more information.", string, null, true, tokenArray);
            }
            if (!Character.isBmpCodePoint(n8)) {
                ++n2;
            }
            if (!bl2) {
                if (n8 == 92 && n2 + 1 < string.length()) {
                    n7 = string.codePointAt(n2 + 1);
                    switch (firstPassState) {
                        case NORMAL: {
                            bl2 = n7 == 60 || n7 == 92;
                            break;
                        }
                        case STRING: {
                            bl2 = n5 == n7 || n7 == 92;
                            break;
                        }
                        case TAG: {
                            if (n7 != 60) break;
                            bl2 = true;
                            firstPassState = FirstPassState.NORMAL;
                        }
                    }
                    if (bl2) continue;
                }
            } else {
                bl2 = false;
                continue;
            }
            switch (firstPassState) {
                case NORMAL: {
                    if (n8 != 60) break;
                    n4 = n2;
                    firstPassState = FirstPassState.TAG;
                    break;
                }
                case TAG: {
                    switch (n8) {
                        case 62: {
                            if (n2 == n4 + 1) {
                                firstPassState = FirstPassState.NORMAL;
                                break;
                            }
                            if (n3 != n4) {
                                matchedTokenConsumer.accept(n3, n4, TokenType.TEXT);
                            }
                            n3 = n2 + 1;
                            TokenType tokenType = TokenType.OPEN_TAG;
                            if (TokenParser.boundsCheck(string, n4, 1) && string.charAt(n4 + 1) == '/') {
                                tokenType = TokenType.CLOSE_TAG;
                            } else if (TokenParser.boundsCheck(string, n4, 2) && string.charAt(n2 - 1) == '/') {
                                tokenType = TokenType.OPEN_CLOSE_TAG;
                            }
                            matchedTokenConsumer.accept(n4, n3, tokenType);
                            firstPassState = FirstPassState.NORMAL;
                            break;
                        }
                        case 60: {
                            n4 = n2;
                            break;
                        }
                        case 34: 
                        case 39: {
                            n5 = (char)n8;
                            if (string.indexOf(n8, n2 + 1) == -1) break;
                            firstPassState = FirstPassState.STRING;
                        }
                    }
                    break;
                }
                case STRING: {
                    if (n8 != n5) break;
                    firstPassState = FirstPassState.TAG;
                }
            }
            if (n2 != n6 - 1 || firstPassState != FirstPassState.TAG) continue;
            n2 = n4;
            firstPassState = FirstPassState.NORMAL;
        }
        n2 = matchedTokenConsumer.lastEndIndex();
        if (n2 == -1) {
            matchedTokenConsumer.accept(0, string.length(), TokenType.TEXT);
            return;
        }
        if (n2 != string.length()) {
            matchedTokenConsumer.accept(n2, string.length(), TokenType.TEXT);
        }
    }

    private static void parseSecondPass(String string, List<Token> object) {
        object = object.iterator();
        while (object.hasNext()) {
            int n2;
            Token token = (Token)object.next();
            TokenType tokenType = token.type();
            if (tokenType != TokenType.OPEN_TAG && tokenType != TokenType.OPEN_CLOSE_TAG && tokenType != TokenType.CLOSE_TAG) continue;
            int n3 = tokenType == TokenType.CLOSE_TAG ? token.startIndex() + 2 : token.startIndex() + 1;
            int n4 = tokenType == TokenType.OPEN_CLOSE_TAG ? token.endIndex() - 2 : token.endIndex() - 1;
            SecondPassState secondPassState = SecondPassState.NORMAL;
            boolean bl = false;
            int n5 = 0;
            int n6 = n3;
            block9: for (n2 = n3; n2 < n4; ++n2) {
                int n7 = string.codePointAt(n2);
                if (!Character.isBmpCodePoint(n2)) {
                    ++n2;
                }
                if (!bl) {
                    if (n7 == 92 && n2 + 1 < string.length()) {
                        int n8 = string.codePointAt(n2 + 1);
                        switch (secondPassState) {
                            case NORMAL: {
                                bl = n8 == 60 || n8 == 92;
                                break;
                            }
                            case STRING: {
                                boolean bl2 = bl = n5 == n8 || n8 == 92;
                            }
                        }
                        if (bl) continue;
                    }
                } else {
                    bl = false;
                    continue;
                }
                switch (secondPassState) {
                    case NORMAL: {
                        if (n7 == 58) {
                            if (TokenParser.boundsCheck(string, n2, 2) && string.charAt(n2 + 1) == '/' && string.charAt(n2 + 2) == '/') continue block9;
                            if (n6 == n2) {
                                int n9 = n2;
                                TokenParser.insert(token, new Token(n9, n9, TokenType.TAG_VALUE));
                                ++n6;
                                continue block9;
                            }
                            TokenParser.insert(token, new Token(n6, n2, TokenType.TAG_VALUE));
                            n6 = n2 + 1;
                            continue block9;
                        }
                        if (n7 != 39 && n7 != 34) continue block9;
                        secondPassState = SecondPassState.STRING;
                        n5 = (char)n7;
                        continue block9;
                    }
                    case STRING: {
                        if (n7 != n5) continue block9;
                        secondPassState = SecondPassState.NORMAL;
                    }
                }
            }
            if (token.childTokens() == null || token.childTokens().isEmpty()) {
                TokenParser.insert(token, new Token(n3, n4, TokenType.TAG_VALUE));
                continue;
            }
            n2 = token.childTokens().get(token.childTokens().size() - 1).endIndex();
            if (n2 == n4) continue;
            TokenParser.insert(token, new Token(n2 + 1, n4, TokenType.TAG_VALUE));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static RootNode buildTree(@NotNull TagProvider tagProvider, @NotNull Predicate<String> predicate, @NotNull List<Token> arrayList, @NotNull String string, @NotNull String object, boolean bl) {
        TagNode tagNode;
        Object object2;
        Object object4 = object = new RootNode(string, (String)object);
        for (Token tokenArray : arrayList) {
            object2 = tokenArray.type();
            switch (1.$SwitchMap$net$kyori$adventure$text$minimessage$internal$parser$TokenType[((Enum)object2).ordinal()]) {
                case 1: {
                    ((ElementNode)object4).addChild(new TextNode((ElementNode)object4, tokenArray, string));
                    break;
                }
                case 2: 
                case 3: {
                    List<TagPart> list = tokenArray.childTokens().get(0);
                    String string2 = string.substring(((Token)((Object)list)).startIndex(), ((Token)((Object)list)).endIndex());
                    if (!TagInternals.sanitizeAndCheckValidTagName(string2)) {
                        ((ElementNode)object4).addChild(new TextNode((ElementNode)object4, tokenArray, string));
                        break;
                    }
                    tagNode = new TagNode((ElementNode)object4, tokenArray, string, tagProvider);
                    if (predicate.test(tagNode.name())) {
                        list = tagProvider.resolve(tagNode);
                        if (list == null) {
                            ((ElementNode)object4).addChild(new TextNode((ElementNode)object4, tokenArray, string));
                            break;
                        }
                        if (list == ParserDirective.RESET) {
                            if (bl) {
                                throw new ParsingExceptionImpl("<reset> tags are not allowed when strict mode is enabled", string, tokenArray);
                            }
                            object4 = object;
                            break;
                        }
                        tagNode.tag((Tag)((Object)list));
                        ((ElementNode)object4).addChild(tagNode);
                        if (object2 == TokenType.OPEN_CLOSE_TAG || list instanceof Inserting && !((Inserting)((Object)list)).allowsChildren()) break;
                        object4 = tagNode;
                        break;
                    }
                    ((ElementNode)object4).addChild(new TextNode((ElementNode)object4, tokenArray, string));
                    break;
                }
                case 4: {
                    void var10_20;
                    List<TagPart> list = tokenArray.childTokens();
                    if (list.isEmpty()) {
                        throw new IllegalStateException("CLOSE_TAG token somehow has no children - the parser should not allow this. Original text: " + string);
                    }
                    object2 = new ArrayList(list.size());
                    for (Token token : list) {
                        ((ArrayList)object2).add(TagPart.unquoteAndEscape(string, token.startIndex(), token.endIndex()));
                    }
                    list = (String)((ArrayList)object2).get(0);
                    if (predicate.test((String)((Object)list))) {
                        Tag tag = tagProvider.resolve((String)((Object)list));
                        if (tag == ParserDirective.RESET) break;
                    } else {
                        ((ElementNode)object4).addChild(new TextNode((ElementNode)object4, tokenArray, string));
                        break;
                    }
                    RootNode rootNode = object4;
                    while (var10_20 instanceof TagNode) {
                        list = ((TagNode)var10_20).parts();
                        if (TokenParser.tagCloses((List<String>)object2, list)) {
                            if (var10_20 != object4 && bl) {
                                object2 = "Unclosed tag encountered; " + ((TagNode)object4).name() + " is not closed, because " + (String)((ArrayList)object2).get(0) + " was closed first.";
                                throw new ParsingExceptionImpl((String)object2, string, var10_20.token(), ((ElementNode)object4).token(), tokenArray);
                            }
                            object2 = var10_20.parent();
                            if (object2 != null) {
                                object4 = object2;
                                break;
                            }
                            throw new IllegalStateException("Root node matched with close tag value, this should not be possible. Original text: " + string);
                        }
                        ElementNode elementNode = var10_20.parent();
                    }
                    if (var10_20 != null && !(var10_20 instanceof RootNode)) break;
                    ((ElementNode)object4).addChild(new TextNode((ElementNode)object4, tokenArray, string));
                }
            }
        }
        if (bl && object != object4) {
            void var7_9;
            arrayList = new ArrayList<TagNode>();
            RootNode rootNode = object4;
            while (var7_9 != null && var7_9 instanceof TagNode) {
                arrayList.add((TagNode)var7_9);
                ElementNode elementNode = var7_9.parent();
            }
            Token[] tokenArray = new Token[arrayList.size()];
            object2 = new StringBuilder("All tags must be explicitly closed while in strict mode. End of string found with open tags: ");
            int n2 = 0;
            ArrayList<TagNode> arrayList2 = arrayList;
            ListIterator listIterator = arrayList2.listIterator(arrayList2.size());
            while (listIterator.hasPrevious()) {
                tagNode = (TagNode)listIterator.previous();
                tokenArray[n2++] = tagNode.token();
                ((StringBuilder)object2).append(tagNode.name());
                if (!listIterator.hasPrevious()) continue;
                ((StringBuilder)object2).append(", ");
            }
            throw new ParsingExceptionImpl(((StringBuilder)object2).toString(), string, tokenArray);
        }
        return object;
    }

    private static boolean tagCloses(List<String> list, List<TagPart> list2) {
        if (list.size() > list2.size()) {
            return false;
        }
        if (!list.get(0).equalsIgnoreCase(list2.get(0).value())) {
            return false;
        }
        for (int i2 = 1; i2 < list.size(); ++i2) {
            if (list.get(i2).equals(list2.get(i2).value())) continue;
            return false;
        }
        return true;
    }

    private static boolean boundsCheck(String string, int n2, int n3) {
        return n2 + n3 < string.length();
    }

    private static void insert(Token token, Token token2) {
        if (token.childTokens() == null) {
            token.childTokens(Collections.singletonList(token2));
            return;
        }
        if (token.childTokens().size() == 1) {
            ArrayList<Token> arrayList = new ArrayList<Token>(3);
            arrayList.add(token.childTokens().get(0));
            arrayList.add(token2);
            token.childTokens(arrayList);
            return;
        }
        token.childTokens().add(token2);
    }

    public static String unescape(String string, int n2, int n3, IntPredicate intPredicate) {
        int n4 = n2;
        int n5 = string.indexOf(92, n2);
        if (n5 == -1 || n5 >= n3) {
            return string.substring(n2, n3);
        }
        StringBuilder stringBuilder = new StringBuilder(n3 - n2);
        while (n5 != -1 && n5 + 1 < n3) {
            if (intPredicate.test(string.codePointAt(n5 + 1))) {
                stringBuilder.append(string, n4, n5);
                if (++n5 >= n3) {
                    n4 = n3;
                    break;
                }
                n4 = string.codePointAt(n5);
                stringBuilder.appendCodePoint(n4);
                n5 = Character.isBmpCodePoint(n4) ? ++n5 : (n5 += 2);
                if (n5 >= n3) {
                    n4 = n3;
                    break;
                }
            } else {
                stringBuilder.append(string, n4, ++n5);
            }
            n4 = n5;
            n5 = string.indexOf(92, n4);
        }
        stringBuilder.append(string, n4, n3);
        return stringBuilder.toString();
    }

    @ApiStatus.Internal
    public static interface TagProvider {
        @Nullable
        public Tag resolve(@NotNull String var1, @NotNull List<? extends Tag.Argument> var2, @Nullable Token var3);

        @Nullable
        default public Tag resolve(@NotNull String string) {
            return this.resolve(string, Collections.emptyList(), null);
        }

        @Nullable
        default public Tag resolve(@NotNull TagNode tagNode) {
            return this.resolve(TagProvider.sanitizePlaceholderName(tagNode.name()), tagNode.parts().subList(1, tagNode.parts().size()), tagNode.token());
        }

        @NotNull
        public static String sanitizePlaceholderName(@NotNull String string) {
            return string.toLowerCase(Locale.ROOT);
        }
    }

    static enum FirstPassState {
        NORMAL,
        TAG,
        STRING;

    }

    static enum SecondPassState {
        NORMAL,
        STRING;

    }
}

