/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clans.libs.adventure.adventure.text.minimessage;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import me.loving11ish.clans.libs.adventure.adventure.text.Component;
import me.loving11ish.clans.libs.adventure.adventure.text.TextComponent;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.internal.serializer.ClaimConsumer;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.internal.serializer.Emitable;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.internal.serializer.QuotingOverride;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.internal.serializer.SerializableResolver;
import me.loving11ish.clans.libs.adventure.adventure.text.minimessage.internal.serializer.TokenEmitter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class MiniMessageSerializer {
    private MiniMessageSerializer() {
    }

    @NotNull
    static String serialize(@NotNull Component component, @NotNull SerializableResolver serializableResolver, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        Collector collector = new Collector(serializableResolver, bl, stringBuilder);
        collector.mark();
        MiniMessageSerializer.visit(component, collector, serializableResolver, true);
        if (bl) {
            collector.popAll();
        } else {
            collector.completeTag();
        }
        return stringBuilder.toString();
    }

    private static void visit(@NotNull Component object, Collector collector, SerializableResolver serializableResolver, boolean bl) {
        serializableResolver.handle((Component)object, collector);
        Component component = collector.flushClaims((Component)object);
        if (component == null) {
            component = object;
        }
        object = component.children().iterator();
        while (object.hasNext()) {
            collector.mark();
            MiniMessageSerializer.visit((Component)object.next(), collector, serializableResolver, bl && !object.hasNext());
        }
        if (!bl) {
            collector.popToMark();
        }
    }

    static final class Collector
    implements ClaimConsumer,
    TokenEmitter {
        private static final String MARK = "__<'\"\\MARK__";
        private static final char[] TEXT_ESCAPES = new char[]{'\\', '<'};
        private static final char[] TAG_TOKENS = new char[]{'>', ':'};
        private static final char[] SINGLE_QUOTED_ESCAPES = new char[]{'\\', '\''};
        private static final char[] DOUBLE_QUOTED_ESCAPES = new char[]{'\\', '\"'};
        private final SerializableResolver resolver;
        private final boolean strict;
        private final StringBuilder consumer;
        private String[] activeTags = new String[4];
        private int tagLevel = 0;
        private TagState tagState = TagState.TEXT;
        @Nullable
        Emitable componentClaim;
        final Set<String> claimedStyleElements = new HashSet<String>();

        Collector(SerializableResolver serializableResolver, boolean bl, StringBuilder stringBuilder) {
            this.resolver = serializableResolver;
            this.strict = bl;
            this.consumer = stringBuilder;
        }

        private void pushActiveTag(String string) {
            if (this.tagLevel >= this.activeTags.length) {
                this.activeTags = Arrays.copyOf(this.activeTags, this.activeTags.length << 1);
            }
            this.activeTags[this.tagLevel++] = string;
        }

        private String popTag(boolean bl) {
            if (this.tagLevel-- <= 0) {
                throw new IllegalStateException("Unbalanced tags, tried to pop below depth");
            }
            String string = this.activeTags[this.tagLevel];
            if (!bl && string == MARK) {
                throw new IllegalStateException("Tried to pop past mark, tag stack: " + Arrays.toString(this.activeTags) + " @ " + this.tagLevel);
            }
            return string;
        }

        final void mark() {
            this.pushActiveTag(MARK);
        }

        final void popToMark() {
            String string;
            if (this.tagLevel == 0) {
                return;
            }
            while ((string = this.popTag(true)) != MARK) {
                this.emitClose(string);
            }
        }

        final void popAll() {
            while (this.tagLevel > 0) {
                String string;
                if ((string = this.activeTags[--this.tagLevel]) == MARK) continue;
                this.emitClose(string);
            }
        }

        final void completeTag() {
            if (this.tagState.isTag) {
                this.consumer.append('>');
                this.tagState = TagState.TEXT;
            }
        }

        @Override
        @NotNull
        public final Collector tag(@NotNull String string) {
            this.completeTag();
            this.consumer.append('<');
            this.escapeTagContent(string, QuotingOverride.UNQUOTED);
            this.tagState = TagState.MID;
            this.pushActiveTag(string);
            return this;
        }

        @Override
        @NotNull
        public final TokenEmitter selfClosingTag(@NotNull String string) {
            this.completeTag();
            this.consumer.append('<');
            this.escapeTagContent(string, QuotingOverride.UNQUOTED);
            this.tagState = TagState.MID_SELF_CLOSING;
            return this;
        }

        @Override
        @NotNull
        public final TokenEmitter argument(@NotNull String string) {
            if (!this.tagState.isTag) {
                throw new IllegalStateException("Not within a tag!");
            }
            this.consumer.append(':');
            this.escapeTagContent(string, null);
            return this;
        }

        @Override
        @NotNull
        public final TokenEmitter argument(@NotNull String string, @NotNull QuotingOverride quotingOverride) {
            if (!this.tagState.isTag) {
                throw new IllegalStateException("Not within a tag!");
            }
            this.consumer.append(':');
            this.escapeTagContent(string, Objects.requireNonNull(quotingOverride, "quotingPreference"));
            return this;
        }

        @Override
        @NotNull
        public final TokenEmitter argument(@NotNull Component object) {
            object = MiniMessageSerializer.serialize((Component)object, this.resolver, this.strict);
            return this.argument((String)object, QuotingOverride.QUOTED);
        }

        @Override
        @NotNull
        public final Collector text(@NotNull String string) {
            this.completeTag();
            Collector.appendEscaping(this.consumer, string, TEXT_ESCAPES, true);
            return this;
        }

        private void escapeTagContent(String string, @Nullable QuotingOverride quotingOverride) {
            boolean bl = quotingOverride == QuotingOverride.QUOTED;
            boolean bl2 = false;
            boolean bl3 = false;
            for (int i2 = 0; i2 < string.length(); ++i2) {
                char c2 = string.charAt(i2);
                if (c2 == '>' || c2 == ':' || c2 == ' ') {
                    bl = true;
                    continue;
                }
                if (c2 == '\'') {
                    bl2 = true;
                    break;
                }
                if (c2 != '\"') continue;
                bl3 = true;
            }
            if (bl2) {
                this.consumer.append('\"');
                Collector.appendEscaping(this.consumer, string, DOUBLE_QUOTED_ESCAPES, true);
                this.consumer.append('\"');
                return;
            }
            if (bl3 || bl) {
                this.consumer.append('\'');
                Collector.appendEscaping(this.consumer, string, SINGLE_QUOTED_ESCAPES, true);
                this.consumer.append('\'');
                return;
            }
            Collector.appendEscaping(this.consumer, string, TAG_TOKENS, false);
        }

        static void appendEscaping(StringBuilder stringBuilder, String string, char[] cArray, boolean bl) {
            int n2 = 0;
            boolean bl2 = false;
            for (int i2 = 0; i2 < string.length(); ++i2) {
                char c2 = string.charAt(i2);
                boolean bl3 = false;
                char[] cArray2 = cArray;
                int n3 = cArray.length;
                for (int i3 = 0; i3 < n3; ++i3) {
                    char c3 = cArray2[i3];
                    if (c2 != c3) continue;
                    if (!bl) {
                        throw new IllegalArgumentException("Invalid escapable character '" + c2 + "' found at index " + i2 + " in string '" + string + "'");
                    }
                    bl3 = true;
                    break;
                }
                if (bl3) {
                    if (bl2) {
                        stringBuilder.append(string, n2, i2);
                    }
                    n2 = i2 + 1;
                    stringBuilder.append('\\').append(c2);
                    continue;
                }
                bl2 = true;
            }
            if (n2 < string.length() && bl2) {
                stringBuilder.append(string, n2, string.length());
            }
        }

        @Override
        @NotNull
        public final Collector pop() {
            Collector collector = this;
            collector.emitClose(collector.popTag(false));
            return this;
        }

        private void emitClose(@NotNull String string) {
            if (this.tagState.isTag) {
                if (this.tagState == TagState.MID) {
                    this.consumer.append('/');
                }
                this.consumer.append('>');
                this.tagState = TagState.TEXT;
                return;
            }
            this.consumer.append('<').append('/');
            this.escapeTagContent(string, QuotingOverride.UNQUOTED);
            this.consumer.append('>');
        }

        @Override
        public final void style(@NotNull String string, @NotNull Emitable emitable) {
            if (this.claimedStyleElements.add(Objects.requireNonNull(string, "claimKey"))) {
                emitable.emit(this);
            }
        }

        @Override
        public final boolean component(@NotNull Emitable emitable) {
            if (this.componentClaim != null) {
                return false;
            }
            this.componentClaim = Objects.requireNonNull(emitable, "componentClaim");
            return true;
        }

        @Override
        public final boolean componentClaimed() {
            return this.componentClaim != null;
        }

        @Override
        public final boolean styleClaimed(@NotNull String string) {
            return this.claimedStyleElements.contains(string);
        }

        @Nullable
        final Component flushClaims(Component component) {
            Component component2 = null;
            if (this.componentClaim != null) {
                this.componentClaim.emit(this);
                component2 = this.componentClaim.substitute();
                this.componentClaim = null;
            } else if (component instanceof TextComponent) {
                this.text(((TextComponent)component).content());
            } else {
                throw new IllegalStateException("Unclaimed component " + component);
            }
            this.claimedStyleElements.clear();
            return component2;
        }

        static enum TagState {
            TEXT(false),
            MID(true),
            MID_SELF_CLOSING(true);

            final boolean isTag;

            private TagState(boolean bl) {
                this.isTag = bl;
            }
        }
    }
}

