/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clans.libs.adventure.adventure.text.format;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import me.loving11ish.clans.libs.adventure.adventure.builder.AbstractBuilder;
import me.loving11ish.clans.libs.adventure.adventure.key.Key;
import me.loving11ish.clans.libs.adventure.adventure.text.event.ClickEvent;
import me.loving11ish.clans.libs.adventure.adventure.text.event.HoverEvent;
import me.loving11ish.clans.libs.adventure.adventure.text.event.HoverEventSource;
import me.loving11ish.clans.libs.adventure.adventure.text.format.MutableStyleSetter;
import me.loving11ish.clans.libs.adventure.adventure.text.format.StyleBuilderApplicable;
import me.loving11ish.clans.libs.adventure.adventure.text.format.StyleGetter;
import me.loving11ish.clans.libs.adventure.adventure.text.format.StyleImpl;
import me.loving11ish.clans.libs.adventure.adventure.text.format.StyleSetter;
import me.loving11ish.clans.libs.adventure.adventure.text.format.TextColor;
import me.loving11ish.clans.libs.adventure.adventure.text.format.TextDecoration;
import me.loving11ish.clans.libs.adventure.adventure.util.Buildable;
import me.loving11ish.clans.libs.adventure.adventure.util.MonkeyBars;
import me.loving11ish.clans.libs.adventure.examination.Examinable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.NonExtendable
public interface Style
extends StyleGetter,
StyleSetter<Style>,
Buildable<Style, Builder>,
Examinable {
    public static final Key DEFAULT_FONT = Key.key("default");

    @NotNull
    public static Style empty() {
        return StyleImpl.EMPTY;
    }

    @NotNull
    public static Builder style() {
        return new StyleImpl.BuilderImpl();
    }

    @NotNull
    public static Style style(@NotNull Consumer<Builder> consumer) {
        return (Style)AbstractBuilder.configureAndBuild(Style.style(), consumer);
    }

    @NotNull
    public static Style style(@Nullable TextColor textColor) {
        return Style.empty().color(textColor);
    }

    @NotNull
    public static Style style(@NotNull TextDecoration textDecoration) {
        return Style.style().decoration(textDecoration, true).build();
    }

    @NotNull
    public static Style style(@Nullable TextColor textColor, TextDecoration ... textDecorationArray) {
        Builder builder = Style.style();
        builder.color(textColor);
        builder.decorate(textDecorationArray);
        return builder.build();
    }

    @NotNull
    public static Style style(@Nullable TextColor object, Set<TextDecoration> object2) {
        Builder builder = Style.style();
        builder.color((TextColor)object);
        if (!object2.isEmpty()) {
            object = object2.iterator();
            while (object.hasNext()) {
                object2 = (TextDecoration)object.next();
                builder.decoration((TextDecoration)object2, true);
            }
        }
        return builder.build();
    }

    @NotNull
    public static Style style(StyleBuilderApplicable ... styleBuilderApplicableArray) {
        int n2 = styleBuilderApplicableArray.length;
        if (n2 == 0) {
            return Style.empty();
        }
        Builder builder = Style.style();
        for (int i2 = 0; i2 < n2; ++i2) {
            StyleBuilderApplicable styleBuilderApplicable = styleBuilderApplicableArray[i2];
            if (styleBuilderApplicable == null) continue;
            styleBuilderApplicable.styleApply(builder);
        }
        return builder.build();
    }

    @NotNull
    public static Style style(@NotNull Iterable<? extends StyleBuilderApplicable> object) {
        Builder builder = Style.style();
        object = object.iterator();
        while (object.hasNext()) {
            StyleBuilderApplicable styleBuilderApplicable = (StyleBuilderApplicable)object.next();
            styleBuilderApplicable.styleApply(builder);
        }
        return builder.build();
    }

    @NotNull
    default public Style edit(@NotNull Consumer<Builder> consumer) {
        return this.edit(consumer, Merge.Strategy.ALWAYS);
    }

    @NotNull
    default public Style edit(@NotNull Consumer<Builder> consumer, @NotNull Merge.Strategy strategy) {
        return Style.style((Builder builder) -> {
            if (strategy == Merge.Strategy.ALWAYS) {
                builder.merge(this, strategy);
            }
            consumer.accept((Builder)builder);
            if (strategy == Merge.Strategy.IF_ABSENT_ON_TARGET) {
                builder.merge(this, strategy);
            }
        });
    }

    @Override
    @Nullable
    public Key font();

    @Override
    @NotNull
    public Style font(@Nullable Key var1);

    @Override
    @Nullable
    public TextColor color();

    @Override
    @NotNull
    public Style color(@Nullable TextColor var1);

    @Override
    @NotNull
    public Style colorIfAbsent(@Nullable TextColor var1);

    @Override
    default public boolean hasDecoration(@NotNull TextDecoration textDecoration) {
        return StyleGetter.super.hasDecoration(textDecoration);
    }

    @Override
    public @NotNull TextDecoration.State decoration(@NotNull TextDecoration var1);

    @Override
    @NotNull
    default public Style decorate(@NotNull TextDecoration textDecoration) {
        return (Style)StyleSetter.super.decorate(textDecoration);
    }

    @Override
    @NotNull
    default public Style decoration(@NotNull TextDecoration textDecoration, boolean bl) {
        return (Style)StyleSetter.super.decoration(textDecoration, bl);
    }

    @Override
    @NotNull
    public Style decoration(@NotNull TextDecoration var1, @NotNull TextDecoration.State var2);

    @Override
    @NotNull
    public Style decorationIfAbsent(@NotNull TextDecoration var1, @NotNull TextDecoration.State var2);

    @Override
    default public @Unmodifiable @NotNull Map<TextDecoration, TextDecoration.State> decorations() {
        return StyleGetter.super.decorations();
    }

    @Override
    @NotNull
    public Style decorations(@NotNull Map<TextDecoration, TextDecoration.State> var1);

    @Override
    @Nullable
    public ClickEvent clickEvent();

    @Override
    @NotNull
    public Style clickEvent(@Nullable ClickEvent var1);

    @Override
    @Nullable
    public HoverEvent<?> hoverEvent();

    @Override
    @NotNull
    public Style hoverEvent(@Nullable HoverEventSource<?> var1);

    @Override
    @Nullable
    public String insertion();

    @Override
    @NotNull
    public Style insertion(@Nullable String var1);

    @NotNull
    default public Style merge(@NotNull Style style) {
        return this.merge(style, Merge.all());
    }

    @NotNull
    default public Style merge(@NotNull Style style, @NotNull Merge.Strategy strategy) {
        return this.merge(style, strategy, Merge.all());
    }

    @NotNull
    default public Style merge(@NotNull Style style, @NotNull Merge merge) {
        return this.merge(style, Collections.singleton(merge));
    }

    @NotNull
    default public Style merge(@NotNull Style style, @NotNull Merge.Strategy strategy, @NotNull Merge merge) {
        return this.merge(style, strategy, Collections.singleton(merge));
    }

    @NotNull
    default public Style merge(@NotNull Style style, Merge ... mergeArray) {
        return this.merge(style, Merge.merges(mergeArray));
    }

    @NotNull
    default public Style merge(@NotNull Style style, @NotNull Merge.Strategy strategy, Merge ... mergeArray) {
        return this.merge(style, strategy, Merge.merges(mergeArray));
    }

    @NotNull
    default public Style merge(@NotNull Style style, @NotNull Set<Merge> set) {
        return this.merge(style, Merge.Strategy.ALWAYS, set);
    }

    @NotNull
    public Style merge(@NotNull Style var1, @NotNull Merge.Strategy var2, @NotNull Set<Merge> var3);

    @NotNull
    public Style unmerge(@NotNull Style var1);

    public boolean isEmpty();

    @Override
    @NotNull
    public Builder toBuilder();

    public static interface Builder
    extends AbstractBuilder<Style>,
    MutableStyleSetter<Builder>,
    Buildable.Builder<Style> {
        @Override
        @Contract(value="_ -> this")
        @NotNull
        public Builder font(@Nullable Key var1);

        @Override
        @Contract(value="_ -> this")
        @NotNull
        public Builder color(@Nullable TextColor var1);

        @Override
        @Contract(value="_ -> this")
        @NotNull
        public Builder colorIfAbsent(@Nullable TextColor var1);

        @Override
        @Contract(value="_ -> this")
        @NotNull
        default public Builder decorate(@NotNull TextDecoration textDecoration) {
            return (Builder)MutableStyleSetter.super.decorate(textDecoration);
        }

        @Override
        @Contract(value="_ -> this")
        @NotNull
        default public Builder decorate(TextDecoration ... textDecorationArray) {
            return (Builder)MutableStyleSetter.super.decorate(textDecorationArray);
        }

        @Override
        @Contract(value="_, _ -> this")
        @NotNull
        default public Builder decoration(@NotNull TextDecoration textDecoration, boolean bl) {
            return (Builder)MutableStyleSetter.super.decoration(textDecoration, bl);
        }

        @Override
        @Contract(value="_ -> this")
        @NotNull
        default public Builder decorations(@NotNull Map<TextDecoration, TextDecoration.State> map) {
            return (Builder)MutableStyleSetter.super.decorations((Map)map);
        }

        @Override
        @Contract(value="_, _ -> this")
        @NotNull
        public Builder decoration(@NotNull TextDecoration var1, @NotNull TextDecoration.State var2);

        @Override
        @Contract(value="_, _ -> this")
        @NotNull
        public Builder decorationIfAbsent(@NotNull TextDecoration var1, @NotNull TextDecoration.State var2);

        @Override
        @Contract(value="_ -> this")
        @NotNull
        public Builder clickEvent(@Nullable ClickEvent var1);

        @Override
        @Contract(value="_ -> this")
        @NotNull
        public Builder hoverEvent(@Nullable HoverEventSource<?> var1);

        @Override
        @Contract(value="_ -> this")
        @NotNull
        public Builder insertion(@Nullable String var1);

        @Contract(value="_ -> this")
        @NotNull
        default public Builder merge(@NotNull Style style) {
            return this.merge(style, Merge.all());
        }

        @Contract(value="_, _ -> this")
        @NotNull
        default public Builder merge(@NotNull Style style, @NotNull Merge.Strategy strategy) {
            return this.merge(style, strategy, Merge.all());
        }

        @Contract(value="_, _ -> this")
        @NotNull
        default public Builder merge(@NotNull Style style, Merge ... mergeArray) {
            if (mergeArray.length == 0) {
                return this;
            }
            return this.merge(style, Merge.merges(mergeArray));
        }

        @Contract(value="_, _, _ -> this")
        @NotNull
        default public Builder merge(@NotNull Style style, @NotNull Merge.Strategy strategy, Merge ... mergeArray) {
            if (mergeArray.length == 0) {
                return this;
            }
            return this.merge(style, strategy, Merge.merges(mergeArray));
        }

        @Contract(value="_, _ -> this")
        @NotNull
        default public Builder merge(@NotNull Style style, @NotNull Set<Merge> set) {
            return this.merge(style, Merge.Strategy.ALWAYS, set);
        }

        @Contract(value="_, _, _ -> this")
        @NotNull
        public Builder merge(@NotNull Style var1, @NotNull Merge.Strategy var2, @NotNull Set<Merge> var3);

        @Contract(value="_ -> this")
        @NotNull
        default public Builder apply(@NotNull StyleBuilderApplicable styleBuilderApplicable) {
            styleBuilderApplicable.styleApply(this);
            return this;
        }

        @Override
        @NotNull
        public Style build();
    }

    public static enum Merge {
        COLOR,
        SHADOW_COLOR,
        DECORATIONS,
        EVENTS,
        INSERTION,
        FONT;

        static final Set<Merge> ALL;
        static final Set<Merge> COLOR_AND_DECORATIONS;

        public static @Unmodifiable @NotNull Set<Merge> all() {
            return ALL;
        }

        public static @Unmodifiable @NotNull Set<Merge> colorAndDecorations() {
            return COLOR_AND_DECORATIONS;
        }

        public static @Unmodifiable @NotNull Set<Merge> merges(Merge ... mergeArray) {
            return MonkeyBars.enumSet(Merge.class, (Enum[])mergeArray);
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
        public static @Unmodifiable @NotNull Set<Merge> of(Merge ... mergeArray) {
            return MonkeyBars.enumSet(Merge.class, (Enum[])mergeArray);
        }

        static boolean hasAll(@NotNull Set<Merge> set) {
            return set.size() == ALL.size();
        }

        static {
            ALL = Merge.merges(Merge.values());
            COLOR_AND_DECORATIONS = Merge.merges(COLOR, DECORATIONS);
        }

        public static enum Strategy {
            ALWAYS,
            NEVER,
            IF_ABSENT_ON_TARGET;

        }
    }
}

