/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clans.libs.adventure.adventure.text.format;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Stream;
import me.loving11ish.clans.libs.adventure.adventure.text.format.TextDecoration;
import me.loving11ish.clans.libs.adventure.examination.Examinable;
import me.loving11ish.clans.libs.adventure.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

@Unmodifiable
final class DecorationMap
extends AbstractMap<TextDecoration, TextDecoration.State>
implements Examinable {
    static final TextDecoration[] DECORATIONS = TextDecoration.values();
    private static final TextDecoration.State[] STATES = TextDecoration.State.values();
    private static final int MAP_SIZE = DECORATIONS.length;
    private static final TextDecoration.State[] EMPTY_STATE_ARRAY = new TextDecoration.State[0];
    static final DecorationMap EMPTY = new DecorationMap(0);
    private static final KeySet KEY_SET = new KeySet();
    private final int bitSet;
    private volatile EntrySet entrySet = null;
    private volatile Values values = null;

    static DecorationMap fromMap(Map<TextDecoration, TextDecoration.State> map) {
        if (map instanceof DecorationMap) {
            return (DecorationMap)map;
        }
        int n2 = 0;
        TextDecoration[] textDecorationArray = DECORATIONS;
        int n3 = DECORATIONS.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            TextDecoration textDecoration = textDecorationArray[i2];
            n2 |= map.getOrDefault(textDecoration, TextDecoration.State.NOT_SET).ordinal() * DecorationMap.offset(textDecoration);
        }
        return DecorationMap.withBitSet(n2);
    }

    static DecorationMap merge(Map<TextDecoration, TextDecoration.State> map, Map<TextDecoration, TextDecoration.State> map2) {
        int n2 = 0;
        TextDecoration[] textDecorationArray = DECORATIONS;
        int n3 = DECORATIONS.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            TextDecoration textDecoration = textDecorationArray[i2];
            n2 |= map.getOrDefault(textDecoration, map2.getOrDefault(textDecoration, TextDecoration.State.NOT_SET)).ordinal() * DecorationMap.offset(textDecoration);
        }
        return DecorationMap.withBitSet(n2);
    }

    private static DecorationMap withBitSet(int n2) {
        if (n2 == 0) {
            return EMPTY;
        }
        return new DecorationMap(n2);
    }

    private static int offset(TextDecoration textDecoration) {
        return 1 << (textDecoration.ordinal() << 1);
    }

    private DecorationMap(int n2) {
        this.bitSet = n2;
    }

    @NotNull
    public final DecorationMap with(@NotNull TextDecoration textDecoration, @NotNull TextDecoration.State state) {
        Objects.requireNonNull(state, "state");
        Objects.requireNonNull(textDecoration, "decoration");
        int n2 = DecorationMap.offset(textDecoration);
        return DecorationMap.withBitSet(this.bitSet & ~(3 * n2) | state.ordinal() * n2);
    }

    @Override
    @NotNull
    public final Stream<? extends ExaminableProperty> examinableProperties() {
        return Arrays.stream(DECORATIONS).map(textDecoration -> ExaminableProperty.of(textDecoration.toString(), (Object)this.get(textDecoration)));
    }

    @Override
    public final TextDecoration.State get(Object object) {
        if (object instanceof TextDecoration) {
            return STATES[this.bitSet >> (((TextDecoration)object).ordinal() << 1) & 3];
        }
        return null;
    }

    @Override
    public final boolean containsKey(Object object) {
        return object instanceof TextDecoration;
    }

    @Override
    public final int size() {
        return MAP_SIZE;
    }

    @Override
    public final boolean isEmpty() {
        return false;
    }

    @Override
    @NotNull
    public final Set<Map.Entry<TextDecoration, TextDecoration.State>> entrySet() {
        if (this.entrySet == null) {
            DecorationMap decorationMap = this;
            synchronized (decorationMap) {
                if (this.entrySet == null) {
                    this.entrySet = new EntrySet();
                }
            }
        }
        return this.entrySet;
    }

    @Override
    @NotNull
    public final Set<TextDecoration> keySet() {
        return KEY_SET;
    }

    @Override
    @NotNull
    public final Collection<TextDecoration.State> values() {
        if (this.values == null) {
            DecorationMap decorationMap = this;
            synchronized (decorationMap) {
                if (this.values == null) {
                    this.values = new Values();
                }
            }
        }
        return this.values;
    }

    @Override
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != DecorationMap.class) {
            return false;
        }
        return this.bitSet == ((DecorationMap)object).bitSet;
    }

    @Override
    public final int hashCode() {
        return this.bitSet;
    }

    static /* synthetic */ KeySet access$000() {
        return KEY_SET;
    }

    static final class KeySet
    extends AbstractSet<TextDecoration> {
        KeySet() {
        }

        @Override
        public final boolean contains(Object object) {
            return object instanceof TextDecoration;
        }

        @Override
        public final boolean isEmpty() {
            return false;
        }

        @Override
        public final Object @NotNull [] toArray() {
            return Arrays.copyOf(DECORATIONS, MAP_SIZE, Object[].class);
        }

        @Override
        public final <T> T @NotNull [] toArray(T @NotNull [] TArray) {
            if (TArray.length < MAP_SIZE) {
                return Arrays.copyOf(DECORATIONS, MAP_SIZE, TArray.getClass());
            }
            System.arraycopy(DECORATIONS, 0, TArray, 0, MAP_SIZE);
            if (TArray.length > MAP_SIZE) {
                TArray[MAP_SIZE] = null;
            }
            return TArray;
        }

        @Override
        @NotNull
        public final Iterator<TextDecoration> iterator() {
            return Spliterators.iterator(Arrays.spliterator(DECORATIONS));
        }

        @Override
        public final int size() {
            return MAP_SIZE;
        }
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<TextDecoration, TextDecoration.State>> {
        EntrySet() {
        }

        @Override
        @NotNull
        public final Iterator<Map.Entry<TextDecoration, TextDecoration.State>> iterator() {
            return new Iterator<Map.Entry<TextDecoration, TextDecoration.State>>(){
                private final Iterator<TextDecoration> decorations = DecorationMap.access$000().iterator();
                private final Iterator<TextDecoration.State> states;
                {
                    this.states = DecorationMap.this.values().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.decorations.hasNext() && this.states.hasNext();
                }

                @Override
                public Map.Entry<TextDecoration, TextDecoration.State> next() {
                    if (this.hasNext()) {
                        return new AbstractMap.SimpleImmutableEntry<TextDecoration, TextDecoration.State>(this.decorations.next(), this.states.next());
                    }
                    throw new NoSuchElementException();
                }
            };
        }

        @Override
        public final int size() {
            return MAP_SIZE;
        }
    }

    final class Values
    extends AbstractCollection<TextDecoration.State> {
        Values() {
        }

        @Override
        @NotNull
        public final Iterator<TextDecoration.State> iterator() {
            return Spliterators.iterator(Arrays.spliterator(this.toArray(EMPTY_STATE_ARRAY)));
        }

        @Override
        public final boolean isEmpty() {
            return false;
        }

        @Override
        public final Object @NotNull [] toArray() {
            Object[] objectArray = new Object[MAP_SIZE];
            for (int i2 = 0; i2 < MAP_SIZE; ++i2) {
                objectArray[i2] = DecorationMap.this.get(DECORATIONS[i2]);
            }
            return objectArray;
        }

        @Override
        public final <T> T @NotNull [] toArray(T @NotNull [] TArray) {
            if (TArray.length < MAP_SIZE) {
                return Arrays.copyOf(this.toArray(), MAP_SIZE, TArray.getClass());
            }
            System.arraycopy(this.toArray(), 0, TArray, 0, MAP_SIZE);
            if (TArray.length > MAP_SIZE) {
                TArray[MAP_SIZE] = null;
            }
            return TArray;
        }

        @Override
        public final boolean contains(Object object) {
            return object instanceof TextDecoration.State && super.contains(object);
        }

        @Override
        public final int size() {
            return MAP_SIZE;
        }
    }
}

