/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clans.libs.adventure.adventure.text.event;

import java.net.URL;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import me.loving11ish.clans.libs.adventure.adventure.audience.Audience;
import me.loving11ish.clans.libs.adventure.adventure.builder.AbstractBuilder;
import me.loving11ish.clans.libs.adventure.adventure.dialog.DialogLike;
import me.loving11ish.clans.libs.adventure.adventure.internal.Internals;
import me.loving11ish.clans.libs.adventure.adventure.key.Key;
import me.loving11ish.clans.libs.adventure.adventure.key.Keyed;
import me.loving11ish.clans.libs.adventure.adventure.nbt.api.BinaryTagHolder;
import me.loving11ish.clans.libs.adventure.adventure.text.event.ClickCallback;
import me.loving11ish.clans.libs.adventure.adventure.text.event.ClickCallbackInternals;
import me.loving11ish.clans.libs.adventure.adventure.text.event.ClickCallbackOptionsImpl;
import me.loving11ish.clans.libs.adventure.adventure.text.event.PayloadImpl;
import me.loving11ish.clans.libs.adventure.adventure.text.format.StyleBuilderApplicable;
import me.loving11ish.clans.libs.adventure.adventure.util.Index;
import me.loving11ish.clans.libs.adventure.examination.Examinable;
import me.loving11ish.clans.libs.adventure.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClickEvent
implements StyleBuilderApplicable,
Examinable {
    private final Action action;
    private final Payload payload;

    @NotNull
    public static ClickEvent openUrl(@NotNull String string) {
        return new ClickEvent(Action.OPEN_URL, Payload.string(string));
    }

    @NotNull
    public static ClickEvent openUrl(@NotNull URL uRL) {
        return ClickEvent.openUrl(uRL.toExternalForm());
    }

    @NotNull
    public static ClickEvent openFile(@NotNull String string) {
        return new ClickEvent(Action.OPEN_FILE, Payload.string(string));
    }

    @NotNull
    public static ClickEvent runCommand(@NotNull String string) {
        return new ClickEvent(Action.RUN_COMMAND, Payload.string(string));
    }

    @NotNull
    public static ClickEvent suggestCommand(@NotNull String string) {
        return new ClickEvent(Action.SUGGEST_COMMAND, Payload.string(string));
    }

    @Deprecated
    @NotNull
    public static ClickEvent changePage(@NotNull String string) {
        Objects.requireNonNull(string, "page");
        return new ClickEvent(Action.CHANGE_PAGE, Payload.integer(Integer.parseInt(string)));
    }

    @NotNull
    public static ClickEvent changePage(int n2) {
        return new ClickEvent(Action.CHANGE_PAGE, Payload.integer(n2));
    }

    @NotNull
    public static ClickEvent copyToClipboard(@NotNull String string) {
        return new ClickEvent(Action.COPY_TO_CLIPBOARD, Payload.string(string));
    }

    @NotNull
    public static ClickEvent callback(@NotNull ClickCallback<Audience> clickCallback) {
        return ClickCallbackInternals.PROVIDER.create(Objects.requireNonNull(clickCallback, "function"), ClickCallbackOptionsImpl.DEFAULT);
    }

    @NotNull
    public static ClickEvent callback(@NotNull ClickCallback<Audience> clickCallback, @NotNull ClickCallback.Options options) {
        return ClickCallbackInternals.PROVIDER.create(Objects.requireNonNull(clickCallback, "function"), Objects.requireNonNull(options, "options"));
    }

    @NotNull
    public static ClickEvent callback(@NotNull ClickCallback<Audience> clickCallback, @NotNull @NotNull Consumer<@NotNull ClickCallback.Options.Builder> consumer) {
        return ClickCallbackInternals.PROVIDER.create(Objects.requireNonNull(clickCallback, "function"), (ClickCallback.Options)AbstractBuilder.configureAndBuild(ClickCallback.Options.builder(), Objects.requireNonNull(consumer, "optionsBuilder")));
    }

    @NotNull
    public static ClickEvent showDialog(@NotNull DialogLike dialogLike) {
        Objects.requireNonNull(dialogLike, "dialog");
        return new ClickEvent(Action.SHOW_DIALOG, Payload.dialog(dialogLike));
    }

    @Deprecated
    @NotNull
    public static ClickEvent custom(@NotNull Key key, @NotNull String string) {
        return ClickEvent.custom(key, BinaryTagHolder.binaryTagHolder(string));
    }

    @NotNull
    public static ClickEvent custom(@NotNull Key key, @NotNull BinaryTagHolder binaryTagHolder) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(binaryTagHolder, "nbt");
        return new ClickEvent(Action.CUSTOM, Payload.custom(key, binaryTagHolder));
    }

    @Deprecated
    @NotNull
    public static ClickEvent clickEvent(@NotNull Action action, @NotNull String string) {
        if (action == Action.CHANGE_PAGE) {
            return ClickEvent.changePage(string);
        }
        if (!action.payloadType().equals(Payload.Text.class)) {
            throw new IllegalArgumentException("Action " + (Object)((Object)action) + " does not support string payloads");
        }
        return new ClickEvent(action, Payload.string(string));
    }

    private ClickEvent(@NotNull Action action, @NotNull Payload payload) {
        if (!action.supports(payload)) {
            throw new IllegalArgumentException("Action " + (Object)((Object)action) + " does not support payload " + payload);
        }
        this.action = Objects.requireNonNull(action, "action");
        this.payload = Objects.requireNonNull(payload, "payload");
    }

    @NotNull
    public final Action action() {
        return this.action;
    }

    @Deprecated
    @NotNull
    public final String value() {
        if (this.payload instanceof Payload.Text) {
            return ((Payload.Text)this.payload).value();
        }
        if (this.action == Action.CHANGE_PAGE) {
            return String.valueOf(((Payload.Int)this.payload).integer());
        }
        throw new IllegalStateException("Payload is not a string payload, is " + this.payload);
    }

    @NotNull
    public final Payload payload() {
        return this.payload;
    }

    @Override
    public final void styleApply( @NotNull Style.Builder builder) {
        builder.clickEvent(this);
    }

    public final boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (ClickEvent)object;
        return this.action == ((ClickEvent)object).action && Objects.equals(this.payload, ((ClickEvent)object).payload);
    }

    public final int hashCode() {
        int n2 = this.action.hashCode();
        n2 = n2 * 31 + this.payload.hashCode();
        return n2;
    }

    @Override
    @NotNull
    public final Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("action", (Object)this.action), ExaminableProperty.of("payload", this.payload));
    }

    public final String toString() {
        return Internals.toString(this);
    }

    public static enum Action {
        OPEN_URL("open_url", true, Payload.Text.class),
        OPEN_FILE("open_file", false, Payload.Text.class),
        RUN_COMMAND("run_command", true, Payload.Text.class),
        SUGGEST_COMMAND("suggest_command", true, Payload.Text.class),
        CHANGE_PAGE("change_page", true, Payload.Int.class),
        COPY_TO_CLIPBOARD("copy_to_clipboard", true, Payload.Text.class),
        SHOW_DIALOG("show_dialog", false, Payload.Dialog.class),
        CUSTOM("custom", true, Payload.Custom.class);

        public static final Index<String, Action> NAMES;
        private final String name;
        private final boolean readable;
        private final Class<? extends Payload> payloadType;

        private Action(@NotNull String string2, boolean bl, Class<? extends Payload> clazz) {
            this.name = string2;
            this.readable = bl;
            this.payloadType = clazz;
        }

        public final boolean readable() {
            return this.readable;
        }

        public final boolean supports(@NotNull Payload payload) {
            Objects.requireNonNull(payload, "payload");
            return this.payloadType.isAssignableFrom(payload.getClass());
        }

        @NotNull
        public final Class<? extends Payload> payloadType() {
            return this.payloadType;
        }

        @NotNull
        public final String toString() {
            return this.name;
        }

        static {
            NAMES = Index.create(Action.class, action -> action.name);
        }
    }

    public static interface Payload
    extends Examinable {
        public static @NotNull Text string(@NotNull String string) {
            Objects.requireNonNull(string, "value");
            return new PayloadImpl.TextImpl(string);
        }

        public static @NotNull Int integer(int n2) {
            return new PayloadImpl.IntImpl(n2);
        }

        public static @NotNull Dialog dialog(@NotNull DialogLike dialogLike) {
            Objects.requireNonNull(dialogLike, "dialog");
            return new PayloadImpl.DialogImpl(dialogLike);
        }

        @Deprecated
        public static @NotNull Custom custom(@NotNull Key key, @NotNull String string) {
            return Payload.custom(key, BinaryTagHolder.binaryTagHolder(string));
        }

        public static @NotNull Custom custom(@NotNull Key key, @NotNull BinaryTagHolder binaryTagHolder) {
            Objects.requireNonNull(key, "key");
            Objects.requireNonNull(binaryTagHolder, "nbt");
            return new PayloadImpl.CustomImpl(key, binaryTagHolder);
        }

        public static interface Custom
        extends Keyed,
        Payload {
            @Deprecated
            @NotNull
            public String data();

            @NotNull
            public BinaryTagHolder nbt();
        }

        public static interface Dialog
        extends Payload {
            @NotNull
            public DialogLike dialog();
        }

        public static interface Int
        extends Payload {
            public int integer();
        }

        public static interface Text
        extends Payload {
            @NotNull
            public String value();
        }
    }
}

