/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clans.libs.adventure.adventure.text.event;

import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.function.Consumer;
import java.util.function.Predicate;
import me.loving11ish.clans.libs.adventure.adventure.audience.Audience;
import me.loving11ish.clans.libs.adventure.adventure.builder.AbstractBuilder;
import me.loving11ish.clans.libs.adventure.adventure.permission.PermissionChecker;
import me.loving11ish.clans.libs.adventure.adventure.text.event.ClickCallbackInternals;
import me.loving11ish.clans.libs.adventure.adventure.text.event.ClickCallbackOptionsImpl;
import me.loving11ish.clans.libs.adventure.adventure.text.event.ClickEvent;
import me.loving11ish.clans.libs.adventure.adventure.util.PlatformAPI;
import me.loving11ish.clans.libs.adventure.examination.Examinable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.CheckReturnValue;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface ClickCallback<T extends Audience> {
    public static final Duration DEFAULT_LIFETIME = Duration.ofHours(12L);
    public static final int UNLIMITED_USES = -1;

    @CheckReturnValue
    @Contract(pure=true)
    @NotNull
    public static <W extends Audience, N extends W> ClickCallback<W> widen(@NotNull ClickCallback<N> clickCallback, @NotNull Class<N> clazz, @Nullable Consumer<? super Audience> consumer) {
        return audience -> {
            if (clazz.isInstance(audience)) {
                clickCallback.accept((Audience)clazz.cast(audience));
                return;
            }
            if (consumer != null) {
                consumer.accept(audience);
            }
        };
    }

    @CheckReturnValue
    @Contract(pure=true)
    @NotNull
    public static <W extends Audience, N extends W> ClickCallback<W> widen(@NotNull ClickCallback<N> clickCallback, @NotNull Class<N> clazz) {
        return ClickCallback.widen(clickCallback, clazz, null);
    }

    public void accept(@NotNull T var1);

    @CheckReturnValue
    @Contract(pure=true)
    @NotNull
    default public ClickCallback<T> filter(@NotNull Predicate<T> predicate) {
        return this.filter(predicate, null);
    }

    @CheckReturnValue
    @Contract(pure=true)
    @NotNull
    default public ClickCallback<T> filter(@NotNull Predicate<T> predicate, @Nullable Consumer<? super Audience> consumer) {
        return audience -> {
            if (predicate.test(audience)) {
                this.accept(audience);
                return;
            }
            if (consumer != null) {
                consumer.accept(audience);
            }
        };
    }

    @CheckReturnValue
    @Contract(pure=true)
    @NotNull
    default public ClickCallback<T> requiringPermission(@NotNull String string) {
        return this.requiringPermission(string, null);
    }

    @CheckReturnValue
    @Contract(pure=true)
    @NotNull
    default public ClickCallback<T> requiringPermission(@NotNull String string, @Nullable Consumer<? super Audience> consumer) {
        return this.filter(audience -> audience.getOrDefault(PermissionChecker.POINTER, ClickCallbackInternals.ALWAYS_FALSE).test(string), consumer);
    }

    @PlatformAPI
    @ApiStatus.Internal
    public static interface Provider {
        @NotNull
        public ClickEvent create(@NotNull ClickCallback<Audience> var1, @NotNull Options var2);
    }

    @ApiStatus.NonExtendable
    public static interface Options
    extends Examinable {
        @NotNull
        public static Builder builder() {
            return new ClickCallbackOptionsImpl.BuilderImpl();
        }

        @NotNull
        public static Builder builder(@NotNull Options options) {
            return new ClickCallbackOptionsImpl.BuilderImpl(options);
        }

        public int uses();

        @NotNull
        public Duration lifetime();

        @ApiStatus.NonExtendable
        public static interface Builder
        extends AbstractBuilder<Options> {
            @NotNull
            public Builder uses(int var1);

            @NotNull
            public Builder lifetime(@NotNull TemporalAmount var1);
        }
    }
}

