/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clans.libs.adventure.adventure.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.loving11ish.clans.libs.adventure.adventure.internal.Internals;
import me.loving11ish.clans.libs.adventure.adventure.text.AbstractComponent;
import me.loving11ish.clans.libs.adventure.adventure.text.AbstractComponentBuilder;
import me.loving11ish.clans.libs.adventure.adventure.text.Component;
import me.loving11ish.clans.libs.adventure.adventure.text.ComponentLike;
import me.loving11ish.clans.libs.adventure.adventure.text.TranslatableComponent;
import me.loving11ish.clans.libs.adventure.adventure.text.TranslationArgument;
import me.loving11ish.clans.libs.adventure.adventure.text.TranslationArgumentLike;
import me.loving11ish.clans.libs.adventure.adventure.text.format.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TranslatableComponentImpl
extends AbstractComponent
implements TranslatableComponent {
    private final String key;
    @Nullable
    private final String fallback;
    private final List<TranslationArgument> args;

    static TranslatableComponent create(@NotNull List<Component> list, @NotNull Style style, @NotNull String string, @Nullable String string2, @NotNull @NotNull ComponentLike @NotNull [] componentLikeArray) {
        Objects.requireNonNull(componentLikeArray, "args");
        return TranslatableComponentImpl.create(list, style, string, string2, Arrays.asList(componentLikeArray));
    }

    static TranslatableComponent create(@NotNull List<? extends ComponentLike> list, @NotNull Style style, @NotNull String string, @Nullable String string2, @NotNull List<? extends ComponentLike> list2) {
        return new TranslatableComponentImpl(ComponentLike.asComponents(list, IS_NOT_EMPTY), Objects.requireNonNull(style, "style"), Objects.requireNonNull(string, "key"), string2, TranslatableComponentImpl.asArguments(list2));
    }

    TranslatableComponentImpl(@NotNull List<Component> list, @NotNull Style style, @NotNull String string, @Nullable String string2, @NotNull List<TranslationArgument> list2) {
        super(list, style);
        this.key = string;
        this.fallback = string2;
        this.args = list2;
    }

    @Override
    @NotNull
    public final String key() {
        return this.key;
    }

    @Override
    @NotNull
    public final TranslatableComponent key(@NotNull String string) {
        if (Objects.equals(this.key, string)) {
            return this;
        }
        return TranslatableComponentImpl.create(this.children, this.style, string, this.fallback, this.args);
    }

    @Override
    @Deprecated
    @NotNull
    public final List<Component> args() {
        return ComponentLike.asComponents(this.args);
    }

    @Override
    @NotNull
    public final List<TranslationArgument> arguments() {
        return this.args;
    }

    @Override
    @NotNull
    public final TranslatableComponent arguments(ComponentLike ... componentLikeArray) {
        return TranslatableComponentImpl.create(this.children, this.style, this.key, this.fallback, componentLikeArray);
    }

    @Override
    @NotNull
    public final TranslatableComponent arguments(@NotNull List<? extends ComponentLike> list) {
        return TranslatableComponentImpl.create(this.children, this.style, this.key, this.fallback, list);
    }

    @Override
    @Nullable
    public final String fallback() {
        return this.fallback;
    }

    @Override
    @NotNull
    public final TranslatableComponent fallback(@Nullable String string) {
        return TranslatableComponentImpl.create(this.children, this.style, this.key, string, this.args);
    }

    @Override
    @NotNull
    public final TranslatableComponent children(@NotNull List<? extends ComponentLike> list) {
        return TranslatableComponentImpl.create(list, this.style, this.key, this.fallback, this.args);
    }

    @Override
    @NotNull
    public final TranslatableComponent style(@NotNull Style style) {
        return TranslatableComponentImpl.create(this.children, style, this.key, this.fallback, this.args);
    }

    @Override
    public final boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TranslatableComponent)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        return Objects.equals(this.key, (object = (TranslatableComponent)object).key()) && Objects.equals(this.fallback, object.fallback()) && Objects.equals(this.args, object.arguments());
    }

    @Override
    public final int hashCode() {
        int n2 = super.hashCode();
        n2 = n2 * 31 + this.key.hashCode();
        n2 = n2 * 31 + Objects.hashCode(this.fallback);
        n2 = n2 * 31 + this.args.hashCode();
        return n2;
    }

    @Override
    public final String toString() {
        return Internals.toString(this);
    }

    @Override
    @NotNull
    public final TranslatableComponent.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static List<TranslationArgument> asArguments(@NotNull List<? extends ComponentLike> list) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TranslationArgument> arrayList = new ArrayList<TranslationArgument>(list.size());
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ComponentLike componentLike = list.get(i2);
            if (componentLike == null) {
                throw new NullPointerException("likes[" + i2 + "]");
            }
            if (componentLike instanceof TranslationArgument) {
                arrayList.add((TranslationArgument)componentLike);
                continue;
            }
            if (componentLike instanceof TranslationArgumentLike) {
                arrayList.add(Objects.requireNonNull(((TranslationArgumentLike)componentLike).asTranslationArgument(), "likes[" + i2 + "].asTranslationArgument()"));
                continue;
            }
            arrayList.add(TranslationArgument.component(componentLike));
        }
        return Collections.unmodifiableList(arrayList);
    }

    static final class BuilderImpl
    extends AbstractComponentBuilder<TranslatableComponent, TranslatableComponent.Builder>
    implements TranslatableComponent.Builder {
        @Nullable
        private String key;
        @Nullable
        private String fallback;
        private List<TranslationArgument> args = Collections.emptyList();

        BuilderImpl() {
        }

        BuilderImpl(@NotNull TranslatableComponent translatableComponent) {
            super(translatableComponent);
            this.key = translatableComponent.key();
            this.args = translatableComponent.arguments();
            this.fallback = translatableComponent.fallback();
        }

        @Override
        @NotNull
        public final TranslatableComponent.Builder key(@NotNull String string) {
            this.key = string;
            return this;
        }

        @Override
        @NotNull
        public final TranslatableComponent.Builder arguments(ComponentLike ... componentLikeArray) {
            Objects.requireNonNull(componentLikeArray, "args");
            if (componentLikeArray.length == 0) {
                return this.arguments(Collections.emptyList());
            }
            return this.arguments(Arrays.asList(componentLikeArray));
        }

        @Override
        @NotNull
        public final TranslatableComponent.Builder arguments(@NotNull List<? extends ComponentLike> list) {
            this.args = TranslatableComponentImpl.asArguments(Objects.requireNonNull(list, "args"));
            return this;
        }

        @Override
        @NotNull
        public final TranslatableComponent.Builder fallback(@Nullable String string) {
            this.fallback = string;
            return this;
        }

        @Override
        @NotNull
        public final TranslatableComponent build() {
            if (this.key == null) {
                throw new IllegalStateException("key must be set");
            }
            return TranslatableComponentImpl.create(this.children, this.buildStyle(), this.key, this.fallback, this.args);
        }
    }
}

