/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clans.libs.adventure.adventure.text;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import me.loving11ish.clans.libs.adventure.adventure.text.Component;
import me.loving11ish.clans.libs.adventure.adventure.text.ComponentIteratorFlag;
import me.loving11ish.clans.libs.adventure.adventure.text.ComponentIteratorType;
import org.jetbrains.annotations.NotNull;

final class ComponentIterator
implements Iterator<Component> {
    private Component component;
    private final ComponentIteratorType type;
    private final Set<ComponentIteratorFlag> flags;
    private final Deque<Component> deque;

    ComponentIterator(@NotNull Component component, @NotNull ComponentIteratorType componentIteratorType, @NotNull Set<ComponentIteratorFlag> set) {
        this.component = component;
        this.type = componentIteratorType;
        this.flags = set;
        this.deque = new ArrayDeque<Component>();
    }

    @Override
    public final boolean hasNext() {
        return this.component != null || !this.deque.isEmpty();
    }

    @Override
    public final Component next() {
        while (true) {
            if (this.component != null) {
                Component component = this.component;
                this.component = null;
                this.type.populate(component, this.deque, this.flags);
                return component;
            }
            if (this.deque.isEmpty()) {
                throw new NoSuchElementException();
            }
            this.component = this.deque.poll();
        }
    }
}

