/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clans.libs.adventure.adventure.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Formatter;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import me.loving11ish.clans.libs.adventure.adventure.internal.Internals;
import me.loving11ish.clans.libs.adventure.adventure.resource.ResourcePackInfo;
import me.loving11ish.clans.libs.adventure.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ResourcePackInfoImpl
implements ResourcePackInfo {
    private final UUID id;
    private final URI uri;
    private final String hash;

    ResourcePackInfoImpl(@NotNull UUID uUID, @NotNull URI uRI, @NotNull String string) {
        this.id = Objects.requireNonNull(uUID, "id");
        this.uri = Objects.requireNonNull(uRI, "uri");
        this.hash = Objects.requireNonNull(string, "hash");
    }

    @Override
    @NotNull
    public final UUID id() {
        return this.id;
    }

    @Override
    @NotNull
    public final URI uri() {
        return this.uri;
    }

    @Override
    @NotNull
    public final String hash() {
        return this.hash;
    }

    @Override
    @NotNull
    public final Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("id", this.id), ExaminableProperty.of("uri", this.uri), ExaminableProperty.of("hash", this.hash));
    }

    public final String toString() {
        return Internals.toString(this);
    }

    public final boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ResourcePackInfoImpl)) {
            return false;
        }
        object = (ResourcePackInfoImpl)object;
        return this.id.equals(((ResourcePackInfoImpl)object).id) && this.uri.equals(((ResourcePackInfoImpl)object).uri) && this.hash.equals(((ResourcePackInfoImpl)object).hash);
    }

    public final int hashCode() {
        int n2 = this.id.hashCode();
        n2 = n2 * 31 + this.uri.hashCode();
        n2 = n2 * 31 + this.hash.hashCode();
        return n2;
    }

    static CompletableFuture<String> computeHash(URI uRI, Executor executor) {
        CompletableFuture<String> completableFuture = new CompletableFuture<String>();
        executor.execute(() -> {
            try {
                block9: {
                    block8: {
                        uRI = ((URI)uRI).toURL();
                        uRI = ((URL)((Object)uRI)).openConnection();
                        ((URLConnection)((Object)uRI)).addRequestProperty("User-Agent", "adventure/" + ResourcePackInfoImpl.class.getPackage().getSpecificationVersion() + " (pack-fetcher)");
                        uRI = ((URLConnection)((Object)uRI)).getInputStream();
                        try {
                            int n2;
                            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
                            byte[] byArray = new byte[8192];
                            while ((n2 = ((InputStream)((Object)uRI)).read(byArray)) != -1) {
                                messageDigest.update(byArray, 0, n2);
                            }
                            completableFuture.complete(ResourcePackInfoImpl.bytesToString(messageDigest.digest()));
                            if (uRI == null) break block8;
                        }
                        catch (Throwable throwable) {
                            if (uRI != null) {
                                try {
                                    ((InputStream)((Object)uRI)).close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        break block9;
                    }
                    return;
                }
                ((InputStream)((Object)uRI)).close();
            }
            catch (IOException | NoSuchAlgorithmException exception) {
                completableFuture.completeExceptionally(exception);
            }
        });
        return completableFuture;
    }

    static String bytesToString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length << 1);
        Formatter formatter = new Formatter(stringBuilder, Locale.ROOT);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            formatter.format("%02x", byArray[i2] & 0xFF);
        }
        return stringBuilder.toString();
    }

    static final class BuilderImpl
    implements ResourcePackInfo.Builder {
        private UUID id;
        private URI uri;
        private String hash;

        BuilderImpl() {
        }

        @Override
        @NotNull
        public final ResourcePackInfo.Builder id(@NotNull UUID uUID) {
            this.id = Objects.requireNonNull(uUID, "id");
            return this;
        }

        @Override
        @NotNull
        public final ResourcePackInfo.Builder uri(@NotNull URI uRI) {
            this.uri = Objects.requireNonNull(uRI, "uri");
            if (this.id == null) {
                this.id = UUID.nameUUIDFromBytes(uRI.toString().getBytes(StandardCharsets.UTF_8));
            }
            return this;
        }

        @Override
        @NotNull
        public final ResourcePackInfo.Builder hash(@NotNull String string) {
            this.hash = Objects.requireNonNull(string, "hash");
            return this;
        }

        @Override
        @NotNull
        public final ResourcePackInfo build() {
            return new ResourcePackInfoImpl(this.id, this.uri, this.hash);
        }

        @Override
        @NotNull
        public final CompletableFuture<ResourcePackInfo> computeHashAndBuild(@NotNull Executor executor) {
            return ResourcePackInfoImpl.computeHash(Objects.requireNonNull(this.uri, "uri"), executor).thenApply(string -> {
                this.hash((String)string);
                return this.build();
            });
        }
    }
}

