/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clans.libs.adventure.adventure.platform.bukkit;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicReference;
import me.loving11ish.clans.libs.adventure.adventure.platform.bukkit.BukkitComponentSerializer;
import me.loving11ish.clans.libs.adventure.adventure.platform.bukkit.MinecraftReflection;
import me.loving11ish.clans.libs.adventure.adventure.text.Component;
import me.loving11ish.clans.libs.adventure.adventure.text.serializer.ComponentSerializer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class MinecraftComponentSerializer
implements ComponentSerializer<Component, Component, Object> {
    private static final MinecraftComponentSerializer INSTANCE = new MinecraftComponentSerializer();
    @Nullable
    private static final Class<?> CLASS_JSON_DESERIALIZER = MinecraftReflection.findClass("com.google.gson.JsonDeserializer");
    @Nullable
    private static final Class<?> CLASS_JSON_ELEMENT = MinecraftReflection.findClass("com.google.gson.JsonElement");
    @Nullable
    private static final Class<?> CLASS_JSON_PARSER = MinecraftReflection.findClass("com.google.gson.JsonParser");
    @Nullable
    private static final Class<?> CLASS_CHAT_COMPONENT = MinecraftReflection.findClass(MinecraftReflection.findNmsClassName("IChatBaseComponent"), MinecraftReflection.findMcClassName("network.chat.IChatBaseComponent"), MinecraftReflection.findMcClassName("network.chat.Component"));
    @Nullable
    private static final Class<?> CLASS_CRAFT_REGISTRY = MinecraftReflection.findCraftClass("CraftRegistry");
    @Nullable
    private static final Class<?> CLASS_REGISTRY_ACCESS = MinecraftReflection.findClass(MinecraftReflection.findMcClassName("core.IRegistryCustom"), MinecraftReflection.findMcClassName("core.RegistryAccess"));
    @Nullable
    private static final MethodHandle PARSE_JSON = MinecraftReflection.findMethod(CLASS_JSON_PARSER, "parse", CLASS_JSON_ELEMENT, String.class);
    @Nullable
    private static final MethodHandle GET_REGISTRY = MinecraftReflection.findStaticMethod(CLASS_CRAFT_REGISTRY, "getMinecraftRegistry", CLASS_REGISTRY_ACCESS, new Class[0]);
    private static final AtomicReference<RuntimeException> INITIALIZATION_ERROR = new AtomicReference<UnsupportedOperationException>(new UnsupportedOperationException());
    private static final Object JSON_PARSER_INSTANCE;
    private static final Object MC_TEXT_GSON;
    private static final MethodHandle TEXT_SERIALIZER_DESERIALIZE;
    private static final MethodHandle TEXT_SERIALIZER_SERIALIZE;
    private static final MethodHandle TEXT_SERIALIZER_DESERIALIZE_TREE;
    private static final MethodHandle TEXT_SERIALIZER_SERIALIZE_TREE;
    private static final boolean SUPPORTED;

    public static boolean isSupported() {
        return SUPPORTED;
    }

    @NotNull
    public static MinecraftComponentSerializer get() {
        return INSTANCE;
    }

    @Override
    @NotNull
    public final Component deserialize(@NotNull Object object) {
        if (!SUPPORTED) {
            throw INITIALIZATION_ERROR.get();
        }
        try {
            if (TEXT_SERIALIZER_SERIALIZE_TREE != null) {
                object = TEXT_SERIALIZER_SERIALIZE_TREE.invoke(object);
            } else if (MC_TEXT_GSON != null) {
                object = ((Gson)MC_TEXT_GSON).toJsonTree(object);
            } else {
                return BukkitComponentSerializer.gson().deserialize(TEXT_SERIALIZER_SERIALIZE.invoke(object));
            }
            return (Component)BukkitComponentSerializer.gson().serializer().fromJson(object.toString(), Component.class);
        }
        catch (Throwable throwable) {
            throw new UnsupportedOperationException(throwable);
        }
    }

    @Override
    @NotNull
    public final Object serialize(@NotNull Component object) {
        if (!SUPPORTED) {
            throw INITIALIZATION_ERROR.get();
        }
        if (TEXT_SERIALIZER_DESERIALIZE_TREE != null || MC_TEXT_GSON != null) {
            object = BukkitComponentSerializer.gson().serializer().toJsonTree(object);
            try {
                if (TEXT_SERIALIZER_DESERIALIZE_TREE != null) {
                    object = PARSE_JSON.invoke(JSON_PARSER_INSTANCE, object.toString());
                    return TEXT_SERIALIZER_DESERIALIZE_TREE.invoke(object);
                }
                return ((Gson)MC_TEXT_GSON).fromJson((JsonElement)object, CLASS_CHAT_COMPONENT);
            }
            catch (Throwable throwable) {
                throw new UnsupportedOperationException(throwable);
            }
        }
        try {
            return TEXT_SERIALIZER_DESERIALIZE.invoke((String)BukkitComponentSerializer.gson().serialize(object));
        }
        catch (Throwable throwable) {
            throw new UnsupportedOperationException(throwable);
        }
    }

    static {
        Object object = null;
        Object var1_1 = null;
        MethodHandle methodHandle = null;
        MethodHandle methodHandle2 = null;
        MethodHandle methodHandle3 = null;
        MethodHandle methodHandle4 = null;
        try {
            if (CLASS_JSON_PARSER != null) {
                var1_1 = CLASS_JSON_PARSER.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            if (CLASS_CHAT_COMPONENT != null) {
                Object object2;
                Object object3 = GET_REGISTRY != null ? GET_REGISTRY.invoke() : null;
                Class<?> clazz = Arrays.stream(CLASS_CHAT_COMPONENT.getClasses()).filter(classArray -> {
                    if (CLASS_JSON_DESERIALIZER != null) {
                        return CLASS_JSON_DESERIALIZER.isAssignableFrom((Class<?>)classArray);
                    }
                    for (Class<?> clazz : classArray.getInterfaces()) {
                        if (!clazz.getSimpleName().equals("JsonDeserializer")) continue;
                        return true;
                    }
                    return false;
                }).findAny().orElse(MinecraftReflection.findNmsClass("ChatSerializer"));
                if (clazz != null && (object2 = (Field)Arrays.stream(clazz.getDeclaredFields()).filter(field -> Modifier.isStatic(field.getModifiers())).filter(field -> field.getType().equals(Gson.class)).findFirst().orElse(null)) != null) {
                    ((Field)object2).setAccessible(true);
                    object = ((Field)object2).get(null);
                }
                object2 = new ArrayList();
                if (clazz != null) {
                    object2.add(clazz);
                }
                object2.addAll(Arrays.asList(CLASS_CHAT_COMPONENT.getClasses()));
                clazz = object2.iterator();
                while (clazz.hasNext()) {
                    object2 = (Class)clazz.next();
                    object2 = ((Class)object2).getDeclaredMethods();
                    Method method2 = Arrays.stream(object2).filter(method -> Modifier.isStatic(method.getModifiers())).filter(method -> CLASS_CHAT_COMPONENT.isAssignableFrom(method.getReturnType())).filter(method -> method.getParameterCount() == 1 && method.getParameterTypes()[0].equals(String.class)).min(Comparator.comparing(Method::getName)).orElse(null);
                    Method method3 = Arrays.stream(object2).filter(method -> Modifier.isStatic(method.getModifiers())).filter(method -> method.getReturnType().equals(String.class)).filter(method -> method.getParameterCount() == 1 && CLASS_CHAT_COMPONENT.isAssignableFrom(method.getParameterTypes()[0])).findFirst().orElse(null);
                    Method method4 = Arrays.stream(object2).filter(method -> Modifier.isStatic(method.getModifiers())).filter(method -> CLASS_CHAT_COMPONENT.isAssignableFrom(method.getReturnType())).filter(method -> method.getParameterCount() == 1 && method.getParameterTypes()[0].equals(CLASS_JSON_ELEMENT)).findFirst().orElse(null);
                    Method method5 = Arrays.stream(object2).filter(method -> Modifier.isStatic(method.getModifiers())).filter(method -> method.getReturnType().equals(CLASS_JSON_ELEMENT)).filter(method -> method.getParameterCount() == 1 && CLASS_CHAT_COMPONENT.isAssignableFrom(method.getParameterTypes()[0])).findFirst().orElse(null);
                    Method method6 = Arrays.stream(object2).filter(method -> Modifier.isStatic(method.getModifiers())).filter(method -> CLASS_CHAT_COMPONENT.isAssignableFrom(method.getReturnType())).filter(method -> method.getParameterCount() == 2).filter(method -> method.getParameterTypes()[0].equals(CLASS_JSON_ELEMENT)).filter(method -> method.getParameterTypes()[1].isInstance(object3)).findFirst().orElse(null);
                    object2 = Arrays.stream(object2).filter(method -> Modifier.isStatic(method.getModifiers())).filter(method -> method.getReturnType().equals(CLASS_JSON_ELEMENT)).filter(method -> method.getParameterCount() == 2).filter(method -> CLASS_CHAT_COMPONENT.isAssignableFrom(method.getParameterTypes()[0])).filter(method -> method.getParameterTypes()[1].isInstance(object3)).findFirst().orElse(null);
                    if (method2 != null) {
                        methodHandle = MinecraftReflection.lookup().unreflect(method2);
                    }
                    if (method3 != null) {
                        methodHandle2 = MinecraftReflection.lookup().unreflect(method3);
                    }
                    if (method4 != null) {
                        methodHandle3 = MinecraftReflection.lookup().unreflect(method4);
                    } else if (method6 != null) {
                        method6.setAccessible(true);
                        methodHandle3 = MethodHandles.insertArguments(MinecraftReflection.lookup().unreflect(method6), 1, object3);
                    }
                    if (method5 != null) {
                        methodHandle4 = MinecraftReflection.lookup().unreflect(method5);
                        continue;
                    }
                    if (object2 == null) continue;
                    ((Method)object2).setAccessible(true);
                    methodHandle4 = MethodHandles.insertArguments(MinecraftReflection.lookup().unreflect((Method)object2), 1, object3);
                }
            }
        }
        catch (Throwable throwable) {
            INITIALIZATION_ERROR.set(new UnsupportedOperationException("Error occurred during initialization", throwable));
        }
        MC_TEXT_GSON = object;
        JSON_PARSER_INSTANCE = var1_1;
        TEXT_SERIALIZER_DESERIALIZE = methodHandle;
        TEXT_SERIALIZER_SERIALIZE = methodHandle2;
        TEXT_SERIALIZER_DESERIALIZE_TREE = methodHandle3;
        TEXT_SERIALIZER_SERIALIZE_TREE = methodHandle4;
        SUPPORTED = MC_TEXT_GSON != null || TEXT_SERIALIZER_DESERIALIZE != null && TEXT_SERIALIZER_SERIALIZE != null || TEXT_SERIALIZER_DESERIALIZE_TREE != null && TEXT_SERIALIZER_SERIALIZE_TREE != null;
    }
}

