/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clans.libs.adventure.adventure.internal.properties;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import me.loving11ish.clans.libs.adventure.adventure.internal.properties.AdventureProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

final class AdventurePropertiesImpl {
    private static final String FILESYSTEM_DIRECTORY_NAME = "config";
    private static final String FILESYSTEM_FILE_NAME = "adventure.properties";
    private static final Properties PROPERTIES = new Properties();

    private static void print(Throwable throwable) {
        throwable.printStackTrace();
    }

    private AdventurePropertiesImpl() {
    }

    @VisibleForTesting
    @NotNull
    static String systemPropertyName(String string) {
        return String.join((CharSequence)".", "net", "kyori", "adventure", string);
    }

    static <T> @NotNull AdventureProperties.Property<T> property(@NotNull String string, @NotNull Function<String, T> function, @Nullable T t2) {
        return new PropertyImpl<T>(string, function, t2);
    }

    static {
        Object object = Optional.ofNullable(System.getProperty(AdventurePropertiesImpl.systemPropertyName(FILESYSTEM_DIRECTORY_NAME))).map(string -> Paths.get(string, new String[0])).orElseGet(() -> Paths.get(FILESYSTEM_DIRECTORY_NAME, FILESYSTEM_FILE_NAME));
        if (Files.isRegularFile((Path)object, new LinkOption[0])) {
            try {
                object = Files.newInputStream((Path)object, new OpenOption[0]);
                try {
                    PROPERTIES.load((InputStream)object);
                }
                finally {
                    if (object != null) {
                        ((InputStream)object).close();
                    }
                }
            }
            catch (IOException iOException) {
                object = iOException;
                AdventurePropertiesImpl.print(iOException);
            }
        }
    }

    private static final class PropertyImpl<T>
    implements AdventureProperties.Property<T> {
        private final String name;
        private final Function<String, T> parser;
        @Nullable
        private final T defaultValue;
        private boolean valueCalculated;
        @Nullable
        private T value;

        PropertyImpl(@NotNull String string, @NotNull Function<String, T> function, @Nullable T t2) {
            this.name = string;
            this.parser = function;
            this.defaultValue = t2;
        }

        @Override
        @Nullable
        public final T value() {
            if (!this.valueCalculated) {
                String string = AdventurePropertiesImpl.systemPropertyName(this.name);
                if ((string = System.getProperty(string, PROPERTIES.getProperty(this.name))) != null) {
                    this.value = this.parser.apply(string);
                }
                if (this.value == null) {
                    this.value = this.defaultValue;
                }
                this.valueCalculated = true;
            }
            return this.value;
        }

        public final boolean equals(@Nullable Object object) {
            return this == object;
        }

        public final int hashCode() {
            return this.name.hashCode();
        }
    }
}

