/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clans.libs.adventure.adventure.bossbar;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.stream.Stream;
import me.loving11ish.clans.libs.adventure.adventure.bossbar.BossBar;
import me.loving11ish.clans.libs.adventure.adventure.bossbar.BossBarImplementation;
import me.loving11ish.clans.libs.adventure.adventure.bossbar.BossBarViewer;
import me.loving11ish.clans.libs.adventure.adventure.bossbar.HackyBossBarPlatformBridge;
import me.loving11ish.clans.libs.adventure.adventure.internal.Internals;
import me.loving11ish.clans.libs.adventure.adventure.text.Component;
import me.loving11ish.clans.libs.adventure.adventure.util.Services;
import me.loving11ish.clans.libs.adventure.examination.ExaminableProperty;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class BossBarImpl
extends HackyBossBarPlatformBridge
implements BossBar {
    private final List<BossBar.Listener> listeners = new CopyOnWriteArrayList<BossBar.Listener>();
    private Component name;
    private float progress;
    private BossBar.Color color;
    private BossBar.Overlay overlay;
    private final Set<BossBar.Flag> flags = EnumSet.noneOf(BossBar.Flag.class);
    @Nullable
    BossBarImplementation implementation;

    BossBarImpl(@NotNull Component component, float f2, @NotNull BossBar.Color color, @NotNull BossBar.Overlay overlay) {
        this.name = Objects.requireNonNull(component, "name");
        this.progress = f2;
        this.color = Objects.requireNonNull(color, "color");
        this.overlay = Objects.requireNonNull(overlay, "overlay");
    }

    BossBarImpl(@NotNull Component component, float f2, @NotNull BossBar.Color color, @NotNull BossBar.Overlay overlay, @NotNull Set<BossBar.Flag> set) {
        this(component, f2, color, overlay);
        this.flags.addAll(set);
    }

    @Override
    @NotNull
    public final Component name() {
        return this.name;
    }

    @Override
    @NotNull
    public final BossBar name(@NotNull Component component) {
        Objects.requireNonNull(component, "name");
        Component component2 = this.name;
        this.name = component;
        BossBarImpl bossBarImpl = this;
        bossBarImpl.forEachListener(listener -> listener.bossBarNameChanged(this, component2, component));
        return this;
    }

    @Override
    public final float progress() {
        return this.progress;
    }

    @Override
    @NotNull
    public final BossBar progress(float f2) {
        BossBarImpl.checkProgress(f2);
        float f3 = this.progress;
        if (f2 != f3) {
            this.progress = f2;
            BossBarImpl bossBarImpl = this;
            bossBarImpl.forEachListener(listener -> listener.bossBarProgressChanged(this, f3, f2));
        }
        return this;
    }

    static void checkProgress(float f2) {
        if (f2 < 0.0f || f2 > 1.0f) {
            throw new IllegalArgumentException("progress must be between 0.0 and 1.0, was " + f2);
        }
    }

    @Override
    @NotNull
    public final BossBar.Color color() {
        return this.color;
    }

    @Override
    @NotNull
    public final BossBar color(@NotNull BossBar.Color color) {
        Objects.requireNonNull(color, "color");
        BossBar.Color color2 = this.color;
        if (color != color2) {
            this.color = color;
            BossBarImpl bossBarImpl = this;
            bossBarImpl.forEachListener(listener -> listener.bossBarColorChanged(this, color2, color));
        }
        return this;
    }

    @Override
    @NotNull
    public final BossBar.Overlay overlay() {
        return this.overlay;
    }

    @Override
    @NotNull
    public final BossBar overlay(@NotNull BossBar.Overlay overlay) {
        Objects.requireNonNull(overlay, "overlay");
        BossBar.Overlay overlay2 = this.overlay;
        if (overlay != overlay2) {
            this.overlay = overlay;
            BossBarImpl bossBarImpl = this;
            bossBarImpl.forEachListener(listener -> listener.bossBarOverlayChanged(this, overlay2, overlay));
        }
        return this;
    }

    @Override
    @NotNull
    public final Set<BossBar.Flag> flags() {
        return Collections.unmodifiableSet(this.flags);
    }

    @Override
    @NotNull
    public final BossBar flags(@NotNull Set<BossBar.Flag> set) {
        if (set.isEmpty() && !this.flags.isEmpty()) {
            EnumSet<BossBar.Flag> enumSet = EnumSet.copyOf(this.flags);
            this.flags.clear();
            BossBarImpl bossBarImpl = this;
            bossBarImpl.forEachListener(listener -> listener.bossBarFlagsChanged(this, Collections.emptySet(), enumSet));
        } else if (!this.flags.equals(set)) {
            EnumSet<BossBar.Flag> enumSet = EnumSet.copyOf(this.flags);
            this.flags.clear();
            this.flags.addAll(set);
            set = EnumSet.copyOf(set);
            set.removeIf(enumSet::contains);
            enumSet = EnumSet.copyOf(enumSet);
            enumSet.removeIf(this.flags::contains);
            BossBarImpl bossBarImpl = this;
            bossBarImpl.forEachListener(listener -> listener.bossBarFlagsChanged(this, set, enumSet));
        }
        return this;
    }

    @Override
    public final boolean hasFlag(@NotNull BossBar.Flag flag) {
        return this.flags.contains((Object)flag);
    }

    @Override
    @NotNull
    public final BossBar addFlag(@NotNull BossBar.Flag flag) {
        return this.editFlags(flag, Set::add, BossBarImpl::onFlagsAdded);
    }

    @Override
    @NotNull
    public final BossBar removeFlag(@NotNull BossBar.Flag flag) {
        return this.editFlags(flag, Set::remove, BossBarImpl::onFlagsRemoved);
    }

    @NotNull
    private BossBar editFlags(@NotNull BossBar.Flag flag, @NotNull BiPredicate<Set<BossBar.Flag>, BossBar.Flag> biPredicate, BiConsumer<BossBarImpl, Set<BossBar.Flag>> biConsumer) {
        if (biPredicate.test(this.flags, flag)) {
            biConsumer.accept(this, Collections.singleton(flag));
        }
        return this;
    }

    @Override
    @NotNull
    public final BossBar addFlags(BossBar.Flag ... flagArray) {
        return this.editFlags(flagArray, Set::add, BossBarImpl::onFlagsAdded);
    }

    @Override
    @NotNull
    public final BossBar removeFlags(BossBar.Flag ... flagArray) {
        return this.editFlags(flagArray, Set::remove, BossBarImpl::onFlagsRemoved);
    }

    @NotNull
    private BossBar editFlags(BossBar.Flag[] flagArray, BiPredicate<Set<BossBar.Flag>, BossBar.Flag> biPredicate, BiConsumer<BossBarImpl, Set<BossBar.Flag>> biConsumer) {
        if (flagArray.length == 0) {
            return this;
        }
        EnumSet<BossBar.Flag> enumSet = null;
        int n2 = flagArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!biPredicate.test(this.flags, flagArray[i2])) continue;
            if (enumSet == null) {
                enumSet = EnumSet.noneOf(BossBar.Flag.class);
            }
            enumSet.add(flagArray[i2]);
        }
        if (enumSet != null) {
            biConsumer.accept(this, enumSet);
        }
        return this;
    }

    @Override
    @NotNull
    public final BossBar addFlags(@NotNull Iterable<BossBar.Flag> iterable) {
        return this.editFlags(iterable, Set::add, BossBarImpl::onFlagsAdded);
    }

    @Override
    @NotNull
    public final BossBar removeFlags(@NotNull Iterable<BossBar.Flag> iterable) {
        return this.editFlags(iterable, Set::remove, BossBarImpl::onFlagsRemoved);
    }

    @NotNull
    private BossBar editFlags(Iterable<BossBar.Flag> object, BiPredicate<Set<BossBar.Flag>, BossBar.Flag> biPredicate, BiConsumer<BossBarImpl, Set<BossBar.Flag>> biConsumer) {
        EnumSet<BossBar.Flag> enumSet = null;
        object = object.iterator();
        while (object.hasNext()) {
            BossBar.Flag flag = (BossBar.Flag)((Object)object.next());
            if (!biPredicate.test(this.flags, flag)) continue;
            if (enumSet == null) {
                enumSet = EnumSet.noneOf(BossBar.Flag.class);
            }
            enumSet.add(flag);
        }
        if (enumSet != null) {
            biConsumer.accept(this, enumSet);
        }
        return this;
    }

    @Override
    @NotNull
    public final BossBar addListener(@NotNull BossBar.Listener listener) {
        this.listeners.add(listener);
        return this;
    }

    @Override
    @NotNull
    public final BossBar removeListener(@NotNull BossBar.Listener listener) {
        this.listeners.remove(listener);
        return this;
    }

    @Override
    @NotNull
    public final Iterable<? extends BossBarViewer> viewers() {
        if (this.implementation != null) {
            return this.implementation.viewers();
        }
        return Collections.emptyList();
    }

    private void forEachListener(@NotNull Consumer<BossBar.Listener> consumer) {
        for (BossBar.Listener listener : this.listeners) {
            consumer.accept(listener);
        }
    }

    private static void onFlagsAdded(BossBarImpl bossBarImpl, Set<BossBar.Flag> set) {
        BossBarImpl bossBarImpl2 = bossBarImpl;
        bossBarImpl2.forEachListener(listener -> listener.bossBarFlagsChanged(bossBarImpl2, set, Collections.emptySet()));
    }

    private static void onFlagsRemoved(BossBarImpl bossBarImpl, Set<BossBar.Flag> set) {
        BossBarImpl bossBarImpl2 = bossBarImpl;
        bossBarImpl2.forEachListener(listener -> listener.bossBarFlagsChanged(bossBarImpl2, Collections.emptySet(), set));
    }

    @Override
    @NotNull
    public final Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("name", this.name), ExaminableProperty.of("progress", this.progress), ExaminableProperty.of("color", (Object)this.color), ExaminableProperty.of("overlay", (Object)this.overlay), ExaminableProperty.of("flags", this.flags));
    }

    public final String toString() {
        return Internals.toString(this);
    }

    @ApiStatus.Internal
    static final class ImplementationAccessor {
        private static final Optional<BossBarImplementation.Provider> SERVICE = Services.service(BossBarImplementation.Provider.class);

        private ImplementationAccessor() {
        }

        @NotNull
        static <I extends BossBarImplementation> I get(@NotNull BossBar bossBar, @NotNull Class<I> clazz) {
            @Nullable BossBarImplementation bossBarImplementation = ((BossBarImpl)bossBar).implementation;
            if (bossBarImplementation == null) {
                ((BossBarImpl)bossBar).implementation = bossBarImplementation = SERVICE.get().create(bossBar);
            }
            return (I)((BossBarImplementation)clazz.cast(bossBarImplementation));
        }
    }
}

