/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.clans.api;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.loving11ish.clans.api.models.Clan;
import me.loving11ish.clans.api.models.ClanPlayer;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public interface ClansLiteAPI {
    public static ClansLiteAPI getInstance() {
        RegisteredServiceProvider registeredServiceProvider = Bukkit.getServicesManager().getRegistration(ClansLiteAPI.class);
        if (registeredServiceProvider == null) {
            return null;
        }
        return (ClansLiteAPI)registeredServiceProvider.getProvider();
    }

    public void refreshData();

    public boolean isPluginEnabled();

    public String getServerPackage();

    public int getMajorServerVersion();

    public boolean isServerRunningOnline();

    public boolean isClansLitePluginUpdateAvailable();

    public String getClansLiteDevelopmentBuildRepository();

    public HashMap<Player, String> getConnectedBedrockPlayers();

    public HashMap<UUID, Clan> getAllClans();

    public HashMap<UUID, ClanPlayer> getAllClanPlayers();

    public List<Clan> getTopClansByClanPointsOnDemand(int var1);

    public List<Clan> getTopClansByClanPointsCache();

    public List<ClanPlayer> getTopClanPlayersByClanPointsOnDemand(int var1);

    public List<ClanPlayer> getTopClanPlayersByPlayerPointsCache();

    public ClanPlayer getClanPlayerByBukkitPlayer(Player var1);

    public ClanPlayer getClanPlayerByBukkitOfflinePlayer(OfflinePlayer var1);

    public OfflinePlayer getBukkitOfflinePlayerByLastKnownName(String var1);

    public OfflinePlayer getBukkitOfflinePlayerByUUID(UUID var1);

    public Clan getClanByBukkitPlayer(Player var1);

    public Clan getClanByBukkitOfflinePlayer(OfflinePlayer var1);

    public Clan getClanByBukkitPlayerOwner(Player var1);

    public Clan getClanByBukkitOfflinePlayerOwner(OfflinePlayer var1);

    public Clan getClanByClanName(String var1);

    public Clan createClan(Player var1, String var2);

    public boolean deleteClan(Player var1);

    public void setClanPrefix(Player var1, String var2);

    public boolean addClanMember(Clan var1, Player var2);

    public boolean removeClanMember(Clan var1, Player var2);

    public boolean removeOfflineClanMember(Clan var1, OfflinePlayer var2);
}

