/*
 * Decompiled with CFR 0.152.
 */
package org.little100.super_Farming.listener;

import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.persistence.PersistentDataType;
import org.little100.super_Farming.Super_Farming;
import org.little100.super_Farming.item.ItemManager;

public class CraftingListener
implements Listener {
    private final Super_Farming plugin;

    public CraftingListener(Super_Farming plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPrepareCraft(PrepareItemCraftEvent event) {
        ShapelessRecipe shapelessRecipe;
        CraftingInventory inventory = event.getInventory();
        ItemStack result = inventory.getResult();
        Recipe recipe = event.getRecipe();
        if (result == null || recipe == null) {
            return;
        }
        if (recipe instanceof ShapelessRecipe && this.isOurTier2Recipe(shapelessRecipe = (ShapelessRecipe)recipe)) {
            if (this.plugin.isCraftingDebugEnabled()) {
                this.plugin.getLogger().info("\u68c0\u6d4b\u5230Tier2\u914d\u65b9: " + shapelessRecipe.getKey().getKey());
            }
            ItemStack[] matrix = inventory.getMatrix();
            boolean hasSuperHoe = false;
            for (ItemStack item : matrix) {
                if (item == null || !item.hasItemMeta() || !item.getItemMeta().getPersistentDataContainer().has(ItemManager.SUPERHOE_KEY, PersistentDataType.STRING)) continue;
                hasSuperHoe = true;
                if (!this.plugin.isCraftingDebugEnabled()) break;
                String hoeType = (String)item.getItemMeta().getPersistentDataContainer().get(ItemManager.SUPERHOE_KEY, PersistentDataType.STRING);
                this.plugin.getLogger().info("\u53d1\u73b0\u8d85\u7ea7\u9504\u5934: " + hoeType);
                break;
            }
            if (!hasSuperHoe) {
                if (this.plugin.isCraftingDebugEnabled()) {
                    this.plugin.getLogger().info("\u6ca1\u6709\u53d1\u73b0\u8d85\u7ea7\u9504\u5934\uff0c\u53d6\u6d88\u5408\u6210");
                }
                inventory.setResult(null);
            } else if (this.plugin.isCraftingDebugEnabled()) {
                this.plugin.getLogger().info("Tier2\u914d\u65b9\u9a8c\u8bc1\u901a\u8fc7\uff0c\u5141\u8bb8\u5408\u6210");
            }
            return;
        }
        if (result != null && this.isVanillaHoe(result.getType())) {
            ItemStack[] matrix;
            for (ItemStack item : matrix = inventory.getMatrix()) {
                if (item == null || !item.hasItemMeta() || !item.getItemMeta().getPersistentDataContainer().has(ItemManager.SUPERHOE_KEY, PersistentDataType.STRING)) continue;
                if (this.plugin.isCraftingDebugEnabled()) {
                    this.plugin.getLogger().info("\u963b\u6b62\u8d85\u7ea7\u9504\u5934\u88ab\u7528\u4e8e\u539f\u7248\u914d\u65b9");
                }
                inventory.setResult(null);
                return;
            }
        }
    }

    private boolean isOurTier2Recipe(ShapelessRecipe recipe) {
        NamespacedKey key = recipe.getKey();
        return key.getNamespace().equals("super_farming") && (key.getKey().equals("wooden_hoe_tier2") || key.getKey().equals("stone_hoe_tier2") || key.getKey().equals("iron_hoe_tier2") || key.getKey().equals("golden_hoe_tier2") || key.getKey().equals("diamond_hoe_tier2"));
    }

    private boolean validateTier2Recipe(CraftingInventory inventory, ShapelessRecipe recipe) {
        ItemStack[] matrix = inventory.getMatrix();
        ItemStack[] recipeKey = recipe.getKey().getKey();
        String requiredTier1Type = null;
        switch (recipeKey) {
            case "wooden_hoe_tier2": {
                requiredTier1Type = "WOODEN_HOE_TIER1";
                break;
            }
            case "stone_hoe_tier2": {
                requiredTier1Type = "STONE_HOE_TIER1";
                break;
            }
            case "iron_hoe_tier2": {
                requiredTier1Type = "IRON_HOE_TIER1";
                break;
            }
            case "golden_hoe_tier2": {
                requiredTier1Type = "GOLDEN_HOE_TIER1";
                break;
            }
            case "diamond_hoe_tier2": {
                requiredTier1Type = "DIAMOND_HOE_TIER1";
                break;
            }
            default: {
                return false;
            }
        }
        this.plugin.getLogger().info("\u9700\u8981\u7684Tier1\u9504\u5934\u7c7b\u578b: " + requiredTier1Type);
        for (ItemStack item : matrix) {
            if (item == null || !item.hasItemMeta()) continue;
            String hoeType = (String)item.getItemMeta().getPersistentDataContainer().get(ItemManager.SUPERHOE_KEY, PersistentDataType.STRING);
            this.plugin.getLogger().info("\u53d1\u73b0\u7269\u54c1\u7684\u9504\u5934\u7c7b\u578b: " + hoeType);
            if (!requiredTier1Type.equals(hoeType)) continue;
            this.plugin.getLogger().info("\u627e\u5230\u4e86\u6b63\u786e\u7684Tier1\u9504\u5934!");
            return true;
        }
        this.plugin.getLogger().info("\u6ca1\u6709\u627e\u5230\u6b63\u786e\u7684Tier1\u9504\u5934");
        return false;
    }

    private boolean isVanillaHoe(Material material) {
        return material == Material.WOODEN_HOE || material == Material.STONE_HOE || material == Material.IRON_HOE || material == Material.GOLDEN_HOE || material == Material.DIAMOND_HOE || material == Material.NETHERITE_HOE;
    }
}

