/*
 * Decompiled with CFR 0.152.
 */
package org.little100.super_Farming.command;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;
import org.little100.super_Farming.Super_Farming;
import org.little100.super_Farming.gui.GuiManager;
import org.little100.super_Farming.language.LanguageManager;

public class CommandManager
implements CommandExecutor,
TabCompleter {
    private final Super_Farming plugin;
    private final LanguageManager languageManager;
    private GuiManager guiManager;

    public CommandManager(Super_Farming plugin) {
        this.plugin = plugin;
        this.languageManager = plugin.getLanguageManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (this.guiManager == null) {
            this.guiManager = this.plugin.getGuiManager();
        }
        if (command.getName().equalsIgnoreCase("super_farming")) {
            String subCommand;
            if (args.length == 0) {
                return false;
            }
            switch (subCommand = args[0].toLowerCase()) {
                case "lang": {
                    return this.handleLanguageCommand(sender, Arrays.copyOfRange(args, 1, args.length));
                }
                case "reload": {
                    return this.handleReloadCommand(sender);
                }
                case "editor": {
                    return this.handleEditorCommand(sender);
                }
            }
            return false;
        }
        return false;
    }

    private boolean handleReloadCommand(CommandSender sender) {
        if (!sender.hasPermission("super_farming.reload")) {
            sender.sendMessage(this.languageManager.getString("command.no_permission"));
            return true;
        }
        this.plugin.reload();
        sender.sendMessage(this.languageManager.getString("command.reload.success"));
        return true;
    }

    private boolean handleEditorCommand(CommandSender sender) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            this.guiManager.openEditor(player);
            sender.sendMessage(this.languageManager.getString("command.editor.open"));
        } else {
            sender.sendMessage(this.languageManager.getString("command.editor.player_only"));
        }
        return true;
    }

    private boolean handleLanguageCommand(CommandSender sender, String[] args) {
        List<String> availableLanguages = this.getAvailableLanguages();
        String langList = String.join((CharSequence)", ", availableLanguages);
        if (args.length == 0) {
            String message = this.languageManager.getString("command.language.list").replace("%langs%", langList);
            sender.sendMessage(message);
            return true;
        }
        String langCode = args[0].toLowerCase();
        if (availableLanguages.contains(langCode)) {
            this.languageManager.setDefaultLanguage(langCode);
            String message = this.languageManager.getString("command.language.change").replace("%lang%", langCode);
            sender.sendMessage(message);
        } else {
            String message = this.languageManager.getString("command.language.not_found").replace("%langs%", langList);
            sender.sendMessage(message);
        }
        return true;
    }

    private List<String> getAvailableLanguages() {
        File[] langFiles;
        List<String> languages = new ArrayList<String>();
        File langDir = new File(this.plugin.getDataFolder(), "lang");
        if (langDir.exists() && langDir.isDirectory() && (langFiles = langDir.listFiles((dir, name) -> name.endsWith(".yml"))) != null) {
            languages = Arrays.stream(langFiles).map(file -> file.getName().replace(".yml", "")).collect(Collectors.toList());
        }
        return languages;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            StringUtil.copyPartialMatches((String)args[0], Arrays.asList("lang", "reload", "editor"), completions);
            return completions;
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("lang")) {
            StringUtil.copyPartialMatches((String)args[1], this.getAvailableLanguages(), completions);
            return completions;
        }
        return completions;
    }
}

