/*
 * Decompiled with CFR 0.152.
 */
package org.little100.super_Farming;

import java.io.File;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.little100.super_Farming.command.CommandManager;
import org.little100.super_Farming.data.DatabaseManager;
import org.little100.super_Farming.farm.FarmManager;
import org.little100.super_Farming.gui.GuiManager;
import org.little100.super_Farming.item.ItemManager;
import org.little100.super_Farming.language.LanguageManager;
import org.little100.super_Farming.listener.AnvilListener;
import org.little100.super_Farming.listener.CraftingListener;
import org.little100.super_Farming.listener.FarmListener;
import org.little100.super_Farming.listener.GuiListener;
import org.little100.super_Farming.listener.GuiSaveListener;
import org.little100.super_Farming.listener.PlayerListener;
import org.little100.super_Farming.recipe.RecipeManager;

public final class Super_Farming
extends JavaPlugin {
    private static Super_Farming plugin;
    private GuiManager guiManager;
    private LanguageManager languageManager;
    private DatabaseManager databaseManager;
    private FarmManager farmManager;
    private static boolean isFolia;

    public void onEnable() {
        plugin = this;
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            isFolia = true;
            this.getLogger().info("Folia detected. Enabling Folia-specific features.");
        }
        catch (ClassNotFoundException e) {
            isFolia = false;
            this.getLogger().info("Folia not detected. Running in standard Bukkit/Paper mode.");
        }
        this.saveDefaultConfig();
        this.databaseManager = new DatabaseManager(this.getDataFolder());
        this.saveDefaultGuiConfig();
        this.languageManager = new LanguageManager(this);
        this.guiManager = new GuiManager(this, this.languageManager);
        ItemManager.init();
        RecipeManager.init();
        this.getServer().getPluginManager().registerEvents((Listener)new AnvilListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this, this.guiManager), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new CraftingListener(this), (Plugin)this);
        this.farmManager = new FarmManager(this, this.databaseManager);
        this.farmManager.loadFarms();
        this.getServer().getPluginManager().registerEvents((Listener)new GuiListener(this.guiManager, this.languageManager, this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new GuiSaveListener(this.guiManager), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new FarmListener(this, this.farmManager), (Plugin)this);
        CommandManager commandManager = new CommandManager(this);
        this.getCommand("super_farming").setExecutor((CommandExecutor)commandManager);
        this.getCommand("super_farming").setTabCompleter((TabCompleter)commandManager);
    }

    private void saveDefaultGuiConfig() {
        File guiFile = new File(this.getDataFolder(), "gui.yml");
        if (!guiFile.exists()) {
            this.saveResource("gui.yml", false);
        }
    }

    public void onDisable() {
        if (this.farmManager != null) {
            this.farmManager.unloadFarms();
        }
    }

    public void reload() {
        this.reloadConfig();
        if (this.farmManager != null) {
            this.farmManager.unloadFarms();
        }
        this.farmManager = new FarmManager(this, this.databaseManager);
        this.farmManager.loadFarms();
        if (this.languageManager != null) {
            this.languageManager.reloadLanguages();
        }
    }

    public static boolean isFolia() {
        return isFolia;
    }

    public static Super_Farming getPlugin() {
        return plugin;
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    public GuiManager getGuiManager() {
        return this.guiManager;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public FarmManager getFarmManager() {
        return this.farmManager;
    }

    public boolean isDebugEnabled() {
        return this.getConfig().getBoolean("debug.enabled", false);
    }

    public boolean isCraftingDebugEnabled() {
        return this.getConfig().getBoolean("debug.crafting", false);
    }
}

