/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.util;

import org.Little_100.projecte.ProjectE;
import org.bukkit.block.ShulkerBox;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;

public class ShulkerBoxUtil {
    public static ItemStack getFirstItemWithoutEmc(ItemStack shulkerBoxItem) {
        if (shulkerBoxItem == null || !(shulkerBoxItem.getItemMeta() instanceof BlockStateMeta)) {
            return null;
        }
        BlockStateMeta bsm = (BlockStateMeta)shulkerBoxItem.getItemMeta();
        if (!(bsm.getBlockState() instanceof ShulkerBox)) {
            return null;
        }
        ShulkerBox shulkerBox = (ShulkerBox)bsm.getBlockState();
        for (ItemStack item : shulkerBox.getInventory().getContents()) {
            long emc;
            if (item == null || item.getType().isAir() || (emc = ProjectE.getInstance().getEmcManager().getEmc(item)) > 0L) continue;
            return item;
        }
        return null;
    }

    public static long getTotalEmcOfContents(ItemStack shulkerBoxItem) {
        if (shulkerBoxItem == null || !(shulkerBoxItem.getItemMeta() instanceof BlockStateMeta)) {
            return 0L;
        }
        BlockStateMeta bsm = (BlockStateMeta)shulkerBoxItem.getItemMeta();
        if (!(bsm.getBlockState() instanceof ShulkerBox)) {
            return 0L;
        }
        long totalEmc = 0L;
        ShulkerBox shulkerBox = (ShulkerBox)bsm.getBlockState();
        for (ItemStack item : shulkerBox.getInventory().getContents()) {
            if (item == null || item.getType().isAir()) continue;
            totalEmc += ProjectE.getInstance().getEmcManager().getEmc(item) * (long)item.getAmount();
        }
        return totalEmc;
    }
}

