/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.Little_100.projecte.ProjectE;
import org.bukkit.Bukkit;
import org.bukkit.Material;

public class MaterialStackSizeModifier {
    private final ProjectE plugin;
    private boolean isSetupComplete = false;
    private String serverVersion;
    private Class<?> itemClass;
    private Class<?> itemsClass;
    private Method getItemNameMethod;
    private Field itemsComponentsField;
    private Field componentsMapField;
    private Method componentMapPutMethod;
    private Object maxStackSizeComponent;

    public MaterialStackSizeModifier(ProjectE plugin) {
        this.plugin = plugin;
        this.setup();
    }

    private void setup() {
        try {
            String packageVersion = Bukkit.getServer().getClass().getPackage().getName();
            this.serverVersion = packageVersion.substring(packageVersion.lastIndexOf(46) + 1);
            this.plugin.getLogger().info("\u68c0\u6d4b\u5230\u670d\u52a1\u5668\u7248\u672c: " + this.serverVersion + " (Bukkit: " + Bukkit.getBukkitVersion() + ")");
            this.setupReflectionClasses();
            this.isSetupComplete = true;
            this.plugin.getLogger().info("MaterialStackSizeModifier \u521d\u59cb\u5316\u6210\u529f\uff01");
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("MaterialStackSizeModifier \u521d\u59cb\u5316\u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void setupReflectionClasses() {
        try {
            String itemNameMethodName;
            Object itemsClassPath;
            Object itemClassPath;
            boolean isModern;
            boolean bl = isModern = !this.serverVersion.startsWith("v1_7") && !this.serverVersion.startsWith("v1_8") && !this.serverVersion.startsWith("v1_9") && !this.serverVersion.startsWith("v1_10") && !this.serverVersion.startsWith("v1_11") && !this.serverVersion.startsWith("v1_12") && !this.serverVersion.startsWith("v1_13") && !this.serverVersion.startsWith("v1_14") && !this.serverVersion.startsWith("v1_15") && !this.serverVersion.startsWith("v1_16");
            if (this.serverVersion.equalsIgnoreCase("craftbukkit") || isModern) {
                itemClassPath = "net.minecraft.world.item.Item";
                itemsClassPath = "net.minecraft.world.item.Items";
                itemNameMethodName = Bukkit.getBukkitVersion().startsWith("1.21.3") || Bukkit.getBukkitVersion().startsWith("1.21.4") ? "l" : (Bukkit.getBukkitVersion().startsWith("1.17") ? "getName" : "a");
            } else {
                itemClassPath = "net.minecraft.server." + this.serverVersion + ".Item";
                itemsClassPath = "net.minecraft.server." + this.serverVersion + ".Items";
                itemNameMethodName = "getName";
            }
            this.plugin.getLogger().info("\u5c1d\u8bd5\u52a0\u8f7d NMS \u7c7b: " + (String)itemClassPath);
            this.itemClass = Class.forName((String)itemClassPath);
            this.itemsClass = Class.forName((String)itemsClassPath);
            this.getItemNameMethod = this.itemClass.getMethod(itemNameMethodName, new Class[0]);
            this.plugin.getLogger().info("NMS \u7c7b\u52a0\u8f7d\u6210\u529f!");
            if (Bukkit.getBukkitVersion().startsWith("1.20.6") || Bukkit.getBukkitVersion().startsWith("1.21")) {
                this.plugin.getLogger().info("\u68c0\u6d4b\u5230 1.20.5+ \u7248\u672c\uff0c\u8bbe\u7f6e DataComponents...");
                this.setupDataComponents();
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("\u8bbe\u7f6e\u53cd\u5c04\u7c7b\u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void setupDataComponents() {
        try {
            Class<?> dataComponentsClass = Class.forName("net.minecraft.core.component.DataComponents");
            try {
                Field maxStackField = dataComponentsClass.getField("MAX_STACK_SIZE");
                this.maxStackSizeComponent = maxStackField.get(null);
            }
            catch (NoSuchFieldException e) {
                Field maxStackField = dataComponentsClass.getField("k");
                this.maxStackSizeComponent = maxStackField.get(null);
            }
            for (Field field : this.itemClass.getDeclaredFields()) {
                if (!field.getType().getSimpleName().contains("DataComponentMap")) continue;
                this.itemsComponentsField = field;
                this.itemsComponentsField.setAccessible(true);
                break;
            }
            if (this.itemsComponentsField != null && this.maxStackSizeComponent != null) {
                this.plugin.getLogger().info("DataComponents \u8bbe\u7f6e\u6210\u529f!");
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("\u8bbe\u7f6e DataComponents \u5931\u8d25: " + e.getMessage());
        }
    }

    public boolean setChorusFruitStackSize() {
        if (!this.isSetupComplete) {
            this.plugin.getLogger().warning("MaterialStackSizeModifier \u672a\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u5806\u53e0\u5927\u5c0f");
            return false;
        }
        Material material = this.plugin.getVersionAdapter().getMaterial("POPPED_CHORUS_FRUIT");
        if (material == null) {
            this.plugin.getLogger().warning("\u65e0\u6cd5\u627e\u5230 POPPED_CHORUS_FRUIT \u6750\u6599");
            return false;
        }
        boolean success = true;
        if (!this.setMaterialMaxStack(material, 1)) {
            this.plugin.getLogger().warning("\u4fee\u6539 Material.maxStack \u5931\u8d25");
            success = false;
        }
        if (!this.setNMSItemMaxStack("popped_chorus_fruit", 1)) {
            this.plugin.getLogger().warning("\u4fee\u6539 NMS Item \u5806\u53e0\u5927\u5c0f\u5931\u8d25");
            success = false;
        }
        if (success) {
            this.plugin.getLogger().info("\u00a7a\u6210\u529f\u5c06 POPPED_CHORUS_FRUIT \u7684\u5806\u53e0\u4e0a\u9650\u8bbe\u7f6e\u4e3a 1\uff01");
        }
        return success;
    }

    private boolean setMaterialMaxStack(Material material, int stackSize) {
        try {
            Field maxStackField = Material.class.getDeclaredField("maxStack");
            maxStackField.setAccessible(true);
            maxStackField.set(material, stackSize);
            maxStackField.setAccessible(false);
            this.plugin.getLogger().info("\u6210\u529f\u4fee\u6539 Material." + material.name() + ".maxStack = " + stackSize);
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("\u4fee\u6539 Material.maxStack \u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private boolean setNMSItemMaxStack(String itemName, int stackSize) {
        try {
            Field itemField = this.findItemField(itemName);
            if (itemField == null) {
                this.plugin.getLogger().warning("\u65e0\u6cd5\u627e\u5230 NMS Item \u5b57\u6bb5: " + itemName);
                return false;
            }
            Object nmsItem = itemField.get(null);
            if (nmsItem == null) {
                this.plugin.getLogger().warning("NMS Item \u4e3a null: " + itemName);
                return false;
            }
            if (this.maxStackSizeComponent != null && this.itemsComponentsField != null) {
                return this.setDataComponentMaxStack(nmsItem, stackSize, itemName);
            }
            return this.setItemFieldMaxStack(nmsItem, stackSize, itemName);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("\u8bbe\u7f6e NMS Item \u5806\u53e0\u5927\u5c0f\u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private Field findItemField(String itemName) {
        try {
            try {
                return this.itemsClass.getDeclaredField(itemName.toUpperCase());
            }
            catch (NoSuchFieldException noSuchFieldException) {
                for (Field field : this.itemsClass.getFields()) {
                    try {
                        String[] parts;
                        String shortName;
                        String name;
                        Object item = field.get(null);
                        if (item == null || (name = (String)this.getItemNameMethod.invoke(item, new Object[0])) == null || !(shortName = (parts = name.split("\\."))[parts.length - 1]).equals(itemName)) continue;
                        this.plugin.getLogger().info("\u627e\u5230 NMS Item \u5b57\u6bb5: " + field.getName() + " -> " + itemName);
                        return field;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("\u67e5\u627e Item \u5b57\u6bb5\u5931\u8d25: " + e.getMessage());
        }
        return null;
    }

    private boolean setDataComponentMaxStack(Object nmsItem, int stackSize, String itemName) {
        try {
            this.plugin.getLogger().info("\u4f7f\u7528 DataComponents \u65b9\u6cd5\u8bbe\u7f6e\u5806\u53e0\u5927\u5c0f");
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("\u8bbe\u7f6e DataComponent \u5931\u8d25: " + e.getMessage());
            return false;
        }
    }

    private boolean setItemFieldMaxStack(Object nmsItem, int stackSize, String itemName) {
        try {
            String[] possibleFieldNames;
            for (String fieldName : possibleFieldNames = new String[]{"maxStackSize", "c", "d"}) {
                try {
                    Field field = this.itemClass.getDeclaredField(fieldName);
                    field.setAccessible(true);
                    field.set(nmsItem, stackSize);
                    field.setAccessible(false);
                    this.plugin.getLogger().info("\u6210\u529f\u4fee\u6539 NMS Item." + itemName + "." + fieldName + " = " + stackSize);
                    return true;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
            }
            this.plugin.getLogger().warning("\u65e0\u6cd5\u627e\u5230 NMS Item \u7684\u5806\u53e0\u5927\u5c0f\u5b57\u6bb5");
            return false;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("\u4fee\u6539 NMS Item \u5b57\u6bb5\u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }
}

