/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.managers;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.Little_100.projecte.ProjectE;

public class SearchLanguageManager {
    private final ProjectE plugin;
    private Map<String, String> idToNameMap = new HashMap<String, String>();
    private Map<String, String> nameToIdMap = new HashMap<String, String>();
    private final Map<String, Map<String, String>> searchCache = new ConcurrentHashMap<String, Map<String, String>>();
    private final Map<String, Map<String, String>> keywordIndex = new HashMap<String, Map<String, String>>();

    public SearchLanguageManager(ProjectE plugin) {
        this.plugin = plugin;
        this.loadSearchLanguageFile();
    }

    public void loadSearchLanguageFile() {
        this.idToNameMap.clear();
        this.nameToIdMap.clear();
        this.searchCache.clear();
        this.keywordIndex.clear();
        String fileName = "searchlang/zh_cn.json";
        File langFile = new File(this.plugin.getDataFolder(), fileName);
        if (!langFile.exists()) {
            File parent = langFile.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            this.plugin.saveResource(fileName, false);
        }
        try (FileReader reader = new FileReader(langFile, StandardCharsets.UTF_8);){
            Gson gson = new Gson();
            Type type = new TypeToken<Map<String, String>>(this){}.getType();
            this.idToNameMap = (Map)gson.fromJson((Reader)reader, type);
            for (Map.Entry<String, String> entry : this.idToNameMap.entrySet()) {
                this.nameToIdMap.put(entry.getValue(), entry.getKey());
            }
            this.buildKeywordIndex();
            this.plugin.getLogger().info("\u6210\u529f\u52a0\u8f7d " + this.idToNameMap.size() + " \u4e2a\u7269\u54c1\u540d\u79f0\u6620\u5c04");
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "\u65e0\u6cd5\u52a0\u8f7d\u641c\u7d22\u8bed\u8a00\u6587\u4ef6: " + fileName, e);
        }
    }

    private void buildKeywordIndex() {
        Map<String, String> commonTerms = this.findCommonTerms();
        for (Map.Entry<String, String> term : commonTerms.entrySet()) {
            String chineseTerm = term.getKey();
            String englishTerm = term.getValue();
            HashMap<String, String> matchingItems = new HashMap<String, String>();
            for (Map.Entry<String, String> item : this.idToNameMap.entrySet()) {
                String itemId = item.getKey();
                String itemName = item.getValue();
                if (!itemId.toLowerCase().contains(englishTerm) && (itemName == null || !itemName.toLowerCase().contains(chineseTerm))) continue;
                matchingItems.put(itemId, itemName);
            }
            if (matchingItems.isEmpty()) continue;
            this.keywordIndex.put(chineseTerm, matchingItems);
            this.keywordIndex.put(englishTerm, matchingItems);
        }
        this.plugin.getLogger().info("\u5df2\u6784\u5efa " + this.keywordIndex.size() + " \u4e2a\u5173\u952e\u8bcd\u7d22\u5f15");
    }

    public String getLocalizedName(String itemId) {
        return this.idToNameMap.getOrDefault(itemId, itemId);
    }

    public Map<String, String> findMatchingIds(String searchTerm) {
        if (searchTerm == null || searchTerm.trim().isEmpty()) {
            return new HashMap<String, String>();
        }
        String lowerSearchTerm = searchTerm.toLowerCase().trim();
        if (this.searchCache.containsKey(lowerSearchTerm)) {
            return this.searchCache.get(lowerSearchTerm);
        }
        Map<Object, Object> results = new HashMap();
        if (this.keywordIndex.containsKey(lowerSearchTerm)) {
            results = this.keywordIndex.get(lowerSearchTerm);
            this.searchCache.put(lowerSearchTerm, results);
            return results;
        }
        for (String keyword : this.keywordIndex.keySet()) {
            if (!keyword.contains(lowerSearchTerm) && !lowerSearchTerm.contains(keyword)) continue;
            results.putAll(this.keywordIndex.get(keyword));
            if (results.size() <= 100) continue;
            break;
        }
        if (results.size() > 20) {
            this.searchCache.put(lowerSearchTerm, results);
            return results;
        }
        int count = 0;
        for (Map.Entry<String, String> entry : this.idToNameMap.entrySet()) {
            if (entry.getValue().toLowerCase().contains(lowerSearchTerm)) {
                results.put(entry.getKey(), entry.getValue());
            }
            if (++count <= 500) continue;
            break;
        }
        if (results.size() < 20) {
            count = 0;
            for (String id : this.idToNameMap.keySet()) {
                String simplifiedId = id.replaceAll("(item|block)\\.minecraft\\.", "");
                if (simplifiedId.toLowerCase().contains(lowerSearchTerm)) {
                    results.put(id, this.idToNameMap.get(id));
                }
                if (++count <= 500) continue;
                break;
            }
        }
        this.searchCache.put(lowerSearchTerm, results);
        return results;
    }

    public boolean matches(String searchTerm, String itemId) {
        if (searchTerm == null || searchTerm.isEmpty() || itemId == null || itemId.isEmpty()) {
            return false;
        }
        String lowerSearchTerm = searchTerm.toLowerCase();
        String localizedName = this.idToNameMap.get(itemId);
        if (localizedName != null && localizedName.toLowerCase().contains(lowerSearchTerm)) {
            return true;
        }
        String simplifiedId = itemId.replaceAll("(item|block)\\.minecraft\\.", "");
        if (simplifiedId.toLowerCase().contains(lowerSearchTerm)) {
            return true;
        }
        Map<String, String> commonTerms = this.findCommonTerms();
        for (Map.Entry<String, String> entry : commonTerms.entrySet()) {
            if (!lowerSearchTerm.contains(entry.getKey())) continue;
            if (itemId.toLowerCase().contains(entry.getValue())) {
                return true;
            }
            if (localizedName == null || !localizedName.toLowerCase().contains(entry.getKey())) continue;
            return true;
        }
        for (Map.Entry<String, String> entry : commonTerms.entrySet()) {
            if (!lowerSearchTerm.contains(entry.getValue()) || !itemId.toLowerCase().contains(entry.getValue())) continue;
            return true;
        }
        if (lowerSearchTerm.length() > 1) {
            for (int i = 1; i < lowerSearchTerm.length(); ++i) {
                String firstPart = lowerSearchTerm.substring(0, i);
                String secondPart = lowerSearchTerm.substring(i);
                String firstPartEnglish = null;
                String secondPartEnglish = null;
                for (Map.Entry<String, String> entry : commonTerms.entrySet()) {
                    if (!firstPart.equals(entry.getKey())) continue;
                    firstPartEnglish = entry.getValue();
                    break;
                }
                for (Map.Entry<String, String> entry : commonTerms.entrySet()) {
                    if (!secondPart.equals(entry.getKey())) continue;
                    secondPartEnglish = entry.getValue();
                    break;
                }
                if (firstPartEnglish == null || secondPartEnglish == null || !itemId.toLowerCase().contains(firstPartEnglish) || !itemId.toLowerCase().contains(secondPartEnglish)) continue;
                return true;
            }
        }
        return false;
    }

    private Map<String, String> findCommonTerms() {
        HashMap<String, String> commonTerms = new HashMap<String, String>();
        commonTerms.put("\u94c1", "iron");
        commonTerms.put("\u91d1", "gold");
        commonTerms.put("\u94bb\u77f3", "diamond");
        commonTerms.put("\u6728", "wood");
        commonTerms.put("\u77f3", "stone");
        commonTerms.put("\u7164", "coal");
        commonTerms.put("\u9752\u91d1\u77f3", "lapis");
        commonTerms.put("\u7ea2\u77f3", "redstone");
        commonTerms.put("\u7eff\u5b9d\u77f3", "emerald");
        commonTerms.put("\u4e0b\u754c", "nether");
        commonTerms.put("\u672b\u5730", "end");
        commonTerms.put("\u94dc", "copper");
        commonTerms.put("\u82d4\u77f3", "mossy");
        commonTerms.put("\u7f8a\u6bdb", "wool");
        commonTerms.put("\u67d3\u8272", "stained");
        commonTerms.put("\u73bb\u7483", "glass");
        commonTerms.put("\u9676\u74e6", "terracotta");
        commonTerms.put("\u6df7\u51dd\u571f", "concrete");
        commonTerms.put("\u5730\u6bef", "carpet");
        commonTerms.put("\u6c99\u5b50", "sand");
        commonTerms.put("\u6c99\u783e", "gravel");
        commonTerms.put("\u9ecf\u571f", "clay");
        commonTerms.put("\u6d77\u7ef5", "sponge");
        commonTerms.put("\u96ea", "snow");
        commonTerms.put("\u51b0", "ice");
        commonTerms.put("\u5357\u74dc", "pumpkin");
        commonTerms.put("\u897f\u74dc", "melon");
        commonTerms.put("\u5251", "sword");
        commonTerms.put("\u65a7", "axe");
        commonTerms.put("\u9550", "pickaxe");
        commonTerms.put("\u9504", "hoe");
        commonTerms.put("\u9539", "shovel");
        commonTerms.put("\u5934\u76d4", "helmet");
        commonTerms.put("\u80f8\u7532", "chestplate");
        commonTerms.put("\u62a4\u817f", "leggings");
        commonTerms.put("\u9774\u5b50", "boots");
        commonTerms.put("\u79cd\u5b50", "seeds");
        commonTerms.put("\u6811\u82d7", "sapling");
        commonTerms.put("\u82b1", "flower");
        commonTerms.put("\u77ff\u77f3", "ore");
        commonTerms.put("\u6876", "bucket");
        commonTerms.put("\u7bb1\u5b50", "chest");
        commonTerms.put("\u5e8a", "bed");
        return commonTerms;
    }
}

