/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.listeners;

import java.util.logging.Level;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.gui.TransmutationGUI;
import org.Little_100.projecte.util.Constants;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

public class TransmutationTabletBookListener
implements Listener {
    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() == Action.RIGHT_CLICK_AIR || event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            Player player = event.getPlayer();
            ItemStack item = event.getItem();
            if (this.isTransmutationTabletBook(item)) {
                try {
                    new TransmutationGUI(player).open();
                    event.setCancelled(true);
                }
                catch (Exception e) {
                    ProjectE.getInstance().getLogger().log(Level.WARNING, "\u6253\u5f00\u8f6c\u6362\u5de5\u5177GUI\u65f6\u5931\u8d25", e);
                }
            }
        }
    }

    @EventHandler
    public void onPrepareAnvil(PrepareAnvilEvent event) {
        ItemStack first = event.getInventory().getItem(0);
        ItemStack second = event.getInventory().getItem(1);
        if (this.isTransmutationTabletBook(first) || this.isTransmutationTabletBook(second)) {
            event.setResult(null);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getInventory().getType() == InventoryType.GRINDSTONE) {
            ItemStack first = event.getInventory().getItem(0);
            ItemStack second = event.getInventory().getItem(1);
            if (this.isTransmutationTabletBook(first) || this.isTransmutationTabletBook(second)) {
                event.setCancelled(true);
            }
        }
    }

    private boolean isTransmutationTabletBook(ItemStack item) {
        if (item == null || item.getType() != Material.ENCHANTED_BOOK) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        if (meta.getPersistentDataContainer().has(Constants.ID_KEY, PersistentDataType.STRING)) {
            String id = (String)meta.getPersistentDataContainer().get(Constants.ID_KEY, PersistentDataType.STRING);
            return "transmutation_tablet_book".equals(id);
        }
        return false;
    }
}

