/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.listeners;

import java.util.HashMap;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.util.Constants;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;

public class CovalenceDustCraftListener
implements Listener {
    private final ProjectE plugin;

    public CovalenceDustCraftListener(ProjectE plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onCraftItem(InventoryClickEvent event) {
        if (event.isCancelled()) {
            if (this.plugin.getConfig().getBoolean("debug")) {
                this.plugin.getLogger().info("[CovalenceDustCraftListener Debug] \u4e8b\u4ef6\u5df2\u88ab\u53d6\u6d88\uff0c\u8df3\u8fc7\u5904\u7406");
            }
            return;
        }
        if (this.plugin.getConfig().getBoolean("debug")) {
            this.plugin.getLogger().info("[CovalenceDustCraftListener Debug] \u76d1\u542c\u5668\u88ab\u89e6\u53d1");
        }
        if (event.getSlotType() != InventoryType.SlotType.RESULT) {
            return;
        }
        if (!(event.getInventory() instanceof CraftingInventory)) {
            return;
        }
        CraftingInventory inv = (CraftingInventory)event.getInventory();
        ItemStack result = inv.getResult();
        if (!this.isCovalenceDust(result)) {
            if (this.plugin.getConfig().getBoolean("debug")) {
                this.plugin.getLogger().info("[CovalenceDustCraftListener Debug] \u4e0d\u662f\u5171\u4ef7\u7c89\u914d\u65b9\uff0c\u8df3\u8fc7\u5904\u7406");
            }
            return;
        }
        if (this.plugin.getConfig().getBoolean("debug")) {
            this.plugin.getLogger().info("[CovalenceDustCraftListener Debug] \u53d1\u73b0\u5171\u4ef7\u7c89\u914d\u65b9\uff0c\u5f00\u59cb\u5904\u7406");
        }
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        if (event.isShiftClick()) {
            this.handleShiftClick(player, inv, result);
        } else {
            this.handleNormalClick(player, inv, result);
        }
    }

    private void handleShiftClick(Player player, CraftingInventory inv, ItemStack result) {
        int numCrafted;
        int maxCrafts = this.calculateMaxCrafts(inv);
        if (maxCrafts <= 0) {
            return;
        }
        ItemStack resultStack = result.clone();
        resultStack.setAmount(result.getAmount() * maxCrafts);
        HashMap leftovers = player.getInventory().addItem(new ItemStack[]{resultStack});
        int craftedAmount = resultStack.getAmount();
        if (!leftovers.isEmpty()) {
            craftedAmount -= leftovers.values().stream().mapToInt(ItemStack::getAmount).sum();
        }
        if ((numCrafted = craftedAmount / result.getAmount()) > 0) {
            this.consumeIngredients(inv, numCrafted);
        }
    }

    private void handleNormalClick(Player player, CraftingInventory inv, ItemStack result) {
        int canAdd;
        ItemStack cursorItem = player.getItemOnCursor();
        if (cursorItem.getType() == Material.AIR) {
            this.consumeIngredients(inv, 1);
            player.setItemOnCursor(result);
        } else if (cursorItem.isSimilar(result) && (canAdd = result.getMaxStackSize() - cursorItem.getAmount()) >= result.getAmount()) {
            this.consumeIngredients(inv, 1);
            cursorItem.setAmount(cursorItem.getAmount() + result.getAmount());
            player.setItemOnCursor(cursorItem);
        }
    }

    private int calculateMaxCrafts(CraftingInventory inv) {
        int maxCrafts = Integer.MAX_VALUE;
        for (ItemStack item : inv.getMatrix()) {
            if (item == null || item.getType() == Material.AIR) continue;
            maxCrafts = Math.min(maxCrafts, item.getAmount());
        }
        return maxCrafts == Integer.MAX_VALUE ? 0 : maxCrafts;
    }

    private void consumeIngredients(CraftingInventory inv, int numCrafts) {
        ItemStack[] matrix = inv.getMatrix();
        for (int i = 0; i < matrix.length; ++i) {
            ItemStack item = matrix[i];
            if (item == null || item.getType() == Material.AIR) continue;
            item.setAmount(item.getAmount() - numCrafts);
            if (item.getAmount() > 0) continue;
            matrix[i] = null;
        }
        inv.setMatrix(matrix);
    }

    private boolean isCovalenceDust(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        String id = (String)item.getItemMeta().getPersistentDataContainer().get(Constants.ID_KEY, PersistentDataType.STRING);
        return "low_covalence_dust".equals(id) || "medium_covalence_dust".equals(id) || "high_covalence_dust".equals(id);
    }
}

