/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.devices;

import java.util.ArrayList;
import org.Little_100.projecte.ProjectE;
import org.Little_100.projecte.util.CustomModelDataUtil;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class EnergyCollector
implements Listener {
    public static final NamespacedKey KEY_MK1 = new NamespacedKey((Plugin)ProjectE.getInstance(), "energy_collector_mk1");
    public static final NamespacedKey KEY_MK2 = new NamespacedKey((Plugin)ProjectE.getInstance(), "energy_collector_mk2");
    public static final NamespacedKey KEY_MK3 = new NamespacedKey((Plugin)ProjectE.getInstance(), "energy_collector_mk3");
    private final ProjectE plugin;
    public static final int TYPE_MK1 = 1;
    public static final int TYPE_MK2 = 2;
    public static final int TYPE_MK3 = 3;
    public static final long EMC_RATE_MK1 = 4L;
    public static final long EMC_RATE_MK2 = 10L;
    public static final long EMC_RATE_MK3 = 40L;
    public static final int INV_SIZE_MK1 = 4;
    public static final int INV_SIZE_MK2 = 8;
    public static final int INV_SIZE_MK3 = 12;

    public EnergyCollector(ProjectE plugin) {
        this.plugin = plugin;
    }

    public ItemStack getCollectorItem(int type) {
        int customModelData;
        NamespacedKey key;
        String name;
        ItemStack item = new ItemStack(Material.GLOWSTONE);
        ItemMeta meta = item.getItemMeta();
        ArrayList<String> lore = new ArrayList<String>();
        switch (type) {
            case 1: {
                name = this.plugin.getLanguageManager().get("item.projecte.energy_collector_mk1.name");
                lore.add(this.plugin.getLanguageManager().get("item.projecte.energy_collector_mk1.lore1"));
                lore.add(this.plugin.getLanguageManager().get("item.projecte.energy_collector_mk1.lore2"));
                key = KEY_MK1;
                customModelData = 1;
                break;
            }
            case 2: {
                name = this.plugin.getLanguageManager().get("item.projecte.energy_collector_mk2.name");
                lore.add(this.plugin.getLanguageManager().get("item.projecte.energy_collector_mk2.lore1"));
                lore.add(this.plugin.getLanguageManager().get("item.projecte.energy_collector_mk2.lore2"));
                key = KEY_MK2;
                customModelData = 2;
                break;
            }
            case 3: {
                name = this.plugin.getLanguageManager().get("item.projecte.energy_collector_mk3.name");
                lore.add(this.plugin.getLanguageManager().get("item.projecte.energy_collector_mk3.lore1"));
                lore.add(this.plugin.getLanguageManager().get("item.projecte.energy_collector_mk3.lore2"));
                key = KEY_MK3;
                customModelData = 3;
                break;
            }
            default: {
                return null;
            }
        }
        meta.setDisplayName(name);
        meta.setLore(lore);
        item.setItemMeta(meta);
        item = CustomModelDataUtil.setCustomModelData(item, customModelData);
        ItemMeta newMeta = item.getItemMeta();
        newMeta.getPersistentDataContainer().set(key, PersistentDataType.BYTE, (Object)1);
        item.setItemMeta(newMeta);
        return item;
    }

    public boolean isCollector(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        return meta.getPersistentDataContainer().has(KEY_MK1, PersistentDataType.BYTE) || meta.getPersistentDataContainer().has(KEY_MK2, PersistentDataType.BYTE) || meta.getPersistentDataContainer().has(KEY_MK3, PersistentDataType.BYTE);
    }

    public int getCollectorType(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return 0;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta.getPersistentDataContainer().has(KEY_MK1, PersistentDataType.BYTE)) {
            return 1;
        }
        if (meta.getPersistentDataContainer().has(KEY_MK2, PersistentDataType.BYTE)) {
            return 2;
        }
        if (meta.getPersistentDataContainer().has(KEY_MK3, PersistentDataType.BYTE)) {
            return 3;
        }
        return 0;
    }

    public static long getEmcRate(int type) {
        switch (type) {
            case 1: {
                return 4L;
            }
            case 2: {
                return 10L;
            }
            case 3: {
                return 40L;
            }
        }
        return 0L;
    }

    public static int getInventorySize(int type) {
        switch (type) {
            case 1: {
                return 4;
            }
            case 2: {
                return 8;
            }
            case 3: {
                return 12;
            }
        }
        return 0;
    }

    public static NamespacedKey getKey(int type) {
        switch (type) {
            case 1: {
                return KEY_MK1;
            }
            case 2: {
                return KEY_MK2;
            }
            case 3: {
                return KEY_MK3;
            }
        }
        return null;
    }
}

