/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.devices;

import java.util.Iterator;
import org.Little_100.projecte.ProjectE;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class AlchemicalChestGUI
implements Listener {
    private final ProjectE plugin;
    private final Player player;
    private final Location chestLocation;
    private final ItemStack[] allContents;
    private int currentPage = 0;
    private Inventory inventory;
    private static final int TOTAL_SLOTS = 104;
    private static final int PAGE_SIZE = 45;
    private static final int TOTAL_PAGES = 3;
    private static final int PREV_PAGE_SLOT = 45;
    private static final int PAGE_INFO_SLOT = 49;
    private static final int NEXT_PAGE_SLOT = 53;

    public AlchemicalChestGUI(ProjectE plugin, Player player, Location location, ItemStack[] contents) {
        this.plugin = plugin;
        this.player = player;
        this.chestLocation = location;
        this.allContents = contents != null && contents.length == 104 ? contents : new ItemStack[104];
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void open() {
        this.openPage(0);
    }

    private void openPage(int page) {
        int i;
        this.currentPage = page;
        String title = this.plugin.getLanguageManager().get("gui.alchemical_chest.title").replace("%page%", String.valueOf(page + 1)).replace("%total%", String.valueOf(3));
        this.inventory = Bukkit.createInventory(null, (int)54, (String)title);
        int startIndex = page * 45;
        int itemsOnThisPage = Math.min(45, 104 - startIndex);
        for (int i2 = 0; i2 < itemsOnThisPage; ++i2) {
            int contentIndex = startIndex + i2;
            if (contentIndex >= this.allContents.length || this.allContents[contentIndex] == null) continue;
            this.inventory.setItem(i2, this.allContents[contentIndex]);
        }
        ItemStack glassPane = this.createGlassPane();
        for (i = itemsOnThisPage; i < 45; ++i) {
            this.inventory.setItem(i, glassPane);
        }
        for (i = 45; i < 54; ++i) {
            this.inventory.setItem(i, glassPane);
        }
        if (this.currentPage > 0) {
            this.inventory.setItem(45, this.createControlButton(Material.ARROW, this.plugin.getLanguageManager().get("gui.alchemical_chest.prev_page")));
        }
        this.inventory.setItem(49, this.createControlButton(Material.PAPER, this.plugin.getLanguageManager().get("gui.alchemical_chest.page_info").replace("%page%", String.valueOf(page + 1)).replace("%total%", String.valueOf(3))));
        if (this.currentPage < 2) {
            this.inventory.setItem(53, this.createControlButton(Material.ARROW, this.plugin.getLanguageManager().get("gui.alchemical_chest.next_page")));
        }
        this.player.openInventory(this.inventory);
    }

    private ItemStack createControlButton(Material material, String name) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createGlassPane() {
        ItemStack glassPane = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta meta = glassPane.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(" ");
            glassPane.setItemMeta(meta);
        }
        return glassPane;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        if (!event.getWhoClicked().equals((Object)this.player)) {
            return;
        }
        if (event.getInventory() != this.inventory) {
            return;
        }
        int slot = event.getRawSlot();
        if (slot < 0 || slot >= 54) {
            return;
        }
        int startIndex = this.currentPage * 45;
        int itemsOnThisPage = Math.min(45, 104 - startIndex);
        if (slot >= itemsOnThisPage && slot < 45) {
            event.setCancelled(true);
            return;
        }
        if (slot >= 45) {
            event.setCancelled(true);
            if (slot == 45 && this.currentPage > 0) {
                this.saveCurrentPage();
                this.openPage(this.currentPage - 1);
            } else if (slot == 53 && this.currentPage < 2) {
                this.saveCurrentPage();
                this.openPage(this.currentPage + 1);
            }
            return;
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        if (!event.getWhoClicked().equals((Object)this.player)) {
            return;
        }
        if (event.getInventory() != this.inventory) {
            return;
        }
        int startIndex = this.currentPage * 45;
        int itemsOnThisPage = Math.min(45, 104 - startIndex);
        Iterator iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            if (slot < 0 || slot >= 54) continue;
            if (slot >= itemsOnThisPage && slot < 45) {
                event.setCancelled(true);
                return;
            }
            if (slot < 45 || slot >= 54) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        if (!event.getPlayer().equals((Object)this.player)) {
            return;
        }
        if (event.getInventory() != this.inventory) {
            return;
        }
        this.saveCurrentPage();
        this.plugin.getAlchemicalChestManager().closeChestGUI(this.player, this.allContents);
        InventoryClickEvent.getHandlerList().unregister((Listener)this);
        InventoryCloseEvent.getHandlerList().unregister((Listener)this);
        InventoryDragEvent.getHandlerList().unregister((Listener)this);
    }

    private void saveCurrentPage() {
        int startIndex = this.currentPage * 45;
        int itemsOnThisPage = Math.min(45, 104 - startIndex);
        for (int i = 0; i < itemsOnThisPage; ++i) {
            int contentIndex = startIndex + i;
            if (contentIndex >= this.allContents.length) continue;
            this.allContents[contentIndex] = this.inventory.getItem(i);
        }
    }
}

