/*
 * Decompiled with CFR 0.152.
 */
package org.Little_100.projecte.compatibility.scheduler;

import java.lang.reflect.Method;
import java.util.function.Consumer;
import org.Little_100.projecte.compatibility.scheduler.SchedulerAdapter;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class FoliaSchedulerAdapter
implements SchedulerAdapter {
    private final JavaPlugin plugin;

    FoliaSchedulerAdapter(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    private Method findMethodByNameAndParamCount(Class<?> clazz, String name, int paramCount) throws NoSuchMethodException {
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(name) || method.getParameterCount() != paramCount) continue;
            return method;
        }
        throw new NoSuchMethodException("Could not find method " + name + " with " + paramCount + " parameters on class " + clazz.getName());
    }

    @Override
    public void runTask(Runnable task) {
        try {
            Method getGlobalRegionScheduler = Bukkit.class.getMethod("getGlobalRegionScheduler", new Class[0]);
            Object scheduler = getGlobalRegionScheduler.invoke(null, new Object[0]);
            Method execute = this.findMethodByNameAndParamCount(scheduler.getClass(), "execute", 2);
            execute.invoke(scheduler, this.plugin, task);
        }
        catch (Exception e) {
            throw new RuntimeException("Folia scheduler reflection failed for runTask", e);
        }
    }

    @Override
    public void runTaskAsynchronously(Runnable task) {
        try {
            Method getAsyncScheduler = Bukkit.class.getMethod("getAsyncScheduler", new Class[0]);
            Object scheduler = getAsyncScheduler.invoke(null, new Object[0]);
            Method runNow = this.findMethodByNameAndParamCount(scheduler.getClass(), "runNow", 2);
            runNow.invoke(scheduler, this.plugin, scheduledTask -> task.run());
        }
        catch (Exception e) {
            throw new RuntimeException("Folia scheduler reflection failed for runTaskAsynchronously", e);
        }
    }

    @Override
    public void runTaskLater(Runnable task, long delay) {
        try {
            Method getGlobalRegionScheduler = Bukkit.class.getMethod("getGlobalRegionScheduler", new Class[0]);
            Object scheduler = getGlobalRegionScheduler.invoke(null, new Object[0]);
            Method runDelayed = this.findMethodByNameAndParamCount(scheduler.getClass(), "runDelayed", 3);
            runDelayed.invoke(scheduler, this.plugin, scheduledTask -> task.run(), delay);
        }
        catch (Exception e) {
            throw new RuntimeException("Folia scheduler reflection failed for runTaskLater", e);
        }
    }

    @Override
    public void runTaskAt(Location location, Runnable task) {
        try {
            Method getRegionScheduler = Bukkit.class.getMethod("getRegionScheduler", new Class[0]);
            Object scheduler = getRegionScheduler.invoke(null, new Object[0]);
            Method execute = this.findMethodByNameAndParamCount(scheduler.getClass(), "execute", 3);
            execute.invoke(scheduler, this.plugin, location, task);
        }
        catch (Exception e) {
            throw new RuntimeException("Folia scheduler reflection failed for runTaskAt", e);
        }
    }

    @Override
    public void runTaskOnEntity(Entity entity, Runnable task) {
        try {
            Method getScheduler = Entity.class.getMethod("getScheduler", new Class[0]);
            Object scheduler = getScheduler.invoke((Object)entity, new Object[0]);
            Method run = this.findMethodByNameAndParamCount(scheduler.getClass(), "run", 3);
            run.invoke(scheduler, this.plugin, scheduledTask -> task.run(), null);
        }
        catch (Exception e) {
            throw new RuntimeException("Folia scheduler reflection failed for runTaskOnEntity", e);
        }
    }

    @Override
    public void runTimer(Runnable task, long delay, long period) {
        try {
            Method getGlobalRegionScheduler = Bukkit.class.getMethod("getGlobalRegionScheduler", new Class[0]);
            Object scheduler = getGlobalRegionScheduler.invoke(null, new Object[0]);
            Method runAtFixedRate = this.findMethodByNameAndParamCount(scheduler.getClass(), "runAtFixedRate", 4);
            long foliaDelay = Math.max(1L, delay);
            runAtFixedRate.invoke(scheduler, this.plugin, scheduledTask -> task.run(), foliaDelay, period);
        }
        catch (Exception e) {
            throw new RuntimeException("Folia scheduler reflection failed for runTimer", e);
        }
    }

    @Override
    public void runTaskLaterAtLocation(Location location, Runnable task, long delay) {
        try {
            Method getRegionScheduler = Bukkit.class.getMethod("getRegionScheduler", new Class[0]);
            Object scheduler = getRegionScheduler.invoke(null, new Object[0]);
            Method runDelayed = this.findMethodByNameAndParamCount(scheduler.getClass(), "runDelayed", 4);
            runDelayed.invoke(scheduler, this.plugin, location, scheduledTask -> task.run(), delay);
        }
        catch (Exception e) {
            throw new RuntimeException("Folia scheduler reflection failed for runTaskLaterAtLocation", e);
        }
    }

    @Override
    public void runTaskLaterOnEntity(Entity entity, Runnable task, long delay) {
        try {
            Method getScheduler = Entity.class.getMethod("getScheduler", new Class[0]);
            Object scheduler = getScheduler.invoke((Object)entity, new Object[0]);
            Method runDelayed = scheduler.getClass().getMethod("runDelayed", Plugin.class, Consumer.class, Runnable.class, Long.TYPE);
            runDelayed.invoke(scheduler, this.plugin, scheduledTask -> task.run(), null, delay);
        }
        catch (Exception e) {
            throw new RuntimeException("Folia scheduler reflection failed for runTaskLaterOnEntity", e);
        }
    }
}

