/*
 * Decompiled with CFR 0.152.
 */
package org.little100.constructionWand.wand;

import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.little100.constructionWand.i18n.I18nManager;
import org.little100.constructionWand.utils.VersionHelper;
import org.little100.constructionWand.wand.WandConfigManager;
import org.little100.constructionWand.wand.WandType;

public class WandItemManager {
    private final Plugin plugin;
    private final I18nManager i18n;
    private final NamespacedKey wandTypeKey;
    private WandConfigManager configManager;
    public static final String DISPLAY_MODE_NUMBER = "number";
    public static final String DISPLAY_MODE_LEGACY = "legacy";

    public WandItemManager(Plugin plugin, I18nManager i18n) {
        this.plugin = plugin;
        this.i18n = i18n;
        this.wandTypeKey = new NamespacedKey(plugin, "wand_type");
        this.configManager = null;
    }

    public WandItemManager(Plugin plugin, I18nManager i18n, WandConfigManager configManager) {
        this.plugin = plugin;
        this.i18n = i18n;
        this.wandTypeKey = new NamespacedKey(plugin, "wand_type");
        this.configManager = configManager;
    }

    public void setConfigManager(WandConfigManager configManager) {
        this.configManager = configManager;
    }

    private String getDurabilityDisplayMode() {
        return this.plugin.getConfig().getString("display.durability-display", DISPLAY_MODE_NUMBER);
    }

    private int getProgressBarLength() {
        return this.plugin.getConfig().getInt("display.progress-bar-length", 10);
    }

    private String generateProgressBar(int current, int max) {
        int length = this.getProgressBarLength();
        if (max <= 0) {
            return "";
        }
        float percent = (float)current / (float)max;
        int filledBars = (int)((float)length * percent);
        String prefix = this.i18n.get("wand.lore.progress-bar-prefix");
        String suffix = this.i18n.get("wand.lore.progress-bar-suffix");
        String fullChar = this.i18n.get("wand.lore.progress-bar-full");
        String emptyChar = this.i18n.get("wand.lore.progress-bar-empty");
        StringBuilder bar = new StringBuilder();
        bar.append(prefix);
        for (int i = 0; i < length; ++i) {
            if (i < filledBars) {
                bar.append(fullChar);
                continue;
            }
            bar.append(emptyChar);
        }
        bar.append(suffix);
        return bar.toString();
    }

    public ItemStack createWand(WandType type) {
        return this.createWandWithMaterial(type, type.getBaseMaterial(), type.getCustomModelData());
    }

    public ItemStack createWandWithMaterial(WandType type, Material material, int customModelData) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        String nameKey = "wand." + type.getId() + ".name";
        meta.setDisplayName(this.i18n.get(nameKey));
        int maxBlocks = this.getConfigMaxBlocks(type);
        int maxDurability = this.getConfigDurability(type);
        boolean isUnbreakable = maxDurability == -1;
        String displayMode = this.getDurabilityDisplayMode();
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(String.valueOf(ChatColor.GRAY) + "\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
        lore.add(this.i18n.get("wand.lore.max-blocks", maxBlocks));
        if (isUnbreakable) {
            if (DISPLAY_MODE_LEGACY.equalsIgnoreCase(displayMode)) {
                lore.add(this.i18n.get("wand.lore.durability-legacy-infinite"));
            } else {
                lore.add(this.i18n.get("wand.lore.durability-infinite"));
            }
        } else if (DISPLAY_MODE_LEGACY.equalsIgnoreCase(displayMode)) {
            lore.add(this.i18n.get("wand.lore.durability-legacy", maxDurability, maxDurability));
            lore.add(this.generateProgressBar(maxDurability, maxDurability));
        } else {
            lore.add(this.i18n.get("wand.lore.durability", maxDurability));
        }
        lore.add(String.valueOf(ChatColor.GRAY) + "\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
        lore.add(this.i18n.get("wand.lore.usage-1"));
        lore.add(String.valueOf(ChatColor.GRAY) + "\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
        meta.setLore(lore);
        VersionHelper.setCustomModelData(meta, customModelData);
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        pdc.set(this.wandTypeKey, PersistentDataType.STRING, (Object)type.getId());
        if (isUnbreakable) {
            meta.setUnbreakable(true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
            meta.addEnchant(Enchantment.MENDING, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        item.setItemMeta(meta);
        VersionHelper.setCustomModelDataComponent(item, customModelData);
        return item;
    }

    public int getConfigMaxBlocks(WandType type) {
        if (this.configManager != null) {
            return this.configManager.getMaxBlocks(type);
        }
        return type.getMaxBlocks();
    }

    public int getConfigDurability(WandType type) {
        if (this.configManager != null) {
            return this.configManager.getDurability(type);
        }
        return type.getMaxDurability();
    }

    public boolean isWandEnabled(WandType type) {
        if (this.configManager != null) {
            return this.configManager.isEnabled(type);
        }
        return true;
    }

    public boolean isWand(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        if (pdc.has(this.wandTypeKey, PersistentDataType.STRING)) {
            return true;
        }
        int modelData = this.getCustomModelDataFromItem(item);
        return WandType.fromMaterialAndModelData(item.getType(), modelData) != null;
    }

    public WandType getWandType(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return null;
        }
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        if (pdc.has(this.wandTypeKey, PersistentDataType.STRING)) {
            String typeId = (String)pdc.get(this.wandTypeKey, PersistentDataType.STRING);
            return WandType.fromId(typeId);
        }
        int modelData = this.getCustomModelDataFromItem(item);
        return WandType.fromMaterialAndModelData(item.getType(), modelData);
    }

    private int getCustomModelDataFromItem(ItemStack item) {
        return VersionHelper.getCustomModelDataFromItem(item);
    }

    public int getCurrentDurability(ItemStack item) {
        if (item == null) {
            return 0;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta instanceof Damageable) {
            int maxDurability;
            Damageable damageable = (Damageable)meta;
            WandType type = this.getWandType(item);
            if (type != null && (maxDurability = this.getConfigDurability(type)) != -1) {
                return maxDurability - damageable.getDamage();
            }
        }
        return -1;
    }

    public boolean consumeDurability(ItemStack item, int amount) {
        WandType type = this.getWandType(item);
        if (type == null) {
            return false;
        }
        int maxDurability = this.getConfigDurability(type);
        if (maxDurability == -1) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta instanceof Damageable) {
            Damageable damageable = (Damageable)meta;
            int newDamage = damageable.getDamage() + amount;
            if (newDamage >= maxDurability) {
                return true;
            }
            damageable.setDamage(newDamage);
            item.setItemMeta(meta);
            this.updateWandDisplay(item);
        }
        return false;
    }

    public void repairWand(ItemStack item, int amount) {
        WandType type = this.getWandType(item);
        if (type == null) {
            return;
        }
        int maxDurability = this.getConfigDurability(type);
        if (maxDurability == -1) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta instanceof Damageable) {
            Damageable damageable = (Damageable)meta;
            int newDamage = Math.max(0, damageable.getDamage() - amount);
            damageable.setDamage(newDamage);
            item.setItemMeta(meta);
            this.updateWandDisplay(item);
        }
    }

    public NamespacedKey getWandTypeKey() {
        return this.wandTypeKey;
    }

    public boolean updateWandDisplay(ItemStack item) {
        int level;
        WandType type = this.getWandType(item);
        if (type == null) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        String nameKey = "wand." + type.getId() + ".name";
        meta.setDisplayName(this.i18n.get(nameKey));
        int baseMaxBlocks = this.getConfigMaxBlocks(type);
        int maxDurability = this.getConfigDurability(type);
        boolean isUnbreakable = maxDurability == -1;
        int currentDurability = this.getCurrentDurability(item);
        if (currentDurability == -1) {
            currentDurability = maxDurability;
        }
        String displayMode = this.getDurabilityDisplayMode();
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add(String.valueOf(ChatColor.GRAY) + "\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
        int maxBlocks = baseMaxBlocks;
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        NamespacedKey enchantKey = new NamespacedKey(this.plugin, "enchant_building_extension");
        if (pdc.has(enchantKey, PersistentDataType.INTEGER) && (level = ((Integer)pdc.getOrDefault(enchantKey, PersistentDataType.INTEGER, (Object)0)).intValue()) > 0) {
            double bonus = (double)level * 0.2;
            maxBlocks = (int)((double)maxBlocks * (1.0 + bonus));
        }
        lore.add(this.i18n.get("wand.lore.max-blocks", maxBlocks));
        if (isUnbreakable) {
            if (DISPLAY_MODE_LEGACY.equalsIgnoreCase(displayMode)) {
                lore.add(this.i18n.get("wand.lore.durability-legacy-infinite"));
            } else {
                lore.add(this.i18n.get("wand.lore.durability-infinite"));
            }
        } else if (DISPLAY_MODE_LEGACY.equalsIgnoreCase(displayMode)) {
            lore.add(this.i18n.get("wand.lore.durability-legacy", currentDurability, maxDurability));
            lore.add(this.generateProgressBar(currentDurability, maxDurability));
        } else {
            lore.add(this.i18n.get("wand.lore.durability", maxDurability));
        }
        lore.add(String.valueOf(ChatColor.GRAY) + "\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
        lore.add(this.i18n.get("wand.lore.usage-1"));
        lore.add(String.valueOf(ChatColor.GRAY) + "\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
        if (pdc.has(enchantKey, PersistentDataType.INTEGER) && (level = ((Integer)pdc.getOrDefault(enchantKey, PersistentDataType.INTEGER, (Object)0)).intValue()) > 0) {
            String enchantName = this.i18n.get("enchant.building_extension.name");
            String levelStr = this.toRomanNumeral(level);
            lore.add(enchantName + " " + levelStr);
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        return true;
    }

    private String toRomanNumeral(int number) {
        String[] numerals = new String[]{"", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X"};
        if (number >= 1 && number <= 10) {
            return numerals[number];
        }
        return String.valueOf(number);
    }

    public int updateAllWandsInInventory(Player player) {
        int count = 0;
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || !this.isWand(item) || !this.updateWandDisplay(item)) continue;
            ++count;
        }
        return count;
    }
}

