/*
 * Decompiled with CFR 0.152.
 */
package org.little100.constructionWand.wand;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.little100.constructionWand.wand.WandType;

public class WandConfigManager {
    private final Plugin plugin;
    private final Map<String, Boolean> enabledCache = new HashMap<String, Boolean>();
    private final Map<String, Integer> maxBlocksCache = new HashMap<String, Integer>();
    private final Map<String, Integer> durabilityCache = new HashMap<String, Integer>();

    public WandConfigManager(Plugin plugin) {
        this.plugin = plugin;
        this.loadConfig();
    }

    public void loadConfig() {
        this.enabledCache.clear();
        this.maxBlocksCache.clear();
        this.durabilityCache.clear();
        FileConfiguration config = this.plugin.getConfig();
        ConfigurationSection wandsSection = config.getConfigurationSection("wands");
        if (wandsSection == null) {
            this.plugin.getLogger().info("\u672a\u627e\u5230 wands \u914d\u7f6e\u8282\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c");
            return;
        }
        for (String wandId : wandsSection.getKeys(false)) {
            ConfigurationSection wandConfig = wandsSection.getConfigurationSection(wandId);
            if (wandConfig == null) continue;
            if (wandConfig.contains("enabled")) {
                this.enabledCache.put(wandId, wandConfig.getBoolean("enabled", true));
            }
            if (wandConfig.contains("max-blocks")) {
                this.maxBlocksCache.put(wandId, wandConfig.getInt("max-blocks"));
            }
            if (!wandConfig.contains("durability")) continue;
            this.durabilityCache.put(wandId, wandConfig.getInt("durability"));
        }
        this.plugin.getLogger().info("\u5df2\u52a0\u8f7d " + this.enabledCache.size() + " \u4e2a\u624b\u6756\u914d\u7f6e");
    }

    public void reloadConfig() {
        this.loadConfig();
    }

    public boolean isEnabled(WandType type) {
        return this.enabledCache.getOrDefault(type.getId(), true);
    }

    public boolean isEnabled(String wandId) {
        return this.enabledCache.getOrDefault(wandId, true);
    }

    public int getMaxBlocks(WandType type) {
        return this.maxBlocksCache.getOrDefault(type.getId(), type.getMaxBlocks());
    }

    public int getMaxBlocks(String wandId, int defaultValue) {
        return this.maxBlocksCache.getOrDefault(wandId, defaultValue);
    }

    public int getDurability(WandType type) {
        return this.durabilityCache.getOrDefault(type.getId(), type.getMaxDurability());
    }

    public int getDurability(String wandId, int defaultValue) {
        return this.durabilityCache.getOrDefault(wandId, defaultValue);
    }

    public boolean isUnbreakable(WandType type) {
        int durability = this.getDurability(type);
        return durability == -1;
    }
}

